/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.enums.AtomVarType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariable;
import nl.uu.cs.ape.utils.APEUtils;

public class SLTLxVariableOccurrenceCollection {
    private Map<SLTLxVariable, Set<PredicateLabel>> variableDataTypes = new HashMap<SLTLxVariable, Set<PredicateLabel>>();
    private Map<SLTLxVariable, Set<State>> variableMemoryReferences = new HashMap<SLTLxVariable, Set<State>>();
    private Map<Pair<SLTLxVariable>, Set<AtomVarType>> binaryPredicates = new HashMap<Pair<SLTLxVariable>, Set<AtomVarType>>();
    private Map<SLTLxVariable, Set<Pair<SLTLxVariable>>> variablePairs = new HashMap<SLTLxVariable, Set<Pair<SLTLxVariable>>>();

    public boolean addDataType(PredicateLabel dataType, SLTLxVariable variableState) {
        if (this.variableDataTypes.get(variableState) == null) {
            HashSet<PredicateLabel> preds = new HashSet<PredicateLabel>();
            boolean tmp = preds.add(dataType);
            this.variableDataTypes.put(variableState, preds);
            return tmp;
        }
        return this.variableDataTypes.get(variableState).add(dataType);
    }

    public boolean addMemoryReference(State usedState, SLTLxVariable variableState) {
        if (this.variableMemoryReferences.get(variableState) == null) {
            HashSet<State> preds = new HashSet<State>();
            boolean tmp = preds.add(usedState);
            this.variableMemoryReferences.put(variableState, preds);
            return tmp;
        }
        return this.variableMemoryReferences.get(variableState).add(usedState);
    }

    public void addBinaryPred(Pair<SLTLxVariable> varPair, AtomVarType relType) {
        HashSet<Pair<SLTLxVariable>> vars;
        if (relType.equals((Object)AtomVarType.VAR_VALUE)) {
            return;
        }
        if (this.variablePairs.get(varPair.getFirst()) == null) {
            vars = new HashSet<Pair<SLTLxVariable>>();
            vars.add(varPair);
            this.variablePairs.put(varPair.getFirst(), vars);
        } else {
            this.variablePairs.get(varPair.getFirst()).add(varPair);
        }
        if (this.variablePairs.get(varPair.getSecond()) == null) {
            vars = new HashSet();
            vars.add(varPair);
            this.variablePairs.put(varPair.getSecond(), vars);
        } else {
            this.variablePairs.get(varPair.getSecond()).add(varPair);
        }
        if (this.binaryPredicates.get(varPair) == null) {
            HashSet<AtomVarType> preds = new HashSet<AtomVarType>();
            preds.add(relType);
            this.binaryPredicates.put(varPair, preds);
        } else {
            this.binaryPredicates.get(varPair).add(relType);
        }
    }

    public Set<PredicateLabel> getDataTypes(SLTLxVariable satVariable) {
        HashSet unaryPreds = this.variableDataTypes.get(satVariable);
        return unaryPreds == null ? new HashSet() : unaryPreds;
    }

    public Set<State> getMemoryReferences(SLTLxVariable satVariable) {
        HashSet unaryPreds = this.variableMemoryReferences.get(satVariable);
        return unaryPreds == null ? new HashSet() : unaryPreds;
    }

    public Set<AtomVarType> getBinaryPredicates(Pair<SLTLxVariable> varPair) {
        HashSet binPreds = this.binaryPredicates.get(varPair);
        return binPreds == null ? new HashSet() : binPreds;
    }

    public Set<Pair<SLTLxVariable>> getPairsContainingVarAsArg(SLTLxVariable variable) {
        HashSet<Pair<SLTLxVariable>> pairs = new HashSet<Pair<SLTLxVariable>>();
        for (Pair pair : APEUtils.safe(this.variablePairs.get(variable))) {
            pairs.add(pair);
        }
        return pairs;
    }
}

