/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.parserSLTLx;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.enums.AtomVarType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxEquivalence;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxExists;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFinally;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxForall;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxGlobally;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegation;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNext;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNextOp;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxOperation;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxParsingAnnotationException;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxParsingBaseErrorListener;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxParsingGrammarException;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxUntil;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariable;
import nl.uu.cs.ape.parserSLTLx.sltlx2cnf.SLTLxBaseVisitor;
import nl.uu.cs.ape.parserSLTLx.sltlx2cnf.SLTLxLexer;
import nl.uu.cs.ape.parserSLTLx.sltlx2cnf.SLTLxParser;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;
import nl.uu.cs.ape.utils.APEUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLTLxSATVisitor
extends SLTLxBaseVisitor<SLTLxFormula> {
    private static final Logger log = LoggerFactory.getLogger(SLTLxSATVisitor.class);
    static int usedState = 0;
    int memIndexFactor;
    private final AllTypes allTypes;
    private final AllModules allModules;
    private String ontologyPrexifIRI;

    public SLTLxSATVisitor(SATSynthesisEngine synthesisEngine) {
        this.ontologyPrexifIRI = synthesisEngine.getDomainSetup().getOntologyPrefixIRI();
        this.allTypes = synthesisEngine.getDomainSetup().getAllTypes();
        this.allModules = synthesisEngine.getDomainSetup().getAllModules();
    }

    public static Set<SLTLxFormula> parseFormula(SATSynthesisEngine synthesisEngine, String formulasInSLTLx) throws SLTLxParsingGrammarException, SLTLxParsingAnnotationException {
        HashSet<SLTLxFormula> facts = new HashSet<SLTLxFormula>();
        SLTLxLexer lexer = new SLTLxLexer((CharStream)CharStreams.fromString((String)formulasInSLTLx));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)SLTLxParsingBaseErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SLTLxParser parser = new SLTLxParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)SLTLxParsingBaseErrorListener.INSTANCE);
        SLTLxParser.FormulaContext tree = parser.formula();
        SLTLxSATVisitor visitor = new SLTLxSATVisitor(synthesisEngine);
        SLTLxFormula res = (SLTLxFormula)visitor.visit((ParseTree)tree);
        facts.add(res);
        return facts;
    }

    @Override
    public SLTLxFormula visitCondition(SLTLxParser.ConditionContext ctx) {
        HashSet<SLTLxFormula> result = new HashSet<SLTLxFormula>();
        int n = ctx.getChildCount();
        for (int i = 0; i < n; ++i) {
            ParseTree c = ctx.getChild(i);
            SLTLxFormula childResult = (SLTLxFormula)c.accept((ParseTreeVisitor)this);
            result.add(childResult);
        }
        SLTLxConjunction allForulas = new SLTLxConjunction(result);
        return allForulas;
    }

    @Override
    public SLTLxFormula visitToolRef(SLTLxParser.ToolRefContext ctx) {
        SLTLxFormula tool = (SLTLxFormula)this.visit(ctx.getChild(1));
        SLTLxFormula formula = (SLTLxFormula)this.visit(ctx.getChild(3));
        return new SLTLxNextOp(tool, formula);
    }

    @Override
    public SLTLxFormula visitUnaryModal(SLTLxParser.UnaryModalContext ctx) {
        SLTLxFormula subFormula = (SLTLxFormula)this.visit(ctx.getChild(1));
        if (ctx.getChild(0).getText().equals("G")) {
            return new SLTLxGlobally(subFormula);
        }
        if (ctx.getChild(0).getText().equals("F")) {
            return new SLTLxFinally(subFormula);
        }
        if (ctx.getChild(0).getText().equals("X")) {
            return new SLTLxNext(subFormula);
        }
        log.warn("Modal operation '" + ctx.getChild(1).getText() + "' is not recognised.");
        return null;
    }

    @Override
    public SLTLxFormula visitTrue(SLTLxParser.TrueContext ctx) {
        if (ctx.getChild(0).getText().equals("true")) {
            return SLTLxAtom.getTrue();
        }
        return SLTLxAtom.getFalse();
    }

    @Override
    public SLTLxFormula visitNegUnary(SLTLxParser.NegUnaryContext ctx) {
        SLTLxFormula subFormula = (SLTLxFormula)this.visit(ctx.getChild(1));
        return new SLTLxNegation(subFormula);
    }

    @Override
    public SLTLxFormula visitBinaryBool(SLTLxParser.BinaryBoolContext ctx) {
        SLTLxFormula subFormula1 = (SLTLxFormula)this.visit(ctx.getChild(0));
        SLTLxFormula subFormula2 = (SLTLxFormula)this.visit(ctx.getChild(2));
        if (ctx.getChild(1).getText().equals("|")) {
            return new SLTLxDisjunction(subFormula1, subFormula2);
        }
        if (ctx.getChild(1).getText().equals("&")) {
            return new SLTLxConjunction(subFormula1, subFormula2);
        }
        if (ctx.getChild(1).getText().equals("->")) {
            return new SLTLxImplication(subFormula1, subFormula2);
        }
        if (ctx.getChild(1).getText().equals("<->")) {
            return new SLTLxEquivalence(subFormula1, subFormula2);
        }
        log.warn("Binary operation '" + ctx.getChild(1).getText() + "' is not recognised.");
        return null;
    }

    @Override
    public SLTLxFormula visitForall(SLTLxParser.ForallContext ctx) {
        SLTLxVariable variable = new SLTLxVariable(ctx.getChild(2).getText());
        SLTLxFormula subFormula = (SLTLxFormula)this.visit(ctx.getChild(4));
        return new SLTLxForall(variable, subFormula);
    }

    @Override
    public SLTLxFormula visitFunction(SLTLxParser.FunctionContext ctx) {
        String typePredicateID = ctx.getChild(0).getText().replace("'", "");
        String variableID = ctx.getChild(2).getText();
        TaxonomyPredicate typePred = this.allTypes.get(typePredicateID);
        if (typePred == null) {
            String typePredIRI = APEUtils.createClassIRI(typePredicateID, this.ontologyPrexifIRI);
            typePred = this.allTypes.get(typePredIRI);
        }
        if (typePred == null) {
            throw SLTLxParsingAnnotationException.typeDoesNoExists("Data type '" + typePredicateID + "' does not exist in the taxonomy.");
        }
        return new SLTLxAtomVar(AtomVarType.TYPE_V, typePred, new SLTLxVariable(variableID));
    }

    @Override
    public SLTLxFormula visitExists(SLTLxParser.ExistsContext ctx) {
        SLTLxVariable variable = new SLTLxVariable(ctx.getChild(2).getText());
        SLTLxFormula subFormula = (SLTLxFormula)this.visit(ctx.getChild(4));
        return new SLTLxExists(variable, subFormula);
    }

    @Override
    public SLTLxFormula visitBinaryModal(SLTLxParser.BinaryModalContext ctx) {
        SLTLxFormula subFormula1 = (SLTLxFormula)this.visit(ctx.getChild(1));
        SLTLxFormula subFormula2 = (SLTLxFormula)this.visit(ctx.getChild(2));
        return new SLTLxUntil(subFormula1, subFormula2);
    }

    @Override
    public SLTLxFormula visitBrackets(SLTLxParser.BracketsContext ctx) {
        return (SLTLxFormula)this.visit(ctx.getChild(1));
    }

    @Override
    public SLTLxFormula visitR_relation(SLTLxParser.R_relationContext ctx) {
        String variableID1 = ctx.getChild(2).getText();
        String variableID2 = ctx.getChild(4).getText();
        return new SLTLxAtomVar(AtomVarType.R_RELATION_V, new SLTLxVariable(variableID1), new SLTLxVariable(variableID2));
    }

    @Override
    public SLTLxFormula visitVarEq(SLTLxParser.VarEqContext ctx) {
        String variableID1 = ctx.getChild(0).getText();
        String variableID2 = ctx.getChild(2).getText();
        return new SLTLxAtomVar(AtomVarType.VAR_EQUIVALENCE, new SLTLxVariable(variableID1), new SLTLxVariable(variableID2));
    }

    @Override
    public SLTLxFormula visitModule(SLTLxParser.ModuleContext ctx) {
        String operationID = ctx.getChild(0).getText().replace("'", "");
        AbstractModule currOperation = this.allModules.get(operationID);
        if (currOperation == null) {
            String operationIRI = APEUtils.createClassIRI(operationID, this.ontologyPrexifIRI);
            currOperation = this.allModules.get(operationIRI);
        }
        if (currOperation == null) {
            throw SLTLxParsingAnnotationException.moduleDoesNoExists("Operation '" + operationID + "' does not exist in the taxonomy/tool annotations.");
        }
        ArrayList<SLTLxVariable> inputs = new ArrayList<SLTLxVariable>();
        ParseTree inputElems = ctx.getChild(2);
        for (int i = 0; i < inputElems.getChildCount(); i += 2) {
            String variableID = inputElems.getChild(i).getText();
            inputs.add(new SLTLxVariable(variableID));
        }
        ArrayList<SLTLxVariable> outputs = new ArrayList<SLTLxVariable>();
        ParseTree outputElems = ctx.getChild(4);
        for (int i = 0; i < outputElems.getChildCount(); i += 2) {
            String variableID = outputElems.getChild(i).getText();
            outputs.add(new SLTLxVariable(variableID));
        }
        return new SLTLxOperation(currOperation, inputs, outputs);
    }
}

