/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver;

import java.util.ArrayList;
import java.util.List;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.solver.SynthesisEngine;

public abstract class ModuleUtils {
    public String encodeModuleAnnotations(Class<? extends SynthesisEngine> synthesisInstance) {
        StringBuilder constraints = new StringBuilder();
        constraints.append(this.inputCons(synthesisInstance));
        constraints.append(this.outputCons(synthesisInstance));
        return constraints.toString();
    }

    public String encodeMemoryStructure(Class<? extends SynthesisEngine> synthesisInstance) {
        StringBuilder constraints = new StringBuilder();
        constraints.append(this.allowDataReferencingCons(synthesisInstance));
        constraints.append(this.enforcingUsageOfGeneratedTypesCons(synthesisInstance));
        constraints.append(this.enforceDataReferenceRules(synthesisInstance));
        return constraints.toString();
    }

    public String encodeDataInstanceDependencyCons(TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        constraints.append(this.allowDataDependencyCons(typeAutomaton, mappings));
        constraints.append(this.enforceDataDependencyOverModules(typeAutomaton, mappings));
        constraints.append(this.enforceDataDependencyOverDataReferencing(typeAutomaton, mappings));
        return constraints.toString();
    }

    public abstract String inputCons(Class<? extends SynthesisEngine> var1);

    public abstract String enforceDataReferenceRules(Class<? extends SynthesisEngine> var1);

    public abstract String allowDataReferencingCons(Class<? extends SynthesisEngine> var1);

    public abstract String allowDataDependencyCons(TypeAutomaton var1, SATAtomMappings var2);

    public abstract String enforceDataDependencyOverDataReferencing(TypeAutomaton var1, SATAtomMappings var2);

    public abstract String enforceDataDependencyOverModules(TypeAutomaton var1, SATAtomMappings var2);

    public abstract String enforcingUsageOfGeneratedTypesCons(Class<? extends SynthesisEngine> var1);

    public abstract String outputCons(Class<? extends SynthesisEngine> var1);

    public abstract String moduleMutualExclusion(AllModules var1, ModuleAutomaton var2, SATAtomMappings var3);

    public abstract String moduleMandatoryUsage(AllModules var1, ModuleAutomaton var2, SATAtomMappings var3);

    public abstract String moduleEnforceTaxonomyStructure(AllModules var1, TaxonomyPredicate var2, ModuleAutomaton var3, SATAtomMappings var4);

    public static List<Pair<PredicateLabel>> getPredicatePairs(List<? extends PredicateLabel> predicateList) {
        ArrayList<Pair<PredicateLabel>> pairs = new ArrayList<Pair<PredicateLabel>>();
        for (int i = 0; i < predicateList.size() - 1; ++i) {
            for (int j = i + 1; j < predicateList.size(); ++j) {
                pairs.add(new Pair<PredicateLabel>(predicateList.get(i), predicateList.get(j)));
            }
        }
        return pairs;
    }
}

