/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.minisat;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.Automaton;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegation;

public class EnforceSLTLxRelatedRules {
    private EnforceSLTLxRelatedRules() {
    }

    public static Collection<SLTLxFormula> setTrueFalse() {
        HashSet<SLTLxFormula> cnfEncoding = new HashSet<SLTLxFormula>();
        cnfEncoding.add(SLTLxAtom.getTrue());
        cnfEncoding.add(new SLTLxNegation(SLTLxAtom.getFalse()));
        return cnfEncoding;
    }

    public static Set<SLTLxFormula> preserveAuxiliaryPredicateRules(ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, List<AuxiliaryPredicate> helperPredicates) {
        HashSet<SLTLxFormula> cnfEncoding = new HashSet<SLTLxFormula>();
        Automaton automaton = null;
        AtomType workflowElem = null;
        for (AuxiliaryPredicate helperPredicate : helperPredicates) {
            automaton = helperPredicate.getGeneralizedPredicates().first() instanceof Type ? typeAutomaton : moduleAutomaton;
            for (State currState : automaton.getAllStates()) {
                workflowElem = currState.getWorkflowStateType();
                if (helperPredicate.getLogicOp() == LogicOperation.OR) {
                    HashSet allORPossibilities = new HashSet();
                    for (TaxonomyPredicate subLabel : helperPredicate.getGeneralizedPredicates()) {
                        allORPossibilities.add(new SLTLxAtom(workflowElem, subLabel, currState));
                    }
                    cnfEncoding.add(new SLTLxImplication(new SLTLxAtom(workflowElem, helperPredicate, currState), new SLTLxDisjunction(allORPossibilities)));
                    for (TaxonomyPredicate subLabel : helperPredicate.getGeneralizedPredicates()) {
                        cnfEncoding.add(new SLTLxImplication(new SLTLxAtom(workflowElem, subLabel, currState), new SLTLxAtom(workflowElem, helperPredicate, currState)));
                    }
                    continue;
                }
                if (helperPredicate.getLogicOp() != LogicOperation.AND) continue;
                for (TaxonomyPredicate subLabel : helperPredicate.getGeneralizedPredicates()) {
                    cnfEncoding.add(new SLTLxImplication(new SLTLxAtom(workflowElem, helperPredicate, currState), new SLTLxAtom(workflowElem, subLabel, currState)));
                }
                HashSet<SLTLxFormula> allANDPossibilities = new HashSet<SLTLxFormula>();
                for (TaxonomyPredicate subLabel : helperPredicate.getGeneralizedPredicates()) {
                    allANDPossibilities.add(new SLTLxNegation(new SLTLxAtom(workflowElem, subLabel, currState)));
                }
                allANDPossibilities.add(new SLTLxAtom(workflowElem, helperPredicate, currState));
                cnfEncoding.add(new SLTLxDisjunction(allANDPossibilities));
            }
        }
        return cnfEncoding;
    }
}

