/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.minisat;

import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.ConstraintTemplateData;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.parserSLTLx.SLTLxSATVisitor;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatEncodingUtils {
    private static final Logger log = LoggerFactory.getLogger(SatEncodingUtils.class);

    public static String encodeAPEConstraints(SATSynthesisEngine synthesisEngine, APEDomainSetup domainSetup, SATAtomMappings mappings, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton) {
        StringBuilder cnfSLTLx = new StringBuilder();
        int currConst = 0;
        for (ConstraintTemplateData constraintTemplateData : domainSetup.getUnformattedConstr()) {
            ++currConst;
            if (domainSetup.getConstraintTemplate(constraintTemplateData.getConstraintID()) == null) {
                log.warn("Constraint ID provided: '" + constraintTemplateData.getConstraintID() + "' is not valid. Constraint skipped.");
                continue;
            }
            String currConstrEncoding = SatEncodingUtils.constraintSATEncoding(constraintTemplateData.getConstraintID(), constraintTemplateData.getParameters(), domainSetup, moduleAutomaton, typeAutomaton, mappings);
            if (currConstrEncoding == null) {
                log.warn("Error in constraint file. Constraint no: " + currConst + ". Constraint skipped.");
                continue;
            }
            cnfSLTLx.append(currConstrEncoding);
        }
        for (String string : domainSetup.getSLTLxConstraints()) {
            Set<SLTLxFormula> sltlxFormulas = SLTLxSATVisitor.parseFormula(synthesisEngine, string);
            for (SLTLxFormula sltlxFormula : sltlxFormulas) {
                sltlxFormula.getConstraintCNFEncoding(synthesisEngine).forEach(cnfSLTLx::append);
            }
        }
        return cnfSLTLx.toString();
    }

    public static String constraintSATEncoding(String constraintID, List<TaxonomyPredicate> list, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        return domainSetup.getConstraintTemplate(constraintID).getConstraint(list, domainSetup, moduleAutomaton, typeAutomaton, mappings);
    }

    private SatEncodingUtils() {
    }
}

