/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflowNode;
import nl.uu.cs.ape.solver.solutionStructure.TypeNode;
import nl.uu.cs.ape.utils.APEUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleNode
extends SolutionWorkflowNode {
    private static final Logger log = LoggerFactory.getLogger(ModuleNode.class);
    private Module usedModule = null;
    private Set<AbstractModule> abstractModules = new HashSet<AbstractModule>();
    private ModuleNode nextModuleNode = null;
    private ModuleNode prevModuleNode = null;
    private List<TypeNode> inputTypes;
    private List<TypeNode> outputTypes;

    public ModuleNode(State automatonState) throws ExceptionInInitializerError {
        super(automatonState);
        if (automatonState.getWorkflowStateType() != AtomType.MODULE) {
            throw new ExceptionInInitializerError("Class ModuleNode can only be instantiated using State that is of type AtomType. MODULE, as a parameter.");
        }
        this.inputTypes = new ArrayList<TypeNode>();
        this.outputTypes = new ArrayList<TypeNode>();
    }

    public void setUsedModule(Module module) {
        this.usedModule = module;
    }

    public void addAbstractDescriptionOfUsedType(AbstractModule abstractModule) {
        if (!abstractModule.isSimplePredicate()) {
            this.abstractModules.add(abstractModule);
        } else {
            log.warn("A concrete tool  cannot be used to describe an abstract module.");
        }
    }

    public void addInputType(TypeNode inputTypeNode) {
        this.inputTypes.add(inputTypeNode);
    }

    public void setInputType(int inputIndex, TypeNode memoryTypeNode) {
        APEUtils.safeSet(this.inputTypes, inputIndex, memoryTypeNode);
    }

    public void addOutputType(TypeNode outputTypeNode) {
        this.outputTypes.add(outputTypeNode);
    }

    public void setNextModuleNode(ModuleNode nextModuleNode) {
        this.nextModuleNode = nextModuleNode;
    }

    public void setPrevModuleNode(ModuleNode prevModuleNode) {
        this.prevModuleNode = prevModuleNode;
    }

    public Module getUsedModule() {
        return this.usedModule;
    }

    public Set<AbstractModule> getAbstractModules() {
        return this.abstractModules;
    }

    public ModuleNode getNextModuleNode() {
        return this.nextModuleNode;
    }

    public boolean hasNextModule() {
        return this.nextModuleNode != null;
    }

    public boolean hasPrevModule() {
        return this.prevModuleNode != null;
    }

    public ModuleNode getPrevModuleNode() {
        return this.prevModuleNode;
    }

    public List<TypeNode> getInputTypes() {
        return this.inputTypes;
    }

    public boolean hasInputTypes() {
        return !this.inputTypes.stream().filter(typeNode -> !typeNode.isEmpty()).collect(Collectors.toList()).isEmpty();
    }

    public List<TypeNode> getOutputTypes() {
        return this.outputTypes;
    }

    public boolean hasOutputTypes() {
        return !this.outputTypes.stream().filter(typeNode -> !typeNode.isEmpty()).collect(Collectors.toList()).isEmpty();
    }

    public boolean isEmpty() {
        return this.usedModule == null;
    }

    public String toString() {
        if (this.usedModule == null) {
            return "[]";
        }
        StringBuilder printString = new StringBuilder();
        printString.append("[").append(this.usedModule.getPredicateID()).append("]");
        return printString.toString();
    }

    public String getDotDefinition() {
        return this.getNodeID() + " [label=\"" + this.getNodeLabel() + "\", shape=box];\n";
    }

    public Graph addModuleToGraph(Graph workflowGraph) {
        return workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)this.getNodeID()).with((Attributes)Label.of((String)this.getNodeLabel()), (Attributes)Shape.RECTANGLE, (Attributes)Color.BLUE, (Attributes)Style.BOLD)});
    }

    public Graph addTavernaStyleModuleToGraph(Graph workflowGraph) {
        return workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)this.getNodeID()).with((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"F8FFB0").fill(), (Attributes)Label.html((String)this.getNodeGraphLabel()), (Attributes)Shape.RECTANGLE)});
    }

    @Override
    public String getNodeID() {
        StringBuilder printString = new StringBuilder();
        printString.append("\"").append(this.usedModule.getPredicateID());
        printString.append("_").append(super.getAutomatonState().getPredicateID()).append("\"");
        return printString.toString();
    }

    @Override
    public String getNodeLabel() {
        return this.usedModule.getPredicateLabel();
    }

    public String getNodeGraphLabel() {
        return "<b>" + this.usedModule.getPredicateLabel() + "</b>";
    }

    @Override
    public String getNodeLongLabel() {
        return this.usedModule.getPredicateLongLabel();
    }
}

