/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure;

import guru.nidi.graphviz.attribute.Rank;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxLiteral;
import nl.uu.cs.ape.solver.SolutionInterpreter;
import nl.uu.cs.ape.solver.minisat.SATOutput;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;
import nl.uu.cs.ape.solver.solutionStructure.ModuleNode;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflowNode;
import nl.uu.cs.ape.solver.solutionStructure.TypeNode;
import nl.uu.cs.ape.solver.solutionStructure.graphviz.SolutionGraph;
import nl.uu.cs.ape.solver.solutionStructure.graphviz.SolutionGraphFactory;
import nl.uu.cs.ape.utils.APEUtils;

public class SolutionWorkflow {
    private static final String fileNamePrefix = "candidate_workflow_";
    private List<ModuleNode> moduleNodes;
    private List<TypeNode> workflowInputTypeStates;
    private List<TypeNode> workflowOutputTypeStates;
    private Map<State, ModuleNode> mappedModuleNodes;
    private Map<State, TypeNode> mappedMemoryTypeNodes;
    private Map<State, ModuleNode> usedType2ToolMap;
    private SolutionInterpreter nativeSolution;
    private SolutionGraph controlflowGraph;
    private SolutionGraph dataflowGraph;
    private SolutionGraph tavernaStyleGraph;
    private final AtomicReference<Object> scriptExecution = new AtomicReference();
    private final AtomicReference<Object> graphDotFormat = new AtomicReference();
    private final AtomicReference<Object> readableSolution = new AtomicReference();
    private int index;

    private SolutionWorkflow(ModuleAutomaton toolAutomaton, TypeAutomaton typeAutomaton) throws ExceptionInInitializerError {
        this.moduleNodes = new ArrayList<ModuleNode>();
        this.workflowInputTypeStates = new ArrayList<TypeNode>();
        this.workflowOutputTypeStates = new ArrayList<TypeNode>();
        this.mappedModuleNodes = new HashMap<State, ModuleNode>();
        this.mappedMemoryTypeNodes = new HashMap<State, TypeNode>();
        this.usedType2ToolMap = new HashMap<State, ModuleNode>();
        ModuleNode prev = null;
        for (State currState : toolAutomaton.getAllStates()) {
            ModuleNode currNode = new ModuleNode(currState);
            currNode.setPrevModuleNode(prev);
            if (prev != null) {
                prev.setNextModuleNode(currNode);
            }
            this.moduleNodes.add(currNode);
            this.mappedModuleNodes.put(currState, currNode);
            prev = currNode;
        }
        for (Block currBlock : typeAutomaton.getMemoryTypesBlocks()) {
            ModuleNode typeGenerator = APEUtils.safeGet(this.moduleNodes, currBlock.getBlockNumber() - 1);
            for (State currState : currBlock.getStates()) {
                TypeNode currTypeNode = new TypeNode(currState);
                currTypeNode.setCreatedByModule(typeGenerator);
                if (typeGenerator != null) {
                    typeGenerator.addOutputType(currTypeNode);
                }
                this.mappedMemoryTypeNodes.put(currState, currTypeNode);
                if (currBlock.getBlockNumber() == 0) {
                    this.workflowInputTypeStates.add(currTypeNode);
                    continue;
                }
                if (currBlock.getBlockNumber() != toolAutomaton.size()) continue;
            }
        }
        for (Block currBlock : typeAutomaton.getUsedTypesBlocks()) {
            ModuleNode inputForTool = APEUtils.safeGet(this.moduleNodes, currBlock.getBlockNumber());
            for (State currState : currBlock.getStates()) {
                this.usedType2ToolMap.put(currState, inputForTool);
            }
        }
    }

    public SolutionWorkflow(int[] satSolution, SATSynthesisEngine synthesisInstance) {
        this(synthesisInstance.getModuleAutomaton(), synthesisInstance.getTypeAutomaton());
        this.nativeSolution = new SATOutput(satSolution, synthesisInstance);
        for (int mappedLiteral : satSolution) {
            SolutionWorkflowNode currNode;
            SLTLxLiteral currLiteral;
            if (mappedLiteral < synthesisInstance.getMappings().getInitialNumOfMappedAtoms() || (currLiteral = new SLTLxLiteral(Integer.toString(mappedLiteral), synthesisInstance.getMappings())).isNegated() || currLiteral.getPredicate() instanceof AuxiliaryPredicate || currLiteral.isWorkflowElementType(AtomType.USED_TYPE) && ((Type)currLiteral.getPredicate()).isSimplePredicate() || currLiteral.isWorkflowElementType(AtomType.R_RELATION)) continue;
            if (currLiteral.isWorkflowElementType(AtomType.MODULE)) {
                currNode = this.mappedModuleNodes.get(currLiteral.getUsedInStateArgument());
                if (currLiteral.getPredicate() instanceof Module) {
                    ((ModuleNode)currNode).setUsedModule((Module)currLiteral.getPredicate());
                    continue;
                }
                ((ModuleNode)currNode).addAbstractDescriptionOfUsedType((AbstractModule)currLiteral.getPredicate());
                continue;
            }
            if (currLiteral.isWorkflowElementType(AtomType.MEMORY_TYPE)) {
                currNode = this.mappedMemoryTypeNodes.get(currLiteral.getUsedInStateArgument());
                if (currLiteral.getPredicate() instanceof Type && ((Type)currLiteral.getPredicate()).isNodeType(NodeType.LEAF)) {
                    ((TypeNode)currNode).addUsedType((Type)currLiteral.getPredicate());
                    continue;
                }
                if (!(currLiteral.getPredicate() instanceof Type) || ((Type)currLiteral.getPredicate()).isNodeType(NodeType.EMPTY_LABEL)) continue;
                ((TypeNode)currNode).addAbstractDescriptionOfUsedType((Type)currLiteral.getPredicate());
                continue;
            }
            if (!currLiteral.isWorkflowElementType(AtomType.MEM_TYPE_REFERENCE) || ((State)currLiteral.getPredicate()).getAbsoluteStateNumber() == -1) continue;
            ModuleNode usedTypeNode = this.usedType2ToolMap.get(currLiteral.getUsedInStateArgument());
            TypeNode memoryTypeNode = this.mappedMemoryTypeNodes.get(currLiteral.getPredicate());
            int inputIndex = currLiteral.getUsedInStateArgument().getLocalStateNumber();
            if (usedTypeNode != null) {
                usedTypeNode.setInputType(inputIndex, memoryTypeNode);
            } else {
                APEUtils.safeSet(this.workflowOutputTypeStates, inputIndex, memoryTypeNode);
            }
            memoryTypeNode.addUsedByTool(usedTypeNode);
        }
        this.workflowInputTypeStates.removeIf(TypeNode::isEmpty);
        this.workflowOutputTypeStates.removeIf(TypeNode::isEmpty);
    }

    public SolutionGraph getDataflowGraph(String title, Rank.RankDir orientation) {
        if (this.dataflowGraph == null) {
            this.dataflowGraph = SolutionGraphFactory.generateDataFlowGraph(this, title, orientation);
        }
        return this.dataflowGraph;
    }

    public SolutionGraph getControlflowGraph(String title, Rank.RankDir orientation) {
        if (this.controlflowGraph == null) {
            this.controlflowGraph = SolutionGraphFactory.generateControlflowGraph(this, title, orientation);
        }
        return this.controlflowGraph;
    }

    public SolutionGraph getTavernaStyleGraph(String title) {
        if (this.tavernaStyleGraph == null) {
            this.tavernaStyleGraph = SolutionGraphFactory.generateTavernaDesignGraph(this, title);
        }
        return this.tavernaStyleGraph;
    }

    public String getFileName() {
        return String.format("%s%o", SolutionWorkflow.getFileNamePrefix(), this.getIndex() + 1);
    }

    public String getDescriptiveName() {
        StringBuilder descrName = new StringBuilder();
        this.moduleNodes.forEach(moduleNode -> descrName.append(moduleNode.getUsedModule().getPredicateLabel()).append("->"));
        descrName.delete(descrName.length() - 2, descrName.length());
        return descrName.toString();
    }

    public String getDescription() {
        StringBuilder descrName = new StringBuilder();
        int stepNo = 1;
        for (ModuleNode moduleNode : this.moduleNodes) {
            descrName.append("Step ").append(stepNo++).append(": ").append(moduleNode.getUsedModule().getPredicateLabel()).append("\n");
        }
        descrName.delete(descrName.length() - 1, descrName.length());
        return descrName.toString();
    }

    public int getSolutionLength() {
        return this.moduleNodes.size();
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public static String getFileNamePrefix() {
        return fileNamePrefix;
    }

    public List<ModuleNode> getModuleNodes() {
        return this.moduleNodes;
    }

    public List<TypeNode> getWorkflowInputTypeStates() {
        return this.workflowInputTypeStates;
    }

    public List<TypeNode> getWorkflowOutputTypeStates() {
        return this.workflowOutputTypeStates;
    }

    public SolutionInterpreter getNativeSolution() {
        return this.nativeSolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptExecution() {
        Object value = this.scriptExecution.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.scriptExecution;
            synchronized (atomicReference) {
                value = this.scriptExecution.get();
                if (value == null) {
                    String actualValue = SolutionGraphFactory.generateScriptExecution(this);
                    value = actualValue == null ? this.scriptExecution : actualValue;
                    this.scriptExecution.set(value);
                }
            }
        }
        return (String)(value == this.scriptExecution ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGraphDotFormat() {
        Object value = this.graphDotFormat.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.graphDotFormat;
            synchronized (atomicReference) {
                value = this.graphDotFormat.get();
                if (value == null) {
                    String actualValue = SolutionGraphFactory.generateSolutionDotFormat(this);
                    value = actualValue == null ? this.graphDotFormat : actualValue;
                    this.graphDotFormat.set(value);
                }
            }
        }
        return (String)(value == this.graphDotFormat ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReadableSolution() {
        Object value = this.readableSolution.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.readableSolution;
            synchronized (atomicReference) {
                value = this.readableSolution.get();
                if (value == null) {
                    String actualValue = SolutionGraphFactory.generateReadableSolution(this);
                    value = actualValue == null ? this.readableSolution : actualValue;
                    this.readableSolution.set(value);
                }
            }
        }
        return (String)(value == this.readableSolution ? null : value);
    }
}

