/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.enums.SolverType;
import nl.uu.cs.ape.models.enums.SynthesisFlag;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionsList {
    private static final Logger log = LoggerFactory.getLogger(SolutionsList.class);
    private List<SolutionWorkflow> solutions = new ArrayList<SolutionWorkflow>();
    private final int maxSolutions;
    private final SATAtomMappings mappings;
    private int solutionIndex = 0;
    private final APERunConfig runConfig;
    private SynthesisFlag runFlag;
    private long synthesisTimeMS;
    private List<Pair<Integer>> solutionsPerLength;

    public SolutionsList(APERunConfig runConfig) {
        this.runConfig = runConfig;
        if (runConfig.getSolverType() != SolverType.SAT) {
            throw new APEConfigException("Solver type has to be SAT.");
        }
        this.mappings = new SATAtomMappings();
        this.maxSolutions = runConfig.getMaxNoSolutions();
        if (this.maxSolutions > 100) {
            log.info("Looking for " + this.maxSolutions + " solutions might take some time.");
        }
    }

    public int getNumberOfSolutions() {
        return this.solutions.size();
    }

    public int getMaxNumberOfSolutions() {
        return this.maxSolutions;
    }

    public SATAtomMappings getMappings() {
        return this.mappings;
    }

    public boolean isEmpty() {
        return this.solutions.isEmpty();
    }

    public APERunConfig getRunConfiguration() {
        return this.runConfig;
    }

    public boolean addSolutions(List<SolutionWorkflow> currSolutions) {
        for (SolutionWorkflow solution : currSolutions) {
            solution.setIndex(this.solutionIndex++);
            this.solutions.add(solution);
        }
        return false;
    }

    public SolutionWorkflow get(int index) {
        return this.solutions.get(index);
    }

    public int size() {
        return this.solutions.size();
    }

    public void addNoSolutionsForLength(Integer length, Integer noSolutions) {
        if (noSolutions == 0) {
            return;
        }
        if (this.solutionsPerLength == null) {
            this.solutionsPerLength = new ArrayList<Pair<Integer>>();
        }
        this.solutionsPerLength.add(new Pair<Integer>(length, noSolutions));
    }

    public List<Pair<Integer>> getSolutionsPerLength() {
        return this.solutionsPerLength;
    }

    public Stream<SolutionWorkflow> getStream() {
        return this.solutions.stream();
    }

    public Stream<SolutionWorkflow> getParallelStream() {
        return this.solutions.parallelStream();
    }

    public void setFlag(SynthesisFlag flag) {
        this.runFlag = flag;
    }

    public SynthesisFlag getFlag() {
        return this.runFlag;
    }

    public long getSolvingTime() {
        return this.synthesisTimeMS;
    }

    public void setSolvingTime(long synthesisTimeMS) {
        this.synthesisTimeMS = synthesisTimeMS;
    }
}

