/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure.cwl;

import java.util.HashMap;
import java.util.List;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.solver.solutionStructure.ModuleNode;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.solver.solutionStructure.TypeNode;
import nl.uu.cs.ape.solver.solutionStructure.cwl.CWLCreatorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCWLCreator
extends CWLCreatorBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractCWLCreator.class);
    private final HashMap<String, String> workflowParameters = new HashMap();

    public AbstractCWLCreator(SolutionWorkflow solution) {
        super(solution);
    }

    @Override
    public String getCWLVersion() {
        return "v1.2.0-dev2";
    }

    @Override
    protected void generateCWLRepresentation() {
        this.generateWorkflowInputs();
        this.generateWorkflowOutputs();
        this.generateWorkflowSteps();
    }

    private void generateWorkflowInputs() {
        this.cwlRepresentation.append("inputs:").append("\n");
        for (TypeNode typeNode : this.solution.getWorkflowInputTypeStates()) {
            String inputName = String.format("input_%o", this.workflowParameters.size() + 1);
            this.addParameter(typeNode, inputName);
            this.cwlRepresentation.append(this.ind(1)).append(inputName).append(":\n").append(this.ind(2)).append("type: File").append("\n").append(this.ind(2)).append("format: ").append(typeNode.getFormat()).append("\n");
        }
    }

    private void generateWorkflowOutputs() {
        this.cwlRepresentation.append("outputs:\n");
        int i = 1;
        for (TypeNode typeNode : this.solution.getWorkflowOutputTypeStates()) {
            this.cwlRepresentation.append(this.ind(1)).append(String.format("output_%o", i)).append(":\n").append(this.ind(2)).append("type: File").append("\n").append(this.ind(2)).append("format: ").append(typeNode.getFormat()).append("\n").append(this.ind(2)).append("outputSource: ").append(this.stepName(typeNode.getCreatedByModule())).append("/");
            int outId = typeNode.getCreatedByModule().getOutputTypes().get(i - 1).getAutomatonState().getLocalStateNumber();
            this.cwlRepresentation.append(this.generateInputOrOutputName(typeNode.getCreatedByModule(), "out", outId + 1)).append("\n");
            ++i;
        }
    }

    private void generateWorkflowSteps() {
        this.cwlRepresentation.append("steps:").append("\n");
        for (ModuleNode moduleNode : this.solution.getModuleNodes()) {
            this.generateStep(moduleNode);
        }
    }

    private void generateStep(ModuleNode moduleNode) {
        boolean baseInd = true;
        this.cwlRepresentation.append(this.ind(1)).append(this.stepName(moduleNode)).append(":\n");
        this.generateStepIn(moduleNode);
        this.generateStepOut(moduleNode);
        this.generateStepRun(moduleNode);
    }

    private void generateStepIn(ModuleNode moduleNode) {
        int baseInd = 2;
        this.cwlRepresentation.append(this.ind(2)).append("in").append(":\n");
        if (moduleNode.getInputTypes().isEmpty()) {
            this.deleteLastNCharactersFromCWL(1);
            this.cwlRepresentation.append(" ").append("[]").append("\n");
            return;
        }
        int i = 0;
        for (TypeNode typeNode : moduleNode.getInputTypes()) {
            this.cwlRepresentation.append(this.ind(3)).append(this.generateInputOrOutputName(moduleNode, "in", i + 1)).append(": ").append(this.workflowParameters.get(typeNode.getNodeID())).append("\n");
            ++i;
        }
    }

    private void generateStepOut(ModuleNode moduleNode) {
        int baseInd = 2;
        this.cwlRepresentation.append(this.ind(2)).append("out: ").append("[");
        int i = 1;
        for (TypeNode typeNode : moduleNode.getOutputTypes()) {
            String name = this.generateInputOrOutputName(moduleNode, "out", i);
            this.addParameter(typeNode, String.format("%s/%s", this.stepName(moduleNode), name));
            this.cwlRepresentation.append(name).append(", ");
            ++i;
        }
        this.deleteLastNCharactersFromCWL(2);
        this.cwlRepresentation.append("]").append("\n");
    }

    private void generateStepRun(ModuleNode moduleNode) {
        int baseInd = 2;
        this.cwlRepresentation.append(this.ind(2)).append("run:").append("\n").append(this.ind(3)).append("class: Operation").append("\n");
        this.cwlRepresentation.append(this.ind(3)).append("inputs:").append("\n");
        this.generateTypeNodes(moduleNode, moduleNode.getInputTypes(), true, 4);
        this.cwlRepresentation.append(this.ind(3)).append("outputs:").append("\n");
        this.generateTypeNodes(moduleNode, moduleNode.getOutputTypes(), false, 4);
        this.generateStepHints(moduleNode, 3);
        this.generateStepIntent(moduleNode, 3);
    }

    private void generateStepHints(ModuleNode moduleNode, int baseInd) {
        this.cwlRepresentation.append(this.ind(baseInd)).append("hints:").append("\n").append(this.ind(baseInd + 1)).append("SoftWareRequirement:").append("\n").append(this.ind(baseInd + 2)).append("packages:").append("\n").append(this.ind(baseInd + 3)).append(String.format("%s: [\"%s\"]", moduleNode.getNodeLabel(), moduleNode.getUsedModule().getPredicateID())).append("\n");
    }

    private void generateStepIntent(ModuleNode moduleNode, int baseInd) {
        this.cwlRepresentation.append(this.ind(baseInd)).append("intent: ").append("[");
        for (TaxonomyPredicate predicate : moduleNode.getUsedModule().getParentPredicates()) {
            this.cwlRepresentation.append("\"").append(predicate.getPredicateID()).append("\"").append(", ");
        }
        this.deleteLastNCharactersFromCWL(2);
        this.cwlRepresentation.append("]").append("\n");
    }

    private void generateTypeNodes(ModuleNode moduleNode, List<TypeNode> typeNodeList, boolean input, int baseInd) {
        if (typeNodeList.isEmpty()) {
            this.deleteLastNCharactersFromCWL(1);
            this.cwlRepresentation.append(" ").append("[]").append("\n");
            return;
        }
        int i = 0;
        for (TypeNode typeNode : typeNodeList) {
            if (typeNode.isEmpty()) {
                return;
            }
            this.cwlRepresentation.append(this.ind(baseInd)).append(this.generateInputOrOutputName(moduleNode, input ? "in" : "out", ++i)).append(":\n").append(this.ind(baseInd + 1)).append("type: File").append("\n").append(this.ind(baseInd + 1)).append("format: ").append(typeNode.getFormat()).append("\n");
        }
    }

    private void addParameter(TypeNode typeNode, String name) {
        if (this.workflowParameters.putIfAbsent(typeNode.getNodeID(), name) != null) {
            log.warn("Duplicate key \"%s\" in workflow inputs!\n", (Object)typeNode.getNodeID());
        }
    }
}

