/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure.cwl;

import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.solver.solutionStructure.ModuleNode;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.solver.solutionStructure.TypeNode;
import nl.uu.cs.ape.solver.solutionStructure.cwl.CWLCreatorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCWLCreator
extends CWLCreatorBase {
    private static final Logger log = LoggerFactory.getLogger(DefaultCWLCreator.class);
    private final HashMap<String, String> workflowParameters = new HashMap();

    public DefaultCWLCreator(SolutionWorkflow solution) {
        super(solution);
    }

    @Override
    public String getCWLVersion() {
        return "v1.2";
    }

    @Override
    protected void generateCWLRepresentation() {
        this.generateWorkflowInputs();
        this.generateWorkflowSteps();
        this.generateWorkflowOutputs();
    }

    private void generateWorkflowInputs() {
        this.cwlRepresentation.append("inputs:").append("\n");
        this.cwlRepresentation.append(this.getInputsInCWL(false));
    }

    private String getInputsInCWL(boolean formatForCwlInputsYmlFile) {
        StringBuilder inputsInCWL = new StringBuilder();
        int indentLevel = 1;
        String typeLabel = "type";
        if (formatForCwlInputsYmlFile) {
            indentLevel = 0;
            typeLabel = "class";
        }
        int i = 1;
        for (TypeNode typeNode : this.solution.getWorkflowInputTypeStates()) {
            String currTypeFormat = "";
            for (Type type : typeNode.getTypes()) {
                if (!type.getRootNodeID().equals("http://edamontology.org/format_1915")) continue;
                currTypeFormat = type.getPredicateID();
            }
            String inputName = String.format("input_%o", i++);
            this.addNewParameterToMap(typeNode, inputName);
            inputsInCWL.append(this.ind(indentLevel)).append(inputName).append(":\n").append(this.ind(indentLevel + 1)).append(typeLabel + ": File").append("\n").append(this.ind(indentLevel + 1)).append("format: ").append(typeNode.getFormat()).append("\n");
            if (!formatForCwlInputsYmlFile) continue;
            HashMap<String, String> availableData = new HashMap<String, String>();
            availableData.put("http://edamontology.org/format_3244", "https://raw.githubusercontent.com/Workflomics/DemoKit/main/data/inputs/2021-10-8_Ecoli.mzML");
            availableData.put("http://edamontology.org/format_1929", "https://raw.githubusercontent.com/Workflomics/DemoKit/main/data/inputs/up00000062.fasta");
            availableData.put("http://edamontology.org/format_2196_plain", "https://raw.githubusercontent.com/Workflomics/DemoKit/main/data/inputs/go.obo");
            availableData.put("http://edamontology.org/format_3475_plain", "https://raw.githubusercontent.com/Workflomics/DemoKit/main/data/inputs/goa_human_smaller.gaf");
            String inputPath = availableData.containsKey(currTypeFormat) ? (String)availableData.get(currTypeFormat) : "set_full_path_to_the_file_with_extension_here";
            inputsInCWL.append(this.ind(indentLevel + 1)).append("path: ").append(inputPath).append("\n");
        }
        return inputsInCWL.toString();
    }

    private void generateWorkflowOutputs() {
        this.cwlRepresentation.append("outputs:\n");
        int i = 1;
        for (TypeNode typeNode : this.solution.getWorkflowOutputTypeStates()) {
            this.cwlRepresentation.append(this.ind(1)).append(String.format("output_%o", i)).append(":\n").append(this.ind(2)).append("type: File").append("\n").append(this.ind(2)).append("format: ").append(typeNode.getFormat()).append("\n").append(this.ind(2)).append("outputSource: ").append(this.stepName(typeNode.getCreatedByModule())).append("/");
            int outId = typeNode.getCreatedByModule().getOutputTypes().get(i - 1).getAutomatonState().getLocalStateNumber();
            this.cwlRepresentation.append(this.generateInputOrOutputName(typeNode.getCreatedByModule(), "out", outId + 1)).append("\n");
            ++i;
        }
    }

    private void generateWorkflowSteps() {
        this.cwlRepresentation.append("steps:").append("\n");
        for (ModuleNode moduleNode : this.solution.getModuleNodes()) {
            this.generateStep(moduleNode);
        }
    }

    private void generateStep(ModuleNode moduleNode) {
        boolean baseInd = true;
        this.cwlRepresentation.append(this.ind(1)).append(this.stepName(moduleNode)).append(":\n");
        this.generateDefaultStepRun(moduleNode);
        this.generateStepIn(moduleNode);
        this.generateStepOut(moduleNode);
    }

    private void generateStepIn(ModuleNode moduleNode) {
        int baseInd = 2;
        this.cwlRepresentation.append(this.ind(2)).append("in").append(":\n");
        if (!moduleNode.hasInputTypes()) {
            this.deleteLastNCharactersFromCWL(1);
            this.cwlRepresentation.append(" ").append("[]").append("\n");
        } else {
            List<TypeNode> inputs = moduleNode.getInputTypes();
            IntStream.range(0, inputs.size()).filter(i -> !((TypeNode)inputs.get(i)).isEmpty()).forEach(i -> this.cwlRepresentation.append(this.ind(3)).append(this.generateInputOrOutputName(moduleNode, "in", i + 1)).append(": ").append(this.workflowParameters.get(((TypeNode)inputs.get(i)).getNodeID())).append("\n"));
        }
    }

    private void generateStepOut(ModuleNode moduleNode) {
        int baseInd = 2;
        this.cwlRepresentation.append(this.ind(2)).append("out: ").append("[");
        List<TypeNode> outputs = moduleNode.getOutputTypes();
        IntStream.range(0, outputs.size()).filter(i -> !((TypeNode)outputs.get(i)).isEmpty()).forEach(i -> {
            String name = this.generateInputOrOutputName(moduleNode, "out", i + 1);
            this.addNewParameterToMap((TypeNode)outputs.get(i), String.format("%s/%s", this.stepName(moduleNode), name));
            this.cwlRepresentation.append(name).append(", ");
        });
        if (moduleNode.hasOutputTypes()) {
            this.deleteLastNCharactersFromCWL(2);
        }
        this.cwlRepresentation.append("]").append("\n");
    }

    private void generateDefaultStepRun(ModuleNode moduleNode) {
        int baseInd = 2;
        String moduleReference = "add-path-to-the-implementation/" + moduleNode.getUsedModule().getPredicateLabel() + ".cwl ";
        if (moduleNode.getUsedModule().getCwlFileReference() != null) {
            moduleReference = moduleNode.getUsedModule().getCwlFileReference();
        }
        this.cwlRepresentation.append(this.ind(2)).append("run: " + moduleReference).append("\n");
    }

    private String addNewParameterToMap(TypeNode typeNode, String name) {
        if (this.workflowParameters.putIfAbsent(typeNode.getNodeID(), name) != null) {
            log.warn("Duplicate key \"%s\" in workflow inputs!", (Object)typeNode.getNodeID());
        }
        return typeNode.getNodeID();
    }

    public String generateCWLWorkflowInputs() {
        return this.getInputsInCWL(true);
    }
}

