/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.solver.solutionStructure.graphviz;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.LinkAttr;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.util.List;
import nl.uu.cs.ape.solver.solutionStructure.ModuleNode;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.solver.solutionStructure.TypeNode;
import nl.uu.cs.ape.solver.solutionStructure.graphviz.SolutionGraph;

public class SolutionGraphFactory {
    public static SolutionGraph generateControlflowGraph(SolutionWorkflow workflow, String title, Rank.RankDir orientation) {
        Graph workflowGraph = (Graph)Factory.graph((String)title).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)orientation));
        String input = "START     ";
        String output = "END     ";
        workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)input).with((Attributes)Color.BLACK, (Attributes)Style.BOLD)});
        String prevNode = input;
        for (ModuleNode currTool : workflow.getModuleNodes()) {
            workflowGraph = currTool.addModuleToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)prevNode).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.of((String)"next   "), (Attributes)Color.RED)})});
            prevNode = currTool.getNodeID();
        }
        workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)output).with((Attributes)Color.BLACK, (Attributes)Style.BOLD)});
        workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)prevNode).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)output)).with((Attributes)Label.of((String)"next   "), (Attributes)Color.RED)})});
        return new SolutionGraph(workflowGraph);
    }

    public static SolutionGraph generateDataFlowGraph(SolutionWorkflow workflow, String title, Rank.RankDir orientation) {
        Graph workflowGraph = (Graph)Factory.graph((String)title).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)orientation));
        List<TypeNode> workflowInputs = workflow.getWorkflowInputTypeStates();
        List<TypeNode> workflowOutputs = workflow.getWorkflowOutputTypeStates();
        List<ModuleNode> moduleNodes = workflow.getModuleNodes();
        String input = "Workflow INPUT     ";
        String output = "Workflow OUTPUT     ";
        boolean inputDefined = false;
        boolean outputDefined = false;
        int index = 0;
        int workflowInNo = 1;
        for (TypeNode workflowInput : workflowInputs) {
            if (!inputDefined) {
                workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)input).with((Attributes)Color.RED, (Attributes)Shape.RECTANGLE, (Attributes)Style.BOLD)});
                inputDefined = true;
            }
            workflowGraph = workflowInput.addTypeToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)input).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)workflowInput.getNodeID())).with((Attributes)Label.of((String)(workflowInNo++ + "  ")), LinkAttr.weight((double)index++), (Attributes)Style.DOTTED)})});
        }
        for (ModuleNode currTool : moduleNodes) {
            workflowGraph = currTool.addModuleToGraph(workflowGraph);
            int inputNo = 1;
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)toolInput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.of((String)("in " + inputNo++ + "  ")), (Attributes)Color.ORANGE, LinkAttr.weight((double)index++))})});
            }
            int outputNo = 1;
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                workflowGraph = toolOutput.addTypeToGraph(workflowGraph);
                workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)currTool.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)toolOutput.getNodeID())).with((Attributes)Label.of((String)("out " + outputNo++ + "  ")), LinkAttr.weight((double)index++))})});
            }
        }
        int workflowOutNo = 1;
        for (TypeNode workflowOutput : workflowOutputs) {
            if (!outputDefined) {
                workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)output).with((Attributes)Color.RED, (Attributes)Shape.RECTANGLE, (Attributes)Style.BOLD)});
                outputDefined = true;
            }
            workflowGraph = workflowOutput.addTypeToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)workflowOutput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)output)).with((Attributes)Label.of((String)(workflowOutNo++ + "  ")), LinkAttr.weight((double)index++), (Attributes)Style.DOTTED)})});
        }
        return new SolutionGraph(workflowGraph);
    }

    public static SolutionGraph generateTavernaDesignGraph(SolutionWorkflow workflow, String title) {
        Attributes helveticaFont = Font.name((String)"Arial");
        Graph workflowGraph = (Graph)((Graph)((Graph)((Graph)Factory.graph((String)title).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.TOP_TO_BOTTOM))).graphAttr().with(helveticaFont, Font.size((int)14))).nodeAttr().with(helveticaFont, Font.size((int)16))).linkAttr().with(helveticaFont, Font.size((int)14));
        List<TypeNode> workflowInputs = workflow.getWorkflowInputTypeStates();
        List<TypeNode> workflowOutputs = workflow.getWorkflowOutputTypeStates();
        List<ModuleNode> moduleNodes = workflow.getModuleNodes();
        int index = 0;
        boolean inputDefined = false;
        Node toolInputNodes = null;
        for (TypeNode workflowInput : workflowInputs) {
            if (!inputDefined) {
                toolInputNodes = Factory.node((String)workflowInput.getNodeID());
                inputDefined = true;
            } else {
                toolInputNodes = Factory.node((String)workflowInput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)toolInputNodes).with((Attributes)Style.INVIS, LinkAttr.weight((double)index++))});
            }
            workflowGraph = workflowInput.addTavernaStyleTypeToGraph(workflowGraph);
        }
        workflowGraph = workflowGraph.with(new LinkSource[]{((Graph)Factory.graph((String)"inputs_frame").cluster().graphAttr().with((Attributes)Style.DASHED, (Attributes)Color.BLACK, (Attributes)Label.html((String)"<b>Workflow Inputs</b>"))).with(new LinkSource[]{((Graph)Factory.graph((String)"inputs").directed().graphAttr().with(Rank.inSubgraph((Rank.RankType)Rank.RankType.MIN), (Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT))).with(new LinkSource[]{toolInputNodes})})});
        for (ModuleNode currTool : moduleNodes) {
            workflowGraph = currTool.addTavernaStyleModuleToGraph(workflowGraph);
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                if (toolInput.getCreatedByModule() == null) {
                    workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)toolInput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.html((String)toolInput.getNodeGraphLabels()), (Attributes)Color.BLACK, LinkAttr.weight((double)index++))})});
                    continue;
                }
                workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)toolInput.getCreatedByModule().getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.html((String)toolInput.getNodeGraphLabels()), (Attributes)Color.BLACK, LinkAttr.weight((double)index++))})});
            }
        }
        boolean outputDefined = false;
        Node toolOutputNodes = null;
        for (TypeNode workflowOutput : workflowOutputs) {
            if (!outputDefined) {
                toolOutputNodes = Factory.node((String)workflowOutput.getNodeID());
                outputDefined = true;
            } else {
                toolOutputNodes = Factory.node((String)workflowOutput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)toolOutputNodes).with((Attributes)Style.INVIS, LinkAttr.weight((double)(100 + index++)))});
            }
            workflowGraph = workflowOutput.addTavernaStyleTypeToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)workflowOutput.getCreatedByModule().getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)workflowOutput.getNodeID())).with((Attributes)Label.html((String)workflowOutput.getNodeGraphLabels()), (Attributes)Color.BLACK, LinkAttr.weight((double)index++))})});
        }
        workflowGraph = workflowGraph.with(new LinkSource[]{((Graph)Factory.graph((String)"outputs_frame").cluster().graphAttr().with((Attributes)Style.DASHED, (Attributes)Color.BLACK, (Attributes)Label.html((String)"<b>Workflow Outputs</b>"))).with(new LinkSource[]{((Graph)Factory.graph((String)"outputs").directed().graphAttr().with(Rank.inSubgraph((Rank.RankType)Rank.RankType.MIN), (Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT))).with(new LinkSource[]{toolOutputNodes})})});
        return new SolutionGraph(workflowGraph);
    }

    public static String generateSolutionDotFormat(SolutionWorkflow workflow) {
        StringBuilder solution = new StringBuilder();
        List<TypeNode> workflowInputs = workflow.getWorkflowInputTypeStates();
        List<TypeNode> workflowOutputs = workflow.getWorkflowOutputTypeStates();
        List<ModuleNode> moduleNodes = workflow.getModuleNodes();
        String input = "\"Workflow INPUT\"";
        String output = "\"Workflow OUTPUT\"";
        boolean inputDefined = false;
        boolean outputDefined = false;
        for (TypeNode workflowInput : workflowInputs) {
            if (!inputDefined) {
                solution.append(input + " [shape=box, color = red];\n");
                inputDefined = true;
            }
            solution.append(input + "->" + workflowInput.getNodeID() + ";\n");
            solution.append(workflowInput.getDotDefinition());
        }
        for (ModuleNode currTool : moduleNodes) {
            solution.append(currTool.getDotDefinition());
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                solution.append(toolInput.getNodeID() + "->" + currTool.getNodeID() + "[label = in, fontsize = 10];\n");
            }
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                solution.append(toolOutput.getDotDefinition());
                solution.append(currTool.getNodeID() + "->" + toolOutput.getNodeID() + " [label = out, fontsize = 10];\n");
            }
        }
        for (TypeNode workflowOutput : workflowOutputs) {
            if (!outputDefined) {
                solution.append(output + " [shape=box, color = red];\n");
                outputDefined = true;
            }
            solution.append(workflowOutput.getDotDefinition());
            solution.append(workflowOutput.getNodeID() + "->" + output + ";\n");
        }
        return solution.toString();
    }

    public static String generateScriptExecution(SolutionWorkflow workflow) {
        StringBuilder script = new StringBuilder("#!/bin/bash\n");
        List<TypeNode> workflowInputs = workflow.getWorkflowInputTypeStates();
        List<TypeNode> workflowOutputs = workflow.getWorkflowOutputTypeStates();
        List<ModuleNode> moduleNodes = workflow.getModuleNodes();
        script.append("if [ $# -ne " + workflowInputs.size() + " ]\n\tthen\n");
        script.append("\t\techo \"" + workflowInputs.size() + " argument(s) expected.\"\n\t\texit\nfi\n");
        int in = 1;
        for (TypeNode input : workflowInputs) {
            script.append(input.getShortNodeID() + "=$" + in++ + "\n");
        }
        script.append("\n");
        for (ModuleNode operation : moduleNodes) {
            int i;
            String code = operation.getUsedModule().getExecutionCommand();
            if (code == null || code.equals("")) {
                script.append("\"Error. Tool '" + operation.getNodeLabel() + "' is missing the execution code.\"").append("\n");
                continue;
            }
            for (i = 0; i < operation.getInputTypes().size(); ++i) {
                code = code.replace("@input[" + i + "]", operation.getInputTypes().get(i).getShortNodeID());
            }
            for (i = 0; i < operation.getOutputTypes().size(); ++i) {
                code = code.replace("@output[" + i + "]", operation.getOutputTypes().get(i).getShortNodeID());
            }
            script.append(code).append("\n");
        }
        int out = 1;
        for (TypeNode output : workflowOutputs) {
            script.append("echo \"" + out++ + ". output is: $" + output.getShortNodeID() + "\"");
        }
        return script.toString();
    }

    public static String generateReadableSolution(SolutionWorkflow workflow) {
        StringBuilder solution = new StringBuilder();
        List<TypeNode> workflowInputs = workflow.getWorkflowInputTypeStates();
        List<TypeNode> workflowOutputs = workflow.getWorkflowOutputTypeStates();
        List<ModuleNode> moduleNodes = workflow.getModuleNodes();
        solution.append("WORKFLOW_IN:{");
        int i = 0;
        for (TypeNode workflowInput : workflowInputs) {
            solution.append(workflowInput.toString());
            if (++i >= workflowInputs.size()) continue;
            solution.append(", ");
        }
        solution.append("} |");
        for (ModuleNode currTool : moduleNodes) {
            solution.append(" IN:{");
            i = 0;
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                if (i++ > 1) {
                    solution.append(", ");
                }
                solution.append(toolInput.toString());
            }
            solution.append("} ").append(currTool.toString());
            solution.append(" OUT:{");
            i = 0;
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                if (i++ > 1) {
                    solution.append(", ");
                }
                solution.append(toolOutput.toString());
            }
            solution.append("} |");
        }
        i = 0;
        solution.append("WORKFLOW_OUT:{");
        for (TypeNode workflowOutput : workflowOutputs) {
            solution.append(workflowOutput.toString());
            if (++i >= workflowOutputs.size()) continue;
            solution.append(", ");
        }
        solution.append("}");
        return solution.toString();
    }

    private SolutionGraphFactory() {
    }
}

