/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.sangcomz.fishbun.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sangcomz/fishbun/permission/PermissionCheck;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "checkCameraPermission", "", "requestCode", "", "checkPermission", "permissionList", "", "", "checkStoragePermission", "checkStoragePermissionOrHigherAPI33", "checkStoragePermissionUnderAPI33", "showPermissionDialog", "", "fishbun_release"})
public final class PermissionCheck {
    @NotNull
    private final Context context;

    public PermissionCheck(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkPermission(List<String> permissionList, int requestCode) {
        boolean bl;
        void $this$toTypedArray$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (!(this.context instanceof Activity)) {
            return false;
        }
        Iterable iterable = permissionList;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)it, (Object)ContextCompat.checkSelfPermission((Context)this.context, (String)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl3 = false;
            if (!(((Number)it.getSecond()).intValue() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add((String)it.getFirst());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object[] needRequestPermissionList = objectArray;
        if (needRequestPermissionList.length == 0) {
            bl = true;
        } else {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.context), (String)((String)ArraysKt.first((Object[])needRequestPermissionList)))) {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])needRequestPermissionList, (int)requestCode);
            } else {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])needRequestPermissionList, (int)requestCode);
            }
            bl = false;
        }
        return bl;
    }

    public final boolean checkStoragePermission(int requestCode) {
        return Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 33 ? this.checkStoragePermissionUnderAPI33(requestCode) : (Build.VERSION.SDK_INT >= 33 ? this.checkStoragePermissionOrHigherAPI33(requestCode) : true);
    }

    @TargetApi(value=23)
    public final boolean checkStoragePermissionUnderAPI33(int requestCode) {
        Object[] objectArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        return this.checkPermission(CollectionsKt.arrayListOf((Object[])objectArray), requestCode);
    }

    @TargetApi(value=33)
    public final boolean checkStoragePermissionOrHigherAPI33(int requestCode) {
        Object[] objectArray = new String[]{"android.permission.READ_MEDIA_IMAGES"};
        return this.checkPermission(CollectionsKt.arrayListOf((Object[])objectArray), requestCode);
    }

    @TargetApi(value=23)
    public final boolean checkCameraPermission(int requestCode) {
        try {
            Object[] permissions;
            PackageInfo info = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4096);
            return (permissions != null ? ArraysKt.contains((Object[])(permissions = info.requestedPermissions), (Object)"android.permission.CAMERA") : false) ? this.checkPermission(CollectionsKt.listOf((Object)"android.permission.CAMERA"), requestCode) : false;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public final void showPermissionDialog() {
        Toast.makeText((Context)this.context, (int)R.string.msg_permission, (int)0).show();
    }
}

