/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album.model.repository;

import android.net.Uri;
import android.os.Build;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.CameraDataSource;
import com.sangcomz.fishbun.datasource.FishBunDataSource;
import com.sangcomz.fishbun.datasource.ImageDataSource;
import com.sangcomz.fishbun.ui.album.model.Album;
import com.sangcomz.fishbun.ui.album.model.AlbumMenuViewData;
import com.sangcomz.fishbun.ui.album.model.AlbumMetaData;
import com.sangcomz.fishbun.ui.album.model.AlbumViewData;
import com.sangcomz.fishbun.ui.album.model.repository.AlbumRepository;
import com.sangcomz.fishbun.util.future.CallableFutureTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sangcomz/fishbun/ui/album/model/repository/AlbumRepositoryImpl;", "Lcom/sangcomz/fishbun/ui/album/model/repository/AlbumRepository;", "imageDataSource", "Lcom/sangcomz/fishbun/datasource/ImageDataSource;", "fishBunDataSource", "Lcom/sangcomz/fishbun/datasource/FishBunDataSource;", "cameraDataSource", "Lcom/sangcomz/fishbun/datasource/CameraDataSource;", "(Lcom/sangcomz/fishbun/datasource/ImageDataSource;Lcom/sangcomz/fishbun/datasource/FishBunDataSource;Lcom/sangcomz/fishbun/datasource/CameraDataSource;)V", "viewData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumViewData;", "getAlbumList", "Lcom/sangcomz/fishbun/util/future/CallableFutureTask;", "", "Lcom/sangcomz/fishbun/ui/album/model/Album;", "getAlbumMenuViewData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumMenuViewData;", "getAlbumMetaData", "Lcom/sangcomz/fishbun/ui/album/model/AlbumMetaData;", "albumId", "", "getAlbumViewData", "getDefaultSavePath", "", "getImageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "getMessageNotingSelected", "getMinCount", "", "getSelectedImageList", "Landroid/net/Uri;", "fishbun_release"})
public final class AlbumRepositoryImpl
implements AlbumRepository {
    @NotNull
    private final ImageDataSource imageDataSource;
    @NotNull
    private final FishBunDataSource fishBunDataSource;
    @NotNull
    private final CameraDataSource cameraDataSource;
    @Nullable
    private AlbumViewData viewData;

    public AlbumRepositoryImpl(@NotNull ImageDataSource imageDataSource, @NotNull FishBunDataSource fishBunDataSource, @NotNull CameraDataSource cameraDataSource) {
        Intrinsics.checkNotNullParameter((Object)imageDataSource, (String)"imageDataSource");
        Intrinsics.checkNotNullParameter((Object)fishBunDataSource, (String)"fishBunDataSource");
        Intrinsics.checkNotNullParameter((Object)cameraDataSource, (String)"cameraDataSource");
        this.imageDataSource = imageDataSource;
        this.fishBunDataSource = fishBunDataSource;
        this.cameraDataSource = cameraDataSource;
    }

    @Override
    @NotNull
    public CallableFutureTask<List<Album>> getAlbumList() {
        return this.imageDataSource.getAlbumList(this.fishBunDataSource.getAllViewTitle(), this.fishBunDataSource.getExceptMimeTypeList(), this.fishBunDataSource.getSpecifyFolderList());
    }

    @Override
    @NotNull
    public CallableFutureTask<AlbumMetaData> getAlbumMetaData(long albumId) {
        return this.imageDataSource.getAlbumMetaData(albumId, this.fishBunDataSource.getExceptMimeTypeList(), this.fishBunDataSource.getSpecifyFolderList());
    }

    @Override
    @NotNull
    public AlbumViewData getAlbumViewData() {
        AlbumViewData albumViewData = this.viewData;
        if (albumViewData == null) {
            AlbumViewData albumViewData2;
            AlbumViewData it = albumViewData2 = this.fishBunDataSource.getAlbumViewData();
            boolean bl = false;
            this.viewData = it;
            albumViewData = albumViewData2;
        }
        return albumViewData;
    }

    @Override
    @NotNull
    public ImageAdapter getImageAdapter() {
        return this.fishBunDataSource.getImageAdapter();
    }

    @Override
    @NotNull
    public List<Uri> getSelectedImageList() {
        return this.fishBunDataSource.getSelectedImageList();
    }

    @Override
    @NotNull
    public AlbumMenuViewData getAlbumMenuViewData() {
        return this.fishBunDataSource.gatAlbumMenuViewData();
    }

    @Override
    @NotNull
    public String getMessageNotingSelected() {
        return this.fishBunDataSource.getMessageNothingSelected();
    }

    @Override
    public int getMinCount() {
        return this.fishBunDataSource.getMinCount();
    }

    @Override
    @Nullable
    public String getDefaultSavePath() {
        return Build.VERSION.SDK_INT >= 29 ? this.cameraDataSource.getPicturePath() : this.cameraDataSource.getCameraPath();
    }
}

