/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker;

import android.net.Uri;
import com.sangcomz.fishbun.ui.picker.PickerContract;
import com.sangcomz.fishbun.ui.picker.model.AlbumData;
import com.sangcomz.fishbun.ui.picker.model.PickerListItem;
import com.sangcomz.fishbun.ui.picker.model.PickerMenuViewData;
import com.sangcomz.fishbun.ui.picker.model.PickerRepository;
import com.sangcomz.fishbun.ui.picker.model.PickerViewData;
import com.sangcomz.fishbun.util.UiHandler;
import com.sangcomz.fishbun.util.future.CallableFutureTask;
import com.sangcomz.fishbun.util.future.FutureCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J&\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u001c\u0010!\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00100#H\u0016J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u0010H\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0010H\u0016J\u0016\u0010,\u001a\u00020\u00102\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010.\u001a\u00020\u0010H\u0016J\b\u0010/\u001a\u00020\u0010H\u0016J\u0018\u00100\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000eH\u0002J\b\u00101\u001a\u00020\u0010H\u0002J\u0010\u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u00103\u001a\u00020\u0010H\u0016J\b\u00104\u001a\u00020\u0010H\u0016J\u0018\u00105\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000eH\u0002J\b\u00106\u001a\u00020\u0010H\u0002R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/sangcomz/fishbun/ui/picker/PickerPresenter;", "Lcom/sangcomz/fishbun/ui/picker/PickerContract$Presenter;", "pickerView", "Lcom/sangcomz/fishbun/ui/picker/PickerContract$View;", "pickerRepository", "Lcom/sangcomz/fishbun/ui/picker/model/PickerRepository;", "uiHandler", "Lcom/sangcomz/fishbun/util/UiHandler;", "(Lcom/sangcomz/fishbun/ui/picker/PickerContract$View;Lcom/sangcomz/fishbun/ui/picker/model/PickerRepository;Lcom/sangcomz/fishbun/util/UiHandler;)V", "dirPathFuture", "Lcom/sangcomz/fishbun/util/future/CallableFutureTask;", "", "imageListFuture", "", "Landroid/net/Uri;", "addAddedPath", "", "addedImagePath", "addAllAddedPath", "addedImagePathList", "changeImageStatus", "position", "", "finish", "getAddedImagePathList", "getAllMediaThumbnailsPath", "albumId", "", "clearCache", "", "getDesignViewData", "getImagePosition", "getPickerListItem", "getPickerMenuViewData", "callback", "Lkotlin/Function1;", "Lcom/sangcomz/fishbun/ui/picker/model/PickerMenuViewData;", "onCheckStateChange", "imageUri", "onClickImage", "onClickMenuAllDone", "onClickMenuDone", "onClickThumbCount", "onDetailImageActivityResult", "onSuccessAllMediaThumbnailsPath", "imageUriList", "onSuccessTakePicture", "release", "selectImage", "setToolbarTitle", "successTakePicture", "takePicture", "transImageFinish", "unselectImage", "updatePickerListItem", "fishbun_release"})
public final class PickerPresenter
implements PickerContract.Presenter {
    @NotNull
    private final PickerContract.View pickerView;
    @NotNull
    private final PickerRepository pickerRepository;
    @NotNull
    private final UiHandler uiHandler;
    @Nullable
    private CallableFutureTask<List<Uri>> imageListFuture;
    @Nullable
    private CallableFutureTask<String> dirPathFuture;

    public PickerPresenter(@NotNull PickerContract.View pickerView, @NotNull PickerRepository pickerRepository, @NotNull UiHandler uiHandler) {
        Intrinsics.checkNotNullParameter((Object)pickerView, (String)"pickerView");
        Intrinsics.checkNotNullParameter((Object)pickerRepository, (String)"pickerRepository");
        Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
        this.pickerView = pickerView;
        this.pickerRepository = pickerRepository;
        this.uiHandler = uiHandler;
    }

    @Override
    public void addAddedPath(@NotNull Uri addedImagePath) {
        Intrinsics.checkNotNullParameter((Object)addedImagePath, (String)"addedImagePath");
        this.pickerRepository.addAddedPath(addedImagePath);
    }

    @Override
    public void addAllAddedPath(@NotNull List<? extends Uri> addedImagePathList) {
        Intrinsics.checkNotNullParameter(addedImagePathList, (String)"addedImagePathList");
        this.pickerRepository.addAllAddedPath(addedImagePathList);
    }

    @Override
    @NotNull
    public List<Uri> getAddedImagePathList() {
        return this.pickerRepository.getAddedPathList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getPickerListItem() {
        void it;
        CallableFutureTask callableFutureTask;
        AlbumData albumData = this.pickerRepository.getPickerAlbumData();
        if (albumData == null) {
            return;
        }
        AlbumData albumData2 = albumData;
        CallableFutureTask callableFutureTask2 = callableFutureTask = PickerPresenter.getAllMediaThumbnailsPath$default(this, albumData2.getAlbumId(), false, 2, null);
        PickerPresenter pickerPresenter2 = this;
        boolean bl = false;
        it.execute(new FutureCallback<List<? extends Uri>>(this){
            final /* synthetic */ PickerPresenter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@NotNull List<? extends Uri> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PickerPresenter.access$onSuccessAllMediaThumbnailsPath(this.this$0, result);
            }
        });
        pickerPresenter2.imageListFuture = callableFutureTask;
    }

    @Override
    public void transImageFinish() {
        AlbumData albumData = this.pickerRepository.getPickerAlbumData();
        if (albumData == null) {
            return;
        }
        AlbumData albumData2 = albumData;
        this.pickerView.takeANewPictureWithFinish(albumData2.getAlbumPosition(), this.pickerRepository.getAddedPathList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takePicture() {
        AlbumData albumData = this.pickerRepository.getPickerAlbumData();
        if (albumData == null) {
            return;
        }
        AlbumData albumData2 = albumData;
        if (albumData2.getAlbumId() == 0L) {
            String string2 = this.pickerRepository.getDefaultSavePath();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                this.pickerView.takePicture(it);
            }
        } else {
            try {
                void it;
                CallableFutureTask<String> callableFutureTask;
                CallableFutureTask<String> callableFutureTask2 = callableFutureTask = this.pickerRepository.getDirectoryPath(albumData2.getAlbumId());
                PickerPresenter pickerPresenter2 = this;
                boolean bl = false;
                it.execute(new FutureCallback<String>(this){
                    final /* synthetic */ PickerPresenter this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onSuccess(@NotNull String result) {
                        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                        PickerPresenter.access$getPickerView$p(this.this$0).takePicture(result);
                    }
                });
                pickerPresenter2.dirPathFuture = callableFutureTask;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void successTakePicture(@NotNull Uri addedImagePath) {
        Intrinsics.checkNotNullParameter((Object)addedImagePath, (String)"addedImagePath");
        this.addAddedPath(addedImagePath);
        this.updatePickerListItem();
    }

    @Override
    public void getDesignViewData() {
        PickerViewData viewData = this.pickerRepository.getPickerViewData();
        PickerContract.View $this$getDesignViewData_u24lambda_u2d3 = this.pickerView;
        boolean bl = false;
        $this$getDesignViewData_u24lambda_u2d3.initToolBar(viewData);
        $this$getDesignViewData_u24lambda_u2d3.initRecyclerView(viewData);
        this.setToolbarTitle();
    }

    @Override
    public void onClickThumbCount(int position) {
        this.changeImageStatus(position);
    }

    @Override
    public void onClickImage(int position) {
        if (this.pickerRepository.useDetailView()) {
            this.pickerView.showDetailView(this.getImagePosition(position));
        } else {
            this.changeImageStatus(position);
        }
    }

    @Override
    public void onDetailImageActivityResult() {
        PickerViewData pickerViewData = this.pickerRepository.getPickerViewData();
        if (this.pickerRepository.isLimitReached() && pickerViewData.isAutomaticClose()) {
            this.finish();
        } else {
            this.getPickerListItem();
        }
    }

    @Override
    public void getPickerMenuViewData(@NotNull Function1<? super PickerMenuViewData, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        callback.invoke((Object)this.pickerRepository.getPickerMenuViewData());
    }

    @Override
    public void onClickMenuDone() {
        int selectedCount = this.pickerRepository.getSelectedImageList().size();
        if (selectedCount == 0) {
            this.pickerView.showNothingSelectedMessage(this.pickerRepository.getMessageNotingSelected());
        } else if (selectedCount < this.pickerRepository.getMinCount()) {
            this.pickerView.showMinimumImageMessage(this.pickerRepository.getMinCount());
        } else {
            this.pickerView.finishActivity();
        }
    }

    @Override
    public void onClickMenuAllDone() {
        Iterable $this$forEach$iv = this.pickerRepository.getPickerImages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Uri it = (Uri)element$iv;
            boolean bl = false;
            if (this.pickerRepository.isLimitReached() || !this.pickerRepository.isNotSelectedImage(it)) continue;
            this.pickerRepository.selectImage(it);
        }
        this.pickerView.finishActivity();
    }

    @Override
    public void onSuccessTakePicture() {
        this.pickerView.onSuccessTakePicture();
    }

    @Override
    public void release() {
        block1: {
            CallableFutureTask<String> callableFutureTask = this.dirPathFuture;
            if (callableFutureTask != null) {
                callableFutureTask.cancel(true);
            }
            CallableFutureTask<List<Uri>> callableFutureTask2 = this.imageListFuture;
            if (callableFutureTask2 == null) break block1;
            callableFutureTask2.cancel(true);
        }
    }

    private final void changeImageStatus(int position) {
        int imagePosition = this.getImagePosition(position);
        Uri imageUri = this.pickerRepository.getPickerImage(imagePosition);
        if (this.pickerRepository.isNotSelectedImage(imageUri)) {
            this.selectImage(position, imageUri);
        } else {
            this.unselectImage(position, imageUri);
        }
    }

    private final void onCheckStateChange(int position, Uri imageUri) {
        this.pickerView.onCheckStateChange(position, new PickerListItem.Image(imageUri, this.pickerRepository.getSelectedIndex(imageUri), this.pickerRepository.getPickerViewData()));
    }

    private final void selectImage(int position, Uri imageUri) {
        if (this.pickerRepository.isLimitReached()) {
            this.pickerView.showLimitReachedMessage(this.pickerRepository.getMessageLimitReached());
            return;
        }
        this.pickerRepository.selectImage(imageUri);
        if (this.pickerRepository.checkForFinish()) {
            this.finish();
        } else {
            this.onCheckStateChange(position, imageUri);
            this.setToolbarTitle();
        }
    }

    private final void unselectImage(int position, Uri imageUri) {
        this.pickerRepository.unselectImage(imageUri);
        this.onCheckStateChange(position, imageUri);
        this.setToolbarTitle();
    }

    private final void setToolbarTitle() {
        Object object = this.pickerRepository.getPickerAlbumData();
        if (object == null || (object = ((AlbumData)object).getAlbumName()) == null) {
            object = "";
        }
        Object albumName = object;
        this.pickerView.setToolbarTitle(this.pickerRepository.getPickerViewData(), this.pickerRepository.getSelectedImageList().size(), (String)albumName);
    }

    private final int getImagePosition(int position) {
        return this.pickerRepository.hasCameraInPickerPage() ? position - 1 : position;
    }

    private final CallableFutureTask<List<Uri>> getAllMediaThumbnailsPath(long albumId, boolean clearCache) {
        return this.pickerRepository.getAllBucketImageUri(albumId, clearCache);
    }

    static /* synthetic */ CallableFutureTask getAllMediaThumbnailsPath$default(PickerPresenter pickerPresenter2, long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return pickerPresenter2.getAllMediaThumbnailsPath(l, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void onSuccessAllMediaThumbnailsPath(List<? extends Uri> imageUriList) {
        List list;
        void $this$mapTo$iv$iv;
        this.pickerRepository.setCurrentPickerImageList(imageUriList);
        PickerViewData viewData = this.pickerRepository.getPickerViewData();
        List selectedImageList = CollectionsKt.toMutableList((Collection)this.pickerRepository.getSelectedImageList());
        ArrayList<PickerListItem> pickerList = new ArrayList<PickerListItem>();
        if (this.pickerRepository.hasCameraInPickerPage()) {
            pickerList.add(PickerListItem.Camera.INSTANCE);
        }
        Iterable $this$map$iv = imageUriList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Uri uri = (Uri)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PickerListItem.Image((Uri)it, selectedImageList.indexOf(it), viewData));
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        pickerList.addAll(it);
        this.uiHandler.run((Function0<Unit>)((Function0)new Function0<Unit>(this, pickerList){
            final /* synthetic */ PickerPresenter this$0;
            final /* synthetic */ ArrayList<PickerListItem> $pickerList;
            {
                this.this$0 = $receiver;
                this.$pickerList = $pickerList;
                super(0);
            }

            public final void invoke() {
                PickerPresenter.access$getPickerView$p(this.this$0).showImageList((List<? extends PickerListItem>)this.$pickerList, PickerPresenter.access$getPickerRepository$p(this.this$0).getImageAdapter(), PickerPresenter.access$getPickerRepository$p(this.this$0).hasCameraInPickerPage());
                PickerPresenter.access$setToolbarTitle(this.this$0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePickerListItem() {
        void it;
        CallableFutureTask<List<Uri>> callableFutureTask;
        AlbumData albumData = this.pickerRepository.getPickerAlbumData();
        if (albumData == null) {
            return;
        }
        AlbumData albumData2 = albumData;
        CallableFutureTask<List<Uri>> callableFutureTask2 = callableFutureTask = this.getAllMediaThumbnailsPath(albumData2.getAlbumId(), true);
        PickerPresenter pickerPresenter2 = this;
        boolean bl = false;
        it.execute(new FutureCallback<List<? extends Uri>>(this){
            final /* synthetic */ PickerPresenter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@NotNull List<? extends Uri> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PickerPresenter.access$onSuccessAllMediaThumbnailsPath(this.this$0, result);
            }
        });
        pickerPresenter2.imageListFuture = callableFutureTask;
    }

    private final void finish() {
        if (this.pickerRepository.isStartInAllView()) {
            this.pickerView.finishActivityWithResult(this.pickerRepository.getSelectedImageList());
        } else {
            this.pickerView.finishActivity();
        }
    }

    public static final /* synthetic */ void access$onSuccessAllMediaThumbnailsPath(PickerPresenter $this, List imageUriList) {
        $this.onSuccessAllMediaThumbnailsPath(imageUriList);
    }

    public static final /* synthetic */ PickerContract.View access$getPickerView$p(PickerPresenter $this) {
        return $this.pickerView;
    }

    public static final /* synthetic */ PickerRepository access$getPickerRepository$p(PickerPresenter $this) {
        return $this.pickerRepository;
    }

    public static final /* synthetic */ void access$setToolbarTitle(PickerPresenter $this) {
        $this.setToolbarTitle();
    }
}

