/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker.model;

import android.net.Uri;
import android.os.Build;
import com.sangcomz.fishbun.adapter.image.ImageAdapter;
import com.sangcomz.fishbun.datasource.CameraDataSource;
import com.sangcomz.fishbun.datasource.FishBunDataSource;
import com.sangcomz.fishbun.datasource.ImageDataSource;
import com.sangcomz.fishbun.datasource.PickerIntentDataSource;
import com.sangcomz.fishbun.ui.picker.model.AlbumData;
import com.sangcomz.fishbun.ui.picker.model.PickerMenuViewData;
import com.sangcomz.fishbun.ui.picker.model.PickerRepository;
import com.sangcomz.fishbun.ui.picker.model.PickerViewData;
import com.sangcomz.fishbun.util.future.CallableFutureTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J$\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020!H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020!H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020!H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u000eH\u0016J\b\u00103\u001a\u00020\u0015H\u0016J\b\u00104\u001a\u00020\u0015H\u0016J\u0010\u00105\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u000eH\u0016J\b\u00106\u001a\u00020\u0015H\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u000eH\u0016J\u0016\u00108\u001a\u00020\u00102\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010:\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u000eH\u0016J\b\u0010;\u001a\u00020\u0015H\u0016R\u001c\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/sangcomz/fishbun/ui/picker/model/PickerRepositoryImpl;", "Lcom/sangcomz/fishbun/ui/picker/model/PickerRepository;", "imageDataSource", "Lcom/sangcomz/fishbun/datasource/ImageDataSource;", "fishBunDataSource", "Lcom/sangcomz/fishbun/datasource/FishBunDataSource;", "pickerIntentDataSource", "Lcom/sangcomz/fishbun/datasource/PickerIntentDataSource;", "cameraDataSource", "Lcom/sangcomz/fishbun/datasource/CameraDataSource;", "(Lcom/sangcomz/fishbun/datasource/ImageDataSource;Lcom/sangcomz/fishbun/datasource/FishBunDataSource;Lcom/sangcomz/fishbun/datasource/PickerIntentDataSource;Lcom/sangcomz/fishbun/datasource/CameraDataSource;)V", "cachedAllMediaThumbNailPath", "Lcom/sangcomz/fishbun/util/future/CallableFutureTask;", "", "Landroid/net/Uri;", "addAddedPath", "", "addedImage", "addAllAddedPath", "addedImagePathList", "checkForFinish", "", "getAddedPathList", "getAllBucketImageUri", "bucketId", "", "clearCache", "getDefaultSavePath", "", "getDirectoryPath", "getImageAdapter", "Lcom/sangcomz/fishbun/adapter/image/ImageAdapter;", "getMaxCount", "", "getMessageLimitReached", "getMessageNotingSelected", "getMinCount", "getPickerAlbumData", "Lcom/sangcomz/fishbun/ui/picker/model/AlbumData;", "getPickerImage", "imagePosition", "getPickerImages", "getPickerMenuViewData", "Lcom/sangcomz/fishbun/ui/picker/model/PickerMenuViewData;", "getPickerViewData", "Lcom/sangcomz/fishbun/ui/picker/model/PickerViewData;", "getSelectedImage", "position", "getSelectedImageList", "getSelectedIndex", "imageUri", "hasCameraInPickerPage", "isLimitReached", "isNotSelectedImage", "isStartInAllView", "selectImage", "setCurrentPickerImageList", "pickerImageList", "unselectImage", "useDetailView", "fishbun_release"})
public final class PickerRepositoryImpl
implements PickerRepository {
    @NotNull
    private final ImageDataSource imageDataSource;
    @NotNull
    private final FishBunDataSource fishBunDataSource;
    @NotNull
    private final PickerIntentDataSource pickerIntentDataSource;
    @NotNull
    private final CameraDataSource cameraDataSource;
    @Nullable
    private CallableFutureTask<List<Uri>> cachedAllMediaThumbNailPath;

    public PickerRepositoryImpl(@NotNull ImageDataSource imageDataSource, @NotNull FishBunDataSource fishBunDataSource, @NotNull PickerIntentDataSource pickerIntentDataSource, @NotNull CameraDataSource cameraDataSource) {
        Intrinsics.checkNotNullParameter((Object)imageDataSource, (String)"imageDataSource");
        Intrinsics.checkNotNullParameter((Object)fishBunDataSource, (String)"fishBunDataSource");
        Intrinsics.checkNotNullParameter((Object)pickerIntentDataSource, (String)"pickerIntentDataSource");
        Intrinsics.checkNotNullParameter((Object)cameraDataSource, (String)"cameraDataSource");
        this.imageDataSource = imageDataSource;
        this.fishBunDataSource = fishBunDataSource;
        this.pickerIntentDataSource = pickerIntentDataSource;
        this.cameraDataSource = cameraDataSource;
    }

    @Override
    @NotNull
    public CallableFutureTask<List<Uri>> getAllBucketImageUri(long bucketId, boolean clearCache) {
        CallableFutureTask<List<Uri>> callableFutureTask;
        if (clearCache) {
            this.cachedAllMediaThumbNailPath = null;
        }
        if ((callableFutureTask = this.cachedAllMediaThumbNailPath) == null) {
            CallableFutureTask<List<Uri>> callableFutureTask2;
            CallableFutureTask<List<Uri>> it = callableFutureTask2 = this.imageDataSource.getAllBucketImageUri(bucketId, this.fishBunDataSource.getExceptMimeTypeList(), this.fishBunDataSource.getSpecifyFolderList());
            boolean bl = false;
            this.cachedAllMediaThumbNailPath = it;
            callableFutureTask = callableFutureTask2;
        }
        return callableFutureTask;
    }

    @Override
    @NotNull
    public CallableFutureTask<String> getDirectoryPath(long bucketId) {
        return this.imageDataSource.getDirectoryPath(bucketId);
    }

    @Override
    public void addAddedPath(@NotNull Uri addedImage) {
        Intrinsics.checkNotNullParameter((Object)addedImage, (String)"addedImage");
        this.imageDataSource.addAddedPath(addedImage);
    }

    @Override
    @NotNull
    public List<Uri> getAddedPathList() {
        return this.imageDataSource.getAddedPathList();
    }

    @Override
    public void addAllAddedPath(@NotNull List<? extends Uri> addedImagePathList) {
        Intrinsics.checkNotNullParameter(addedImagePathList, (String)"addedImagePathList");
        this.imageDataSource.addAllAddedPath(addedImagePathList);
    }

    @Override
    @Nullable
    public AlbumData getPickerAlbumData() {
        return this.pickerIntentDataSource.getAlbumData();
    }

    @Override
    @NotNull
    public PickerViewData getPickerViewData() {
        return this.fishBunDataSource.getPickerViewData();
    }

    @Override
    public void setCurrentPickerImageList(@NotNull List<? extends Uri> pickerImageList) {
        Intrinsics.checkNotNullParameter(pickerImageList, (String)"pickerImageList");
        this.fishBunDataSource.setCurrentPickerImageList(pickerImageList);
    }

    @Override
    @NotNull
    public List<Uri> getSelectedImageList() {
        return this.fishBunDataSource.getSelectedImageList();
    }

    @Override
    @NotNull
    public ImageAdapter getImageAdapter() {
        return this.fishBunDataSource.getImageAdapter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasCameraInPickerPage() {
        if (Build.VERSION.SDK_INT >= 29) {
            if (!this.fishBunDataSource.hasCameraInPickerPage()) return false;
            AlbumData albumData = this.pickerIntentDataSource.getAlbumData();
            if (albumData == null) return false;
            if (albumData.getAlbumId() != 0L) return false;
            return true;
        }
        boolean bl = this.fishBunDataSource.hasCameraInPickerPage();
        return bl;
    }

    @Override
    public boolean useDetailView() {
        return this.fishBunDataSource.useDetailView();
    }

    @Override
    public boolean isLimitReached() {
        return this.fishBunDataSource.getMaxCount() == this.fishBunDataSource.getSelectedImageList().size();
    }

    @Override
    public void selectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishBunDataSource.selectImage(imageUri);
    }

    @Override
    public void unselectImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.fishBunDataSource.unselectImage(imageUri);
    }

    @Override
    public boolean isNotSelectedImage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return !this.fishBunDataSource.getSelectedImageList().contains(imageUri);
    }

    @Override
    @NotNull
    public Uri getSelectedImage(int position) {
        return this.fishBunDataSource.getSelectedImageList().get(position);
    }

    @Override
    public int getSelectedIndex(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return this.getSelectedImageList().indexOf(imageUri);
    }

    @Override
    @NotNull
    public Uri getPickerImage(int imagePosition) {
        return this.fishBunDataSource.getPickerImages().get(imagePosition);
    }

    @Override
    @NotNull
    public String getMessageLimitReached() {
        return this.fishBunDataSource.getMessageLimitReached();
    }

    @Override
    @NotNull
    public PickerMenuViewData getPickerMenuViewData() {
        return this.fishBunDataSource.getPickerMenuViewData();
    }

    @Override
    public int getMinCount() {
        return this.fishBunDataSource.getMinCount();
    }

    @Override
    public int getMaxCount() {
        return this.fishBunDataSource.getMinCount();
    }

    @Override
    @NotNull
    public List<Uri> getPickerImages() {
        return this.fishBunDataSource.getPickerImages();
    }

    @Override
    @NotNull
    public String getMessageNotingSelected() {
        return this.fishBunDataSource.getMessageNothingSelected();
    }

    @Override
    public boolean checkForFinish() {
        return this.fishBunDataSource.getIsAutomaticClose() && this.fishBunDataSource.getSelectedImageList().size() == this.fishBunDataSource.getMaxCount();
    }

    @Override
    public boolean isStartInAllView() {
        return this.fishBunDataSource.isStartInAllView();
    }

    @Override
    @Nullable
    public String getDefaultSavePath() {
        return Build.VERSION.SDK_INT >= 29 ? this.cameraDataSource.getPicturePath() : this.cameraDataSource.getCameraPath();
    }
}

