/*
 * Decompiled with CFR 0.152.
 */
package io.github.sangsoonam.duotoneimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import io.github.sangsoonam.duotoneimageview.R;

public class DuotoneImageView
extends AppCompatImageView {
    public DuotoneImageView(Context context) {
        this(context, null);
    }

    public DuotoneImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DuotoneImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.DuotoneImageView);
        int colorWhite = attributes.getColor(R.styleable.DuotoneImageView_colorWhite, -1);
        int colorBlack = attributes.getColor(R.styleable.DuotoneImageView_colorBlack, -16777216);
        float contrast = attributes.getFloat(R.styleable.DuotoneImageView_contrast, 1.0f);
        attributes.recycle();
        this.setDuotoneColorFilter(colorWhite, colorBlack, contrast);
    }

    public void setDuotoneColorFilter(@ColorInt int colorWhite, @ColorInt int colorBlack, float contrast) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.postConcat(DuotoneImageView.setBlackAndWhite(new ColorMatrix()));
        colorMatrix.postConcat(DuotoneImageView.setContrast(new ColorMatrix(), contrast));
        colorMatrix.postConcat(DuotoneImageView.setDuotone(new ColorMatrix(), colorWhite, colorBlack));
        this.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
    }

    private static ColorMatrix setBlackAndWhite(ColorMatrix cm) {
        cm.set(new float[]{0.33f, 0.33f, 0.33f, 0.0f, 0.0f, 0.33f, 0.33f, 0.33f, 0.0f, 0.0f, 0.33f, 0.33f, 0.33f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        return cm;
    }

    private static ColorMatrix setContrast(ColorMatrix cm, float contrast) {
        float scale = contrast + 1.0f;
        float translate = (-0.5f * scale + 0.5f) * 255.0f;
        cm.set(new float[]{scale, 0.0f, 0.0f, 0.0f, translate, 0.0f, scale, 0.0f, 0.0f, translate, 0.0f, 0.0f, scale, 0.0f, translate, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        return cm;
    }

    private static ColorMatrix setDuotone(ColorMatrix cm, @ColorInt int colorWhite, @ColorInt int colorBlack) {
        float whiteR = Color.red((int)colorWhite);
        float whiteG = Color.green((int)colorWhite);
        float whiteB = Color.blue((int)colorWhite);
        float blackR = Color.red((int)colorBlack);
        float blackG = Color.green((int)colorBlack);
        float blackB = Color.blue((int)colorBlack);
        float r = (whiteR - blackR) / 255.0f;
        float g = (whiteG - blackG) / 255.0f;
        float b = (whiteB - blackB) / 255.0f;
        cm.set(new float[]{r, 0.0f, 0.0f, 0.0f, blackR, g, 0.0f, 0.0f, 0.0f, blackG, b, 0.0f, 0.0f, 0.0f, blackB, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        return cm;
    }
}

