/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.moderation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ModerationRequest {
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=MultiModalInput.class, firstGroup=true)})
    private Object input;
    private String model;

    @Generated
    ModerationRequest(Object input, String model) {
        this.input = input;
        this.model = model;
    }

    @Generated
    public static ModerationRequestBuilder builder() {
        return new ModerationRequestBuilder();
    }

    @Generated
    public Object getInput() {
        return this.input;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public static class ModerationRequestBuilder {
        @Generated
        private Object input;
        @Generated
        private String model;

        @Generated
        ModerationRequestBuilder() {
        }

        @Generated
        public ModerationRequestBuilder input(Object input) {
            this.input = input;
            return this;
        }

        @Generated
        public ModerationRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public ModerationRequest build() {
            return new ModerationRequest(this.input, this.model);
        }

        @Generated
        public String toString() {
            return "ModerationRequest.ModerationRequestBuilder(input=" + this.input + ", model=" + this.model + ")";
        }
    }

    public static abstract class MultiModalInput {
        protected MultiModalType type;

        @Generated
        public MultiModalType getType() {
            return this.type;
        }

        @Generated
        public void setType(MultiModalType type) {
            this.type = type;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ImageUrlInput
        extends MultiModalInput {
            @Required
            private ImageUrl imageUrl;

            private ImageUrlInput(ImageUrl imageUrl) {
                this.type = MultiModalType.IMAGE_URL;
                this.imageUrl = imageUrl;
            }

            public static ImageUrlInput of(String url) {
                return new ImageUrlInput(new ImageUrl(url));
            }

            @Generated
            public ImageUrl getImageUrl() {
                return this.imageUrl;
            }

            @Generated
            public String toString() {
                return "ModerationRequest.MultiModalInput.ImageUrlInput(imageUrl=" + this.getImageUrl() + ")";
            }

            public static class ImageUrl {
                @Required
                private String url;

                public ImageUrl(String url) {
                    this.url = url;
                }

                @Generated
                public String getUrl() {
                    return this.url;
                }

                @Generated
                public String toString() {
                    return "ModerationRequest.MultiModalInput.ImageUrlInput.ImageUrl(url=" + this.getUrl() + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class TextInput
        extends MultiModalInput {
            @Required
            private String text;

            private TextInput(String text) {
                this.type = MultiModalType.TEXT;
                this.text = text;
            }

            public static TextInput of(String text) {
                return new TextInput(text);
            }

            @Generated
            public String getText() {
                return this.text;
            }

            @Generated
            public String toString() {
                return "ModerationRequest.MultiModalInput.TextInput(text=" + this.getText() + ")";
            }
        }
    }

    public static enum MultiModalType {
        TEXT,
        IMAGE_URL;

    }
}

