/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RealtimeSession {
    protected String id;
    protected String object;
    protected List<ChatRequest.Modality> modalities;
    protected String model;
    protected String instructions;
    protected VoiceRealtime voice;
    protected AudioFormatRealtime inputAudioFormat;
    protected AudioFormatRealtime outputAudioFormat;
    protected InputAudioTranscription inputAudioTranscription;
    protected TurnDetection turnDetection;
    protected List<ToolRealtime> tools;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ToolChoiceOption.class)})
    protected Object toolChoice;
    @Range(min=0.6, max=1.2)
    protected Double temperature;
    @Range(min=1.0, max=4096.0)
    @ObjectType.List(value={@ObjectType(baseClass=Integer.class), @ObjectType(baseClass=String.class)})
    protected Object maxResponseOutputTokens;

    @Generated
    protected RealtimeSession(RealtimeSessionBuilder<?, ?> b) {
        List<Object> tools;
        List<Object> modalities;
        this.id = b.id;
        this.object = b.object;
        switch (b.modalities == null ? 0 : b.modalities.size()) {
            case 0: {
                modalities = Collections.emptyList();
                break;
            }
            case 1: {
                modalities = Collections.singletonList(b.modalities.get(0));
                break;
            }
            default: {
                modalities = Collections.unmodifiableList(new ArrayList<ChatRequest.Modality>(b.modalities));
            }
        }
        this.modalities = modalities;
        this.model = b.model;
        this.instructions = b.instructions;
        this.voice = b.voice;
        this.inputAudioFormat = b.inputAudioFormat;
        this.outputAudioFormat = b.outputAudioFormat;
        this.inputAudioTranscription = b.inputAudioTranscription;
        this.turnDetection = b.turnDetection;
        switch (b.tools == null ? 0 : b.tools.size()) {
            case 0: {
                tools = Collections.emptyList();
                break;
            }
            case 1: {
                tools = Collections.singletonList(b.tools.get(0));
                break;
            }
            default: {
                tools = Collections.unmodifiableList(new ArrayList<ToolRealtime>(b.tools));
            }
        }
        this.tools = tools;
        this.toolChoice = b.toolChoice;
        this.temperature = b.temperature;
        this.maxResponseOutputTokens = b.maxResponseOutputTokens;
    }

    @Generated
    public static RealtimeSessionBuilder<?, ?> builder() {
        return new RealtimeSessionBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<ChatRequest.Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public VoiceRealtime getVoice() {
        return this.voice;
    }

    @Generated
    public AudioFormatRealtime getInputAudioFormat() {
        return this.inputAudioFormat;
    }

    @Generated
    public AudioFormatRealtime getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    @Generated
    public InputAudioTranscription getInputAudioTranscription() {
        return this.inputAudioTranscription;
    }

    @Generated
    public TurnDetection getTurnDetection() {
        return this.turnDetection;
    }

    @Generated
    public List<ToolRealtime> getTools() {
        return this.tools;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Object getMaxResponseOutputTokens() {
        return this.maxResponseOutputTokens;
    }

    @Generated
    public String toString() {
        return "RealtimeSession(id=" + this.getId() + ", object=" + this.getObject() + ", modalities=" + this.getModalities() + ", model=" + this.getModel() + ", instructions=" + this.getInstructions() + ", voice=" + this.getVoice() + ", inputAudioFormat=" + this.getInputAudioFormat() + ", outputAudioFormat=" + this.getOutputAudioFormat() + ", inputAudioTranscription=" + this.getInputAudioTranscription() + ", turnDetection=" + this.getTurnDetection() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", temperature=" + this.getTemperature() + ", maxResponseOutputTokens=" + this.getMaxResponseOutputTokens() + ")";
    }

    @Generated
    public RealtimeSession() {
    }

    @Generated
    public RealtimeSession(String id, String object, List<ChatRequest.Modality> modalities, String model, String instructions, VoiceRealtime voice, AudioFormatRealtime inputAudioFormat, AudioFormatRealtime outputAudioFormat, InputAudioTranscription inputAudioTranscription, TurnDetection turnDetection, List<ToolRealtime> tools, Object toolChoice, Double temperature, Object maxResponseOutputTokens) {
        this.id = id;
        this.object = object;
        this.modalities = modalities;
        this.model = model;
        this.instructions = instructions;
        this.voice = voice;
        this.inputAudioFormat = inputAudioFormat;
        this.outputAudioFormat = outputAudioFormat;
        this.inputAudioTranscription = inputAudioTranscription;
        this.turnDetection = turnDetection;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.maxResponseOutputTokens = maxResponseOutputTokens;
    }

    @Generated
    private static final class RealtimeSessionBuilderImpl
    extends RealtimeSessionBuilder<RealtimeSession, RealtimeSessionBuilderImpl> {
        @Generated
        private RealtimeSessionBuilderImpl() {
        }

        @Override
        @Generated
        protected RealtimeSessionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealtimeSession build() {
            return new RealtimeSession(this);
        }
    }

    @Generated
    public static abstract class RealtimeSessionBuilder<C extends RealtimeSession, B extends RealtimeSessionBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String object;
        @Generated
        private ArrayList<ChatRequest.Modality> modalities;
        @Generated
        private String model;
        @Generated
        private String instructions;
        @Generated
        private VoiceRealtime voice;
        @Generated
        private AudioFormatRealtime inputAudioFormat;
        @Generated
        private AudioFormatRealtime outputAudioFormat;
        @Generated
        private InputAudioTranscription inputAudioTranscription;
        @Generated
        private TurnDetection turnDetection;
        @Generated
        private ArrayList<ToolRealtime> tools;
        @Generated
        private Object toolChoice;
        @Generated
        private Double temperature;
        @Generated
        private Object maxResponseOutputTokens;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B object(String object) {
            this.object = object;
            return this.self();
        }

        @Generated
        public B modality(ChatRequest.Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this.self();
        }

        @Generated
        public B modalities(Collection<? extends ChatRequest.Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this.self();
        }

        @Generated
        public B clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this.self();
        }

        @Generated
        public B model(String model) {
            this.model = model;
            return this.self();
        }

        @Generated
        public B instructions(String instructions) {
            this.instructions = instructions;
            return this.self();
        }

        @Generated
        public B voice(VoiceRealtime voice) {
            this.voice = voice;
            return this.self();
        }

        @Generated
        public B inputAudioFormat(AudioFormatRealtime inputAudioFormat) {
            this.inputAudioFormat = inputAudioFormat;
            return this.self();
        }

        @Generated
        public B outputAudioFormat(AudioFormatRealtime outputAudioFormat) {
            this.outputAudioFormat = outputAudioFormat;
            return this.self();
        }

        @Generated
        public B inputAudioTranscription(InputAudioTranscription inputAudioTranscription) {
            this.inputAudioTranscription = inputAudioTranscription;
            return this.self();
        }

        @Generated
        public B turnDetection(TurnDetection turnDetection) {
            this.turnDetection = turnDetection;
            return this.self();
        }

        @Generated
        public B tool(ToolRealtime tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this.self();
        }

        @Generated
        public B tools(Collection<? extends ToolRealtime> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this.self();
        }

        @Generated
        public B clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this.self();
        }

        @Generated
        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this.self();
        }

        @Generated
        public B temperature(Double temperature) {
            this.temperature = temperature;
            return this.self();
        }

        @Generated
        public B maxResponseOutputTokens(Object maxResponseOutputTokens) {
            this.maxResponseOutputTokens = maxResponseOutputTokens;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RealtimeSession.RealtimeSessionBuilder(id=" + this.id + ", object=" + this.object + ", modalities=" + this.modalities + ", model=" + this.model + ", instructions=" + this.instructions + ", voice=" + this.voice + ", inputAudioFormat=" + this.inputAudioFormat + ", outputAudioFormat=" + this.outputAudioFormat + ", inputAudioTranscription=" + this.inputAudioTranscription + ", turnDetection=" + this.turnDetection + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", temperature=" + this.temperature + ", maxResponseOutputTokens=" + this.maxResponseOutputTokens + ")";
        }
    }

    public static class ToolRealtime {
        private ToolType type;
        private String name;
        private String description;
        private JsonNode parameters;

        public static ToolRealtime of(FunctionDef function) {
            return new ToolRealtime(ToolType.FUNCTION, function.getName(), function.getDescription(), function.getSchemaConverter().convert(function.getFunctionalClass()));
        }

        @Generated
        public ToolType getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.ToolRealtime(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
        }

        @Generated
        public ToolRealtime() {
        }

        @Generated
        private ToolRealtime(ToolType type, String name, String description, JsonNode parameters) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.parameters = parameters;
        }
    }

    public static class TurnDetection {
        private String type;
        @Range(min=0.0, max=1.0)
        private Double threshold;
        private Integer prefixPaddingMs;
        private Integer silenceDurationMs;
        private Boolean createReponse;

        @Generated
        private static String $default$type() {
            return "server_vad";
        }

        @Generated
        public static TurnDetectionBuilder builder() {
            return new TurnDetectionBuilder();
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Double getThreshold() {
            return this.threshold;
        }

        @Generated
        public Integer getPrefixPaddingMs() {
            return this.prefixPaddingMs;
        }

        @Generated
        public Integer getSilenceDurationMs() {
            return this.silenceDurationMs;
        }

        @Generated
        public Boolean getCreateReponse() {
            return this.createReponse;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.TurnDetection(type=" + this.getType() + ", threshold=" + this.getThreshold() + ", prefixPaddingMs=" + this.getPrefixPaddingMs() + ", silenceDurationMs=" + this.getSilenceDurationMs() + ", createReponse=" + this.getCreateReponse() + ")";
        }

        @Generated
        public TurnDetection() {
            this.type = TurnDetection.$default$type();
        }

        @Generated
        public TurnDetection(String type, Double threshold, Integer prefixPaddingMs, Integer silenceDurationMs, Boolean createReponse) {
            this.type = type;
            this.threshold = threshold;
            this.prefixPaddingMs = prefixPaddingMs;
            this.silenceDurationMs = silenceDurationMs;
            this.createReponse = createReponse;
        }

        @Generated
        public static class TurnDetectionBuilder {
            @Generated
            private boolean type$set;
            @Generated
            private String type$value;
            @Generated
            private Double threshold;
            @Generated
            private Integer prefixPaddingMs;
            @Generated
            private Integer silenceDurationMs;
            @Generated
            private Boolean createReponse;

            @Generated
            TurnDetectionBuilder() {
            }

            @Generated
            public TurnDetectionBuilder type(String type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            @Generated
            public TurnDetectionBuilder threshold(Double threshold) {
                this.threshold = threshold;
                return this;
            }

            @Generated
            public TurnDetectionBuilder prefixPaddingMs(Integer prefixPaddingMs) {
                this.prefixPaddingMs = prefixPaddingMs;
                return this;
            }

            @Generated
            public TurnDetectionBuilder silenceDurationMs(Integer silenceDurationMs) {
                this.silenceDurationMs = silenceDurationMs;
                return this;
            }

            @Generated
            public TurnDetectionBuilder createReponse(Boolean createReponse) {
                this.createReponse = createReponse;
                return this;
            }

            @Generated
            public TurnDetection build() {
                String type$value = this.type$value;
                if (!this.type$set) {
                    type$value = TurnDetection.$default$type();
                }
                return new TurnDetection(type$value, this.threshold, this.prefixPaddingMs, this.silenceDurationMs, this.createReponse);
            }

            @Generated
            public String toString() {
                return "RealtimeSession.TurnDetection.TurnDetectionBuilder(type$value=" + this.type$value + ", threshold=" + this.threshold + ", prefixPaddingMs=" + this.prefixPaddingMs + ", silenceDurationMs=" + this.silenceDurationMs + ", createReponse=" + this.createReponse + ")";
            }
        }
    }

    public static class InputAudioTranscription {
        private String model;

        public static InputAudioTranscription of(String model) {
            return new InputAudioTranscription(model);
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public String toString() {
            return "RealtimeSession.InputAudioTranscription(model=" + this.getModel() + ")";
        }

        @Generated
        public InputAudioTranscription() {
        }

        @Generated
        private InputAudioTranscription(String model) {
            this.model = model;
        }
    }

    public static enum AudioFormatRealtime {
        PCM16,
        G711_ULAW,
        G711_ALAW;

    }

    public static enum VoiceRealtime {
        ASH,
        BALLAD,
        CORAL,
        SAGE,
        VERSE,
        ALLOY,
        ECHO,
        SHIMMER;

    }
}

