/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.content;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.audio.InputAudioFormat;
import io.github.sashirestela.openai.common.content.FileAnnotation;
import io.github.sashirestela.openai.common.content.ImageDetail;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.List;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ContentPartImageFile.class, name="image_file"), @JsonSubTypes.Type(value=ContentPartImageUrl.class, name="image_url"), @JsonSubTypes.Type(value=ContentPartInputAudio.class, name="input_audio"), @JsonSubTypes.Type(value=ContentPartRefusal.class, name="refusal"), @JsonSubTypes.Type(value=ContentPartTextAnnotation.class, name="text")})
public abstract class ContentPart {
    protected ContentPartType type;

    @Generated
    public ContentPart() {
    }

    @Generated
    public ContentPartType getType() {
        return this.type;
    }

    @Generated
    public String toString() {
        return "ContentPart(type=" + this.getType() + ")";
    }

    public static class ContentPartTextAnnotation
    extends ContentPartText {
        private TextAnnotation text;

        @Generated
        public ContentPartTextAnnotation() {
        }

        @Override
        @Generated
        public TextAnnotation getText() {
            return this.text;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartTextAnnotation(text=" + this.getText() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class TextAnnotation {
            private String value;
            private List<FileAnnotation> annotations;

            @Generated
            public TextAnnotation() {
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public List<FileAnnotation> getAnnotations() {
                return this.annotations;
            }

            @Generated
            public String toString() {
                return "ContentPart.ContentPartTextAnnotation.TextAnnotation(value=" + this.getValue() + ", annotations=" + this.getAnnotations() + ")";
            }
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ContentPartImageFile
    extends ContentPart {
        @Required
        private ImageFile imageFile;

        private ContentPartImageFile(ImageFile imageFile) {
            this.type = ContentPartType.IMAGE_FILE;
            this.imageFile = imageFile;
        }

        public static ContentPartImageFile of(ImageFile imageFile) {
            return new ContentPartImageFile(imageFile);
        }

        @Generated
        public ContentPartImageFile() {
        }

        @Generated
        public ImageFile getImageFile() {
            return this.imageFile;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartImageFile(imageFile=" + this.getImageFile() + ")";
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ImageFile {
            @Required
            private String fileId;
            private ImageDetail detail;

            private ImageFile(String fileId, ImageDetail detail) {
                this.fileId = fileId;
                this.detail = detail;
            }

            public static ImageFile of(String fileId, ImageDetail detail) {
                return new ImageFile(fileId, detail);
            }

            public static ImageFile of(String fileId) {
                return new ImageFile(fileId, null);
            }

            @Generated
            public ImageFile() {
            }

            @Generated
            public String getFileId() {
                return this.fileId;
            }

            @Generated
            public ImageDetail getDetail() {
                return this.detail;
            }

            @Generated
            public String toString() {
                return "ContentPart.ContentPartImageFile.ImageFile(fileId=" + this.getFileId() + ", detail=" + this.getDetail() + ")";
            }
        }
    }

    public static class ContentPartRefusal
    extends ChatContentPart {
        @Required
        private String refusal;

        private ContentPartRefusal(String refusal) {
            this.type = ContentPartType.REFUSAL;
            this.refusal = refusal;
        }

        public static ContentPartRefusal of(String refusal) {
            return new ContentPartRefusal(refusal);
        }

        @Generated
        public ContentPartRefusal() {
        }

        @Generated
        public String getRefusal() {
            return this.refusal;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartRefusal(refusal=" + this.getRefusal() + ")";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ContentPartInputAudio
    extends ChatContentPart {
        @Required
        private InputAudio inputAudio;

        private ContentPartInputAudio(InputAudio inputAudio) {
            this.type = ContentPartType.INPUT_AUDIO;
            this.inputAudio = inputAudio;
        }

        public static ContentPartInputAudio of(InputAudio inputAudio) {
            return new ContentPartInputAudio(inputAudio);
        }

        @Generated
        public ContentPartInputAudio() {
        }

        @Generated
        public InputAudio getInputAudio() {
            return this.inputAudio;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartInputAudio(inputAudio=" + this.getInputAudio() + ")";
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public static class InputAudio {
            @Required
            private String data;
            @Required
            private InputAudioFormat format;

            private InputAudio(String data, InputAudioFormat format) {
                this.data = data;
                this.format = format;
            }

            public static InputAudio of(String data, InputAudioFormat format) {
                return new InputAudio(data, format);
            }

            @Generated
            public InputAudio() {
            }

            @Generated
            public String getData() {
                return this.data;
            }

            @Generated
            public InputAudioFormat getFormat() {
                return this.format;
            }

            @Generated
            public String toString() {
                return "ContentPart.ContentPartInputAudio.InputAudio(data=" + this.getData() + ", format=" + this.getFormat() + ")";
            }
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ContentPartImageUrl
    extends ChatContentPart {
        @Required
        private ImageUrl imageUrl;

        private ContentPartImageUrl(ImageUrl imageUrl) {
            this.type = ContentPartType.IMAGE_URL;
            this.imageUrl = imageUrl;
        }

        public static ContentPartImageUrl of(ImageUrl imageUrl) {
            return new ContentPartImageUrl(imageUrl);
        }

        @Generated
        public ContentPartImageUrl() {
        }

        @Generated
        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartImageUrl(imageUrl=" + this.getImageUrl() + ")";
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public static class ImageUrl {
            @Required
            private String url;
            private ImageDetail detail;

            private ImageUrl(String url, ImageDetail detail) {
                this.url = url;
                this.detail = detail;
            }

            public static ImageUrl of(String url, ImageDetail detail) {
                return new ImageUrl(url, detail);
            }

            public static ImageUrl of(String url) {
                return new ImageUrl(url, null);
            }

            @Generated
            public ImageUrl() {
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public ImageDetail getDetail() {
                return this.detail;
            }

            @Generated
            public String toString() {
                return "ContentPart.ContentPartImageUrl.ImageUrl(url=" + this.getUrl() + ", detail=" + this.getDetail() + ")";
            }
        }
    }

    public static class ContentPartText
    extends ChatContentPart {
        @Required
        private Object text;

        private ContentPartText(String text) {
            this.type = ContentPartType.TEXT;
            this.text = text;
        }

        public static ContentPartText of(String text) {
            return new ContentPartText(text);
        }

        @Generated
        public ContentPartText() {
        }

        @Generated
        public Object getText() {
            return this.text;
        }

        @Override
        @Generated
        public String toString() {
            return "ContentPart.ContentPartText(text=" + this.getText() + ")";
        }
    }

    public static abstract class ChatContentPart
    extends ContentPart {
    }

    public static enum ContentPartType {
        TEXT,
        IMAGE_URL,
        IMAGE_FILE,
        INPUT_AUDIO,
        REFUSAL;

    }
}

