/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import io.github.sashirestela.openai.service.EmbeddingServices;
import io.github.sashirestela.openai.service.ModelServices;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIMistral
extends OpenAIProvider
implements ChatCompletionServices,
EmbeddingServices,
ModelServices {
    public SimpleOpenAIMistral(@NonNull String apiKey, String baseUrl, HttpClient httpClient, HttpClientAdapter clientAdapter, RetryConfig retryConfig, ObjectMapper objectMapper) {
        super(((MistralConfigurator.MistralConfiguratorBuilder)((MistralConfigurator.MistralConfiguratorBuilder)((MistralConfigurator.MistralConfiguratorBuilder)((MistralConfigurator.MistralConfiguratorBuilder)((MistralConfigurator.MistralConfiguratorBuilder)((MistralConfigurator.MistralConfiguratorBuilder)MistralConfigurator.builder().apiKey(apiKey)).baseUrl(baseUrl)).httpClient(httpClient)).clientAdapter(clientAdapter)).retryConfig(retryConfig)).objectMapper(objectMapper)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        return this.getOrCreateService(OpenAI.Embeddings.class);
    }

    @Override
    public OpenAI.Models models() {
        return this.getOrCreateService(OpenAI.Models.class);
    }

    @Generated
    public static SimpleOpenAIMistralBuilder builder() {
        return new SimpleOpenAIMistralBuilder();
    }

    @Generated
    public static class SimpleOpenAIMistralBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIMistralBuilder() {
        }

        @Generated
        public SimpleOpenAIMistralBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIMistralBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIMistralBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIMistralBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public SimpleOpenAIMistralBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public SimpleOpenAIMistralBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIMistral build() {
            return new SimpleOpenAIMistral(this.apiKey, this.baseUrl, this.httpClient, this.clientAdapter, this.retryConfig, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIMistral.SimpleOpenAIMistralBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", httpClient=" + String.valueOf(this.httpClient) + ", clientAdapter=" + String.valueOf(this.clientAdapter) + ", retryConfig=" + String.valueOf(this.retryConfig) + ", objectMapper=" + String.valueOf(this.objectMapper) + ")";
        }
    }

    static class MistralConfigurator
    extends OpenAIConfigurator {
        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(Optional.ofNullable(this.baseUrl).orElse("https://api.mistral.ai")).headers(Map.of("Authorization", "Bearer " + this.apiKey)).httpClient(this.httpClient).clientAdapter(this.clientAdapter).retryConfig(this.retryConfig).requestInterceptor(this.makeRequestInterceptor()).objectMapper(this.objectMapper).build();
        }

        private UnaryOperator<HttpRequestData> makeRequestInterceptor() {
            return request -> {
                ContentType contentType = request.getContentType();
                if (contentType != null && contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                    String body = this.makeNewBody((HttpRequestData)request);
                    request.setBody((Object)body);
                }
                return request;
            };
        }

        private String makeNewBody(HttpRequestData request) {
            HashMap<String, String> mapRegexReplace = new HashMap<String, String>();
            mapRegexReplace.put(",\\s*\"stream_options\"\\s*:\\s*\\{[^{}]*\\}", "");
            mapRegexReplace.put(",?\\s*\"additionalProperties\"\\s*:\\s*false\\s*", "");
            mapRegexReplace.put(",?\\s*\"strict\"\\s*:\\s*true\\s*", "");
            mapRegexReplace.put(",\\s*,", ",");
            mapRegexReplace.put(",\\s*}", "}");
            mapRegexReplace.put("\"index\"\\s*:\\s*null\\s*,\\s*", "");
            mapRegexReplace.put(",\\s*\"refusal\"\\s*:\\s*null", "");
            mapRegexReplace.put(",\\s*\"audio\"\\s*:\\s*null", "");
            String body = (String)request.getBody();
            for (Map.Entry entry : mapRegexReplace.entrySet()) {
                body = body.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
            return body;
        }

        @Generated
        protected MistralConfigurator(MistralConfiguratorBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static MistralConfiguratorBuilder<?, ?> builder() {
            return new MistralConfiguratorBuilderImpl();
        }

        @Generated
        private static final class MistralConfiguratorBuilderImpl
        extends MistralConfiguratorBuilder<MistralConfigurator, MistralConfiguratorBuilderImpl> {
            @Generated
            private MistralConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected MistralConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MistralConfigurator build() {
                return new MistralConfigurator(this);
            }
        }

        @Generated
        public static abstract class MistralConfiguratorBuilder<C extends MistralConfigurator, B extends MistralConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIMistral.MistralConfigurator.MistralConfiguratorBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

