/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.function;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import io.github.sashirestela.openai.common.function.Functional;
import io.github.sashirestela.openai.common.function.SchemaConverter;
import io.github.sashirestela.openai.support.JsonSchemaUtil;
import lombok.Generated;
import lombok.NonNull;

public class FunctionDef {
    @NonNull
    private String name;
    private String description;
    @NonNull
    private Class<? extends Functional> functionalClass;
    private Boolean strict;
    private SchemaConverter schemaConverter;

    public static FunctionDef of(Class<? extends Functional> functionalClass) {
        String name = functionalClass.getSimpleName();
        String description = functionalClass.isAnnotationPresent(JsonClassDescription.class) ? functionalClass.getAnnotation(JsonClassDescription.class).value() : "";
        Boolean strict = Boolean.TRUE;
        return FunctionDef.builder().name(name).description(description).functionalClass(functionalClass).strict(strict).build();
    }

    @Generated
    private static SchemaConverter $default$schemaConverter() {
        return JsonSchemaUtil.defaultConverter;
    }

    @Generated
    FunctionDef(@NonNull String name, String description, @NonNull Class<? extends Functional> functionalClass, Boolean strict, SchemaConverter schemaConverter) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (functionalClass == null) {
            throw new NullPointerException("functionalClass is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.functionalClass = functionalClass;
        this.strict = strict;
        this.schemaConverter = schemaConverter;
    }

    @Generated
    public static FunctionDefBuilder builder() {
        return new FunctionDefBuilder();
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public Class<? extends Functional> getFunctionalClass() {
        return this.functionalClass;
    }

    @Generated
    public Boolean getStrict() {
        return this.strict;
    }

    @Generated
    public SchemaConverter getSchemaConverter() {
        return this.schemaConverter;
    }

    @Generated
    public static class FunctionDefBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Class<? extends Functional> functionalClass;
        @Generated
        private Boolean strict;
        @Generated
        private boolean schemaConverter$set;
        @Generated
        private SchemaConverter schemaConverter$value;

        @Generated
        FunctionDefBuilder() {
        }

        @Generated
        public FunctionDefBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public FunctionDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public FunctionDefBuilder functionalClass(@NonNull Class<? extends Functional> functionalClass) {
            if (functionalClass == null) {
                throw new NullPointerException("functionalClass is marked non-null but is null");
            }
            this.functionalClass = functionalClass;
            return this;
        }

        @Generated
        public FunctionDefBuilder strict(Boolean strict) {
            this.strict = strict;
            return this;
        }

        @Generated
        public FunctionDefBuilder schemaConverter(SchemaConverter schemaConverter) {
            this.schemaConverter$value = schemaConverter;
            this.schemaConverter$set = true;
            return this;
        }

        @Generated
        public FunctionDef build() {
            SchemaConverter schemaConverter$value = this.schemaConverter$value;
            if (!this.schemaConverter$set) {
                schemaConverter$value = FunctionDef.$default$schemaConverter();
            }
            return new FunctionDef(this.name, this.description, this.functionalClass, this.strict, schemaConverter$value);
        }

        @Generated
        public String toString() {
            return "FunctionDef.FunctionDefBuilder(name=" + this.name + ", description=" + this.description + ", functionalClass=" + String.valueOf(this.functionalClass) + ", strict=" + this.strict + ", schemaConverter$value=" + String.valueOf(this.schemaConverter$value) + ")";
        }
    }
}

