/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;

public class Poller<T> {
    @NonNull
    private TimeUnit timeUnit;
    @NonNull
    private Integer timeValue;
    @NonNull
    private UnaryOperator<T> queryMethod;
    @NonNull
    private Predicate<T> whileMethod;

    public T execute(T startValue) {
        Object object = startValue;
        do {
            try {
                this.timeUnit.sleep(this.timeValue.longValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (this.whileMethod.test(object = this.queryMethod.apply(object)));
        return object;
    }

    @Generated
    Poller(@NonNull TimeUnit timeUnit, @NonNull Integer timeValue, @NonNull UnaryOperator<T> queryMethod, @NonNull Predicate<T> whileMethod) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        if (timeValue == null) {
            throw new NullPointerException("timeValue is marked non-null but is null");
        }
        if (queryMethod == null) {
            throw new NullPointerException("queryMethod is marked non-null but is null");
        }
        if (whileMethod == null) {
            throw new NullPointerException("whileMethod is marked non-null but is null");
        }
        this.timeUnit = timeUnit;
        this.timeValue = timeValue;
        this.queryMethod = queryMethod;
        this.whileMethod = whileMethod;
    }

    @Generated
    public static <T> PollerBuilder<T> builder() {
        return new PollerBuilder();
    }

    @NonNull
    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @NonNull
    @Generated
    public Integer getTimeValue() {
        return this.timeValue;
    }

    @NonNull
    @Generated
    public UnaryOperator<T> getQueryMethod() {
        return this.queryMethod;
    }

    @NonNull
    @Generated
    public Predicate<T> getWhileMethod() {
        return this.whileMethod;
    }

    @Generated
    public static class PollerBuilder<T> {
        @Generated
        private TimeUnit timeUnit;
        @Generated
        private Integer timeValue;
        @Generated
        private UnaryOperator<T> queryMethod;
        @Generated
        private Predicate<T> whileMethod;

        @Generated
        PollerBuilder() {
        }

        @Generated
        public PollerBuilder<T> timeUnit(@NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.timeUnit = timeUnit;
            return this;
        }

        @Generated
        public PollerBuilder<T> timeValue(@NonNull Integer timeValue) {
            if (timeValue == null) {
                throw new NullPointerException("timeValue is marked non-null but is null");
            }
            this.timeValue = timeValue;
            return this;
        }

        @Generated
        public PollerBuilder<T> queryMethod(@NonNull UnaryOperator<T> queryMethod) {
            if (queryMethod == null) {
                throw new NullPointerException("queryMethod is marked non-null but is null");
            }
            this.queryMethod = queryMethod;
            return this;
        }

        @Generated
        public PollerBuilder<T> whileMethod(@NonNull Predicate<T> whileMethod) {
            if (whileMethod == null) {
                throw new NullPointerException("whileMethod is marked non-null but is null");
            }
            this.whileMethod = whileMethod;
            return this;
        }

        @Generated
        public Poller<T> build() {
            return new Poller<T>(this.timeUnit, this.timeValue, this.queryMethod, this.whileMethod);
        }

        @Generated
        public String toString() {
            return "Poller.PollerBuilder(timeUnit=" + String.valueOf((Object)this.timeUnit) + ", timeValue=" + this.timeValue + ", queryMethod=" + String.valueOf(this.queryMethod) + ", whileMethod=" + String.valueOf(this.whileMethod) + ")";
        }
    }
}

