/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.StreamOptions;
import io.github.sashirestela.openai.common.audio.AudioFormat;
import io.github.sashirestela.openai.common.audio.Voice;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.chat.ChatMessage;
import io.github.sashirestela.openai.domain.response.ResponseTool;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ChatRequest {
    @Required
    private List<ChatMessage> messages;
    @Required
    private String model;
    private Boolean store;
    private ReasoningEffort reasoningEffort;
    private Map<String, String> metadata;
    @Range(min=-2.0, max=2.0)
    private Double frequencyPenalty;
    private Map<String, Integer> logitBias;
    private Boolean logprobs;
    @Range(min=0.0, max=20.0)
    private Integer topLogprobs;
    @Deprecated(since="3.9.0", forRemoval=true)
    private Integer maxTokens;
    private Integer maxCompletionTokens;
    @Range(min=1.0, max=128.0)
    private Integer n;
    private List<Modality> modalities;
    private Audio audio;
    @Range(min=-2.0, max=2.0)
    private Double presencePenalty;
    private ResponseFormat responseFormat;
    private Integer seed;
    private ServiceTier serviceTier;
    @ObjectType.ObjectTypes(value={@ObjectType(baseClass={String.class}), @ObjectType(schema=ObjectType.Schema.COLL, baseClass={String.class}, maxSize=4)})
    private Object stop;
    private Boolean stream;
    private StreamOptions streamOptions;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private List<Tool> tools;
    @ObjectType(baseClass={ToolChoiceOption.class, ToolChoice.class})
    private Object toolChoice;
    private Boolean parallelToolCalls;
    private String user;
    private WebSearchOptions webSearchOptions;

    @Generated
    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    @Generated
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Boolean getStore() {
        return this.store;
    }

    @Generated
    public ReasoningEffort getReasoningEffort() {
        return this.reasoningEffort;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Generated
    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    @Generated
    public Boolean getLogprobs() {
        return this.logprobs;
    }

    @Generated
    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    @Deprecated
    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    @Generated
    public Integer getN() {
        return this.n;
    }

    @Generated
    public List<Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public Audio getAudio() {
        return this.audio;
    }

    @Generated
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    @Generated
    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public Integer getSeed() {
        return this.seed;
    }

    @Generated
    public ServiceTier getServiceTier() {
        return this.serviceTier;
    }

    @Generated
    public Object getStop() {
        return this.stop;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public List<Tool> getTools() {
        return this.tools;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public WebSearchOptions getWebSearchOptions() {
        return this.webSearchOptions;
    }

    @Generated
    public ChatRequest(List<ChatMessage> messages, String model, Boolean store, ReasoningEffort reasoningEffort, Map<String, String> metadata, Double frequencyPenalty, Map<String, Integer> logitBias, Boolean logprobs, Integer topLogprobs, Integer maxTokens, Integer maxCompletionTokens, Integer n, List<Modality> modalities, Audio audio, Double presencePenalty, ResponseFormat responseFormat, Integer seed, ServiceTier serviceTier, Object stop, Boolean stream, StreamOptions streamOptions, Double temperature, Double topP, List<Tool> tools, Object toolChoice, Boolean parallelToolCalls, String user, WebSearchOptions webSearchOptions) {
        this.messages = messages;
        this.model = model;
        this.store = store;
        this.reasoningEffort = reasoningEffort;
        this.metadata = metadata;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
        this.maxTokens = maxTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.n = n;
        this.modalities = modalities;
        this.audio = audio;
        this.presencePenalty = presencePenalty;
        this.responseFormat = responseFormat;
        this.seed = seed;
        this.serviceTier = serviceTier;
        this.stop = stop;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.temperature = temperature;
        this.topP = topP;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.user = user;
        this.webSearchOptions = webSearchOptions;
    }

    @Generated
    public ChatRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ChatRequest(this.messages, this.model, this.store, this.reasoningEffort, this.metadata, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.modalities, this.audio, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop, stream, this.streamOptions, this.temperature, this.topP, this.tools, this.toolChoice, this.parallelToolCalls, this.user, this.webSearchOptions);
    }

    @Generated
    public ChatRequest withStreamOptions(StreamOptions streamOptions) {
        return this.streamOptions == streamOptions ? this : new ChatRequest(this.messages, this.model, this.store, this.reasoningEffort, this.metadata, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.modalities, this.audio, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop, this.stream, streamOptions, this.temperature, this.topP, this.tools, this.toolChoice, this.parallelToolCalls, this.user, this.webSearchOptions);
    }

    @Generated
    public ChatRequest withToolChoice(Object toolChoice) {
        return this.toolChoice == toolChoice ? this : new ChatRequest(this.messages, this.model, this.store, this.reasoningEffort, this.metadata, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.modalities, this.audio, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop, this.stream, this.streamOptions, this.temperature, this.topP, this.tools, toolChoice, this.parallelToolCalls, this.user, this.webSearchOptions);
    }

    @Generated
    public static class ChatRequestBuilder {
        @Generated
        private ArrayList<ChatMessage> messages;
        @Generated
        private String model;
        @Generated
        private Boolean store;
        @Generated
        private ReasoningEffort reasoningEffort;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Map<String, Integer> logitBias;
        @Generated
        private Boolean logprobs;
        @Generated
        private Integer topLogprobs;
        @Generated
        private Integer maxTokens;
        @Generated
        private Integer maxCompletionTokens;
        @Generated
        private Integer n;
        @Generated
        private ArrayList<Modality> modalities;
        @Generated
        private Audio audio;
        @Generated
        private Double presencePenalty;
        @Generated
        private ResponseFormat responseFormat;
        @Generated
        private Integer seed;
        @Generated
        private ServiceTier serviceTier;
        @Generated
        private Object stop;
        @Generated
        private Boolean stream;
        @Generated
        private StreamOptions streamOptions;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private ArrayList<Tool> tools;
        @Generated
        private Object toolChoice;
        @Generated
        private Boolean parallelToolCalls;
        @Generated
        private String user;
        @Generated
        private WebSearchOptions webSearchOptions;

        @Generated
        ChatRequestBuilder() {
        }

        @Generated
        public ChatRequestBuilder message(ChatMessage message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        @Generated
        public ChatRequestBuilder messages(Collection<? extends ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        @Generated
        public ChatRequestBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        @Generated
        public ChatRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public ChatRequestBuilder store(Boolean store) {
            this.store = store;
            return this;
        }

        @Generated
        public ChatRequestBuilder reasoningEffort(ReasoningEffort reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            return this;
        }

        @Generated
        public ChatRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ChatRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Generated
        public ChatRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        @Generated
        public ChatRequestBuilder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @Generated
        public ChatRequestBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        @Deprecated
        @Generated
        public ChatRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Generated
        public ChatRequestBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        @Generated
        public ChatRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        @Generated
        public ChatRequestBuilder modality(Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this;
        }

        @Generated
        public ChatRequestBuilder modalities(Collection<? extends Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this;
        }

        @Generated
        public ChatRequestBuilder clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this;
        }

        @Generated
        public ChatRequestBuilder audio(Audio audio) {
            this.audio = audio;
            return this;
        }

        @Generated
        public ChatRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Generated
        public ChatRequestBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public ChatRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public ChatRequestBuilder serviceTier(ServiceTier serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        @Generated
        public ChatRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        @Generated
        public ChatRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ChatRequestBuilder streamOptions(StreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }

        @Generated
        public ChatRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ChatRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public ChatRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public ChatRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public ChatRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public ChatRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ChatRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Generated
        public ChatRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public ChatRequestBuilder webSearchOptions(WebSearchOptions webSearchOptions) {
            this.webSearchOptions = webSearchOptions;
            return this;
        }

        @Generated
        public ChatRequest build() {
            List<Tool> tools;
            List<Modality> modalities;
            List<ChatMessage> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<ChatMessage>(this.messages));
                }
            }
            switch (this.modalities == null ? 0 : this.modalities.size()) {
                case 0: {
                    modalities = Collections.emptyList();
                    break;
                }
                case 1: {
                    modalities = Collections.singletonList(this.modalities.get(0));
                    break;
                }
                default: {
                    modalities = Collections.unmodifiableList(new ArrayList<Modality>(this.modalities));
                }
            }
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new ChatRequest(messages, this.model, this.store, this.reasoningEffort, this.metadata, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, modalities, this.audio, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop, this.stream, this.streamOptions, this.temperature, this.topP, tools, this.toolChoice, this.parallelToolCalls, this.user, this.webSearchOptions);
        }

        @Generated
        public String toString() {
            return "ChatRequest.ChatRequestBuilder(messages=" + String.valueOf(this.messages) + ", model=" + this.model + ", store=" + this.store + ", reasoningEffort=" + String.valueOf((Object)this.reasoningEffort) + ", metadata=" + String.valueOf(this.metadata) + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + String.valueOf(this.logitBias) + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", maxTokens=" + this.maxTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", n=" + this.n + ", modalities=" + String.valueOf(this.modalities) + ", audio=" + String.valueOf(this.audio) + ", presencePenalty=" + this.presencePenalty + ", responseFormat=" + String.valueOf(this.responseFormat) + ", seed=" + this.seed + ", serviceTier=" + String.valueOf((Object)this.serviceTier) + ", stop=" + String.valueOf(this.stop) + ", stream=" + this.stream + ", streamOptions=" + String.valueOf(this.streamOptions) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", tools=" + String.valueOf(this.tools) + ", toolChoice=" + String.valueOf(this.toolChoice) + ", parallelToolCalls=" + this.parallelToolCalls + ", user=" + this.user + ", webSearchOptions=" + String.valueOf(this.webSearchOptions) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class WebSearchOptions {
        private ResponseTool.ContextSize searchContextSize;
        private UserLocation userLocation;

        public WebSearchOptions(ResponseTool.ContextSize searchContextSize, UserLocation userLocation) {
            this.searchContextSize = searchContextSize;
            this.userLocation = userLocation;
        }

        public static WebSearchOptions of() {
            return WebSearchOptions.builder().build();
        }

        @Generated
        public static WebSearchOptionsBuilder builder() {
            return new WebSearchOptionsBuilder();
        }

        @Generated
        public ResponseTool.ContextSize getSearchContextSize() {
            return this.searchContextSize;
        }

        @Generated
        public UserLocation getUserLocation() {
            return this.userLocation;
        }

        @Generated
        public String toString() {
            return "ChatRequest.WebSearchOptions(searchContextSize=" + String.valueOf((Object)this.getSearchContextSize()) + ", userLocation=" + String.valueOf(this.getUserLocation()) + ")";
        }

        @Generated
        public static class WebSearchOptionsBuilder {
            @Generated
            private ResponseTool.ContextSize searchContextSize;
            @Generated
            private UserLocation userLocation;

            @Generated
            WebSearchOptionsBuilder() {
            }

            @Generated
            public WebSearchOptionsBuilder searchContextSize(ResponseTool.ContextSize searchContextSize) {
                this.searchContextSize = searchContextSize;
                return this;
            }

            @Generated
            public WebSearchOptionsBuilder userLocation(UserLocation userLocation) {
                this.userLocation = userLocation;
                return this;
            }

            @Generated
            public WebSearchOptions build() {
                return new WebSearchOptions(this.searchContextSize, this.userLocation);
            }

            @Generated
            public String toString() {
                return "ChatRequest.WebSearchOptions.WebSearchOptionsBuilder(searchContextSize=" + String.valueOf((Object)this.searchContextSize) + ", userLocation=" + String.valueOf(this.userLocation) + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ApproxLocation {
            private String city;
            private String country;
            private String region;
            private String timezone;

            public ApproxLocation(String city, String country, String region, String timezone) {
                this.city = city;
                this.country = country;
                this.region = region;
                this.timezone = timezone;
            }

            @Generated
            public static ApproxLocationBuilder builder() {
                return new ApproxLocationBuilder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getRegion() {
                return this.region;
            }

            @Generated
            public String getTimezone() {
                return this.timezone;
            }

            @Generated
            public String toString() {
                return "ChatRequest.WebSearchOptions.ApproxLocation(city=" + this.getCity() + ", country=" + this.getCountry() + ", region=" + this.getRegion() + ", timezone=" + this.getTimezone() + ")";
            }

            @Generated
            public static class ApproxLocationBuilder {
                @Generated
                private String city;
                @Generated
                private String country;
                @Generated
                private String region;
                @Generated
                private String timezone;

                @Generated
                ApproxLocationBuilder() {
                }

                @Generated
                public ApproxLocationBuilder city(String city) {
                    this.city = city;
                    return this;
                }

                @Generated
                public ApproxLocationBuilder country(String country) {
                    this.country = country;
                    return this;
                }

                @Generated
                public ApproxLocationBuilder region(String region) {
                    this.region = region;
                    return this;
                }

                @Generated
                public ApproxLocationBuilder timezone(String timezone) {
                    this.timezone = timezone;
                    return this;
                }

                @Generated
                public ApproxLocation build() {
                    return new ApproxLocation(this.city, this.country, this.region, this.timezone);
                }

                @Generated
                public String toString() {
                    return "ChatRequest.WebSearchOptions.ApproxLocation.ApproxLocationBuilder(city=" + this.city + ", country=" + this.country + ", region=" + this.region + ", timezone=" + this.timezone + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class UserLocation {
            private ApproxLocation approximate;
            private String type;

            private UserLocation(ApproxLocation approximate) {
                this.approximate = approximate;
                this.type = "approximate";
            }

            public static UserLocation of(ApproxLocation approximate) {
                return new UserLocation(approximate);
            }

            @Generated
            public ApproxLocation getApproximate() {
                return this.approximate;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String toString() {
                return "ChatRequest.WebSearchOptions.UserLocation(approximate=" + String.valueOf(this.getApproximate()) + ", type=" + this.getType() + ")";
            }
        }
    }

    public static enum ReasoningEffort {
        LOW,
        MEDIUM,
        HIGH;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Audio {
        @Required
        private Voice voice;
        @Required
        private AudioFormat format;

        private Audio(Voice voice, AudioFormat format) {
            this.voice = voice;
            this.format = format;
        }

        public static Audio of(Voice voice, AudioFormat format) {
            return new Audio(voice, format);
        }

        @Generated
        public Voice getVoice() {
            return this.voice;
        }

        @Generated
        public AudioFormat getFormat() {
            return this.format;
        }

        @Generated
        public String toString() {
            return "ChatRequest.Audio(voice=" + String.valueOf((Object)this.getVoice()) + ", format=" + String.valueOf((Object)this.getFormat()) + ")";
        }
    }

    public static enum ServiceTier {
        AUTO,
        FLEX,
        DEFAULT,
        ON_DEMAND;

    }

    public static enum Modality {
        TEXT,
        AUDIO;

    }
}

