/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.support.DefaultSchemaConverter;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseText {
    private ResponseTextFormat format;

    public static ResponseText text() {
        return new ResponseText(new ResponseTextFormat(ResponseFormat.ResponseFormatType.TEXT));
    }

    public static ResponseText jsonObject() {
        return new ResponseText(new ResponseTextFormat(ResponseFormat.ResponseFormatType.JSON_OBJECT));
    }

    public static ResponseText jsonSchema(ResponseTextFormat.ResponseTextFormatJsonSchema format) {
        return new ResponseText(format);
    }

    @Generated
    private ResponseText(ResponseTextFormat format) {
        this.format = format;
    }

    @Generated
    public ResponseText() {
    }

    @Generated
    public ResponseTextFormat getFormat() {
        return this.format;
    }

    @Generated
    public String toString() {
        return "ResponseText(format=" + String.valueOf(this.getFormat()) + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseTextFormat {
        protected ResponseFormat.ResponseFormatType type;

        @Generated
        private ResponseTextFormat(ResponseFormat.ResponseFormatType type) {
            this.type = type;
        }

        @Generated
        public ResponseTextFormat() {
        }

        @Generated
        public ResponseFormat.ResponseFormatType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "ResponseText.ResponseTextFormat(type=" + String.valueOf((Object)this.getType()) + ")";
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ResponseTextFormatJsonSchema
        extends ResponseTextFormat {
            @Required
            @Size(max=64)
            private String name;
            @Required
            private JsonNode schema;
            private String description;
            private Boolean strict;

            public ResponseTextFormatJsonSchema(String name, JsonNode schema, String description, Boolean strict, Class<?> schemaClass) {
                this.type = ResponseFormat.ResponseFormatType.JSON_SCHEMA;
                this.name = name;
                this.description = description;
                this.strict = strict;
                this.schema = schema != null ? schema : (schemaClass != null ? new DefaultSchemaConverter(Boolean.TRUE).convert(schemaClass) : null);
            }

            public static ResponseTextFormatJsonSchema of(Class<?> schemaClass) {
                String name = schemaClass.getSimpleName();
                String description = schemaClass.isAnnotationPresent(JsonClassDescription.class) ? schemaClass.getAnnotation(JsonClassDescription.class).value() : "";
                Boolean strict = Boolean.TRUE;
                return ResponseTextFormatJsonSchema.builder().name(name).description(description).strict(strict).schemaClass(schemaClass).build();
            }

            @Generated
            public static ResponseTextFormatJsonSchemaBuilder builder() {
                return new ResponseTextFormatJsonSchemaBuilder();
            }

            @Generated
            public ResponseTextFormatJsonSchema() {
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public JsonNode getSchema() {
                return this.schema;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Boolean getStrict() {
                return this.strict;
            }

            @Override
            @Generated
            public String toString() {
                return "ResponseText.ResponseTextFormat.ResponseTextFormatJsonSchema(name=" + this.getName() + ", schema=" + String.valueOf(this.getSchema()) + ", description=" + this.getDescription() + ", strict=" + this.getStrict() + ")";
            }

            @Generated
            public static class ResponseTextFormatJsonSchemaBuilder {
                @Generated
                private String name;
                @Generated
                private JsonNode schema;
                @Generated
                private String description;
                @Generated
                private Boolean strict;
                @Generated
                private Class<?> schemaClass;

                @Generated
                ResponseTextFormatJsonSchemaBuilder() {
                }

                @Generated
                public ResponseTextFormatJsonSchemaBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                @Generated
                public ResponseTextFormatJsonSchemaBuilder schema(JsonNode schema) {
                    this.schema = schema;
                    return this;
                }

                @Generated
                public ResponseTextFormatJsonSchemaBuilder description(String description) {
                    this.description = description;
                    return this;
                }

                @Generated
                public ResponseTextFormatJsonSchemaBuilder strict(Boolean strict) {
                    this.strict = strict;
                    return this;
                }

                @Generated
                public ResponseTextFormatJsonSchemaBuilder schemaClass(Class<?> schemaClass) {
                    this.schemaClass = schemaClass;
                    return this;
                }

                @Generated
                public ResponseTextFormatJsonSchema build() {
                    return new ResponseTextFormatJsonSchema(this.name, this.schema, this.description, this.strict, this.schemaClass);
                }

                @Generated
                public String toString() {
                    return "ResponseText.ResponseTextFormat.ResponseTextFormatJsonSchema.ResponseTextFormatJsonSchemaBuilder(name=" + this.name + ", schema=" + String.valueOf(this.schema) + ", description=" + this.description + ", strict=" + this.strict + ", schemaClass=" + String.valueOf(this.schemaClass) + ")";
                }
            }
        }
    }
}

