/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Tool {
    protected ToolType type;
    protected ToolFunctionDef function;

    public static Tool function(FunctionDef function) {
        return new Tool(ToolType.FUNCTION, new ToolFunctionDef(function.getName(), function.getDescription(), function.getSchemaConverter().convert(function.getFunctionalClass()), function.getStrict()));
    }

    @Generated
    public Tool(ToolType type, ToolFunctionDef function) {
        this.type = type;
        this.function = function;
    }

    @Generated
    public Tool() {
    }

    @Generated
    public ToolType getType() {
        return this.type;
    }

    @Generated
    public ToolFunctionDef getFunction() {
        return this.function;
    }

    @Generated
    public String toString() {
        return "Tool(type=" + String.valueOf((Object)this.getType()) + ", function=" + String.valueOf(this.getFunction()) + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ToolFunctionDef {
        @Required
        @Size(max=64)
        private String name;
        private String description;
        @Required
        private JsonNode parameters;
        private Boolean strict;

        @Generated
        public ToolFunctionDef(String name, String description, JsonNode parameters, Boolean strict) {
            this.name = name;
            this.description = description;
            this.parameters = parameters;
            this.strict = strict;
        }

        @Generated
        public ToolFunctionDef() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public Boolean getStrict() {
            return this.strict;
        }

        @Generated
        public String toString() {
            return "Tool.ToolFunctionDef(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + String.valueOf(this.getParameters()) + ", strict=" + this.getStrict() + ")";
        }
    }
}

