/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.assistant.ThreadRequest;
import io.github.sashirestela.openai.domain.assistant.ToolResource;
import io.github.sashirestela.openai.domain.assistant.TruncationStrategy;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadCreateAndRunRequest {
    @Required
    private String assistantId;
    private ThreadRequest thread;
    private String model;
    private String instructions;
    @Size(max=20)
    private List<Tool> tools;
    private ToolResource toolResources;
    @Size(max=16)
    private Map<String, String> metadata;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private Boolean stream;
    @Range(min=256.0)
    private Integer maxPromptTokens;
    @Range(min=256.0)
    private Integer maxCompletionTokens;
    private TruncationStrategy truncationStrategy;
    @ObjectType(baseClass={ToolChoiceOption.class, ToolChoice.class})
    private Object toolChoice;
    private Boolean parallelToolCalls;
    @ObjectType(baseClass={String.class, ResponseFormat.class})
    private Object responseFormat;

    @Generated
    ThreadCreateAndRunRequest(String assistantId, ThreadRequest thread, String model, String instructions, List<Tool> tools, ToolResource toolResources, Map<String, String> metadata, Double temperature, Double topP, Boolean stream, Integer maxPromptTokens, Integer maxCompletionTokens, TruncationStrategy truncationStrategy, Object toolChoice, Boolean parallelToolCalls, Object responseFormat) {
        this.assistantId = assistantId;
        this.thread = thread;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.stream = stream;
        this.maxPromptTokens = maxPromptTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.truncationStrategy = truncationStrategy;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.responseFormat = responseFormat;
    }

    @Generated
    public static ThreadCreateAndRunRequestBuilder builder() {
        return new ThreadCreateAndRunRequestBuilder();
    }

    @Generated
    public String getAssistantId() {
        return this.assistantId;
    }

    @Generated
    public ThreadRequest getThread() {
        return this.thread;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public List<Tool> getTools() {
        return this.tools;
    }

    @Generated
    public ToolResource getToolResources() {
        return this.toolResources;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    @Generated
    public TruncationStrategy getTruncationStrategy() {
        return this.truncationStrategy;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public Object getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public ThreadCreateAndRunRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ThreadCreateAndRunRequest(this.assistantId, this.thread, this.model, this.instructions, this.tools, this.toolResources, this.metadata, this.temperature, this.topP, stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
    }

    @Generated
    public static class ThreadCreateAndRunRequestBuilder {
        @Generated
        private String assistantId;
        @Generated
        private ThreadRequest thread;
        @Generated
        private String model;
        @Generated
        private String instructions;
        @Generated
        private ArrayList<Tool> tools;
        @Generated
        private ToolResource toolResources;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Boolean stream;
        @Generated
        private Integer maxPromptTokens;
        @Generated
        private Integer maxCompletionTokens;
        @Generated
        private TruncationStrategy truncationStrategy;
        @Generated
        private Object toolChoice;
        @Generated
        private Boolean parallelToolCalls;
        @Generated
        private Object responseFormat;

        @Generated
        ThreadCreateAndRunRequestBuilder() {
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder thread(ThreadRequest thread) {
            this.thread = thread;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder toolResources(ToolResource toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder maxPromptTokens(Integer maxPromptTokens) {
            this.maxPromptTokens = maxPromptTokens;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = truncationStrategy;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequestBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public ThreadCreateAndRunRequest build() {
            List<Tool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new ThreadCreateAndRunRequest(this.assistantId, this.thread, this.model, this.instructions, tools, this.toolResources, this.metadata, this.temperature, this.topP, this.stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
        }

        @Generated
        public String toString() {
            return "ThreadCreateAndRunRequest.ThreadCreateAndRunRequestBuilder(assistantId=" + this.assistantId + ", thread=" + String.valueOf(this.thread) + ", model=" + this.model + ", instructions=" + this.instructions + ", tools=" + String.valueOf(this.tools) + ", toolResources=" + String.valueOf(this.toolResources) + ", metadata=" + String.valueOf(this.metadata) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", stream=" + this.stream + ", maxPromptTokens=" + this.maxPromptTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", truncationStrategy=" + String.valueOf(this.truncationStrategy) + ", toolChoice=" + String.valueOf(this.toolChoice) + ", parallelToolCalls=" + this.parallelToolCalls + ", responseFormat=" + String.valueOf(this.responseFormat) + ")";
        }
    }
}

