/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioResponseFormat;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TranscriptionRequest {
    @Required
    @Extension(value={"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"})
    private Path file;
    @Required
    private String model;
    private String language;
    private String prompt;
    private AudioResponseFormat responseFormat;
    @Range(min=0.0, max=1.0)
    private Double temperature;
    @Size(max=2)
    private Set<TimestampGranularity> timestampGranularities;

    @Generated
    TranscriptionRequest(Path file, String model, String language, String prompt, AudioResponseFormat responseFormat, Double temperature, Set<TimestampGranularity> timestampGranularities) {
        this.file = file;
        this.model = model;
        this.language = language;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.timestampGranularities = timestampGranularities;
    }

    @Generated
    public static TranscriptionRequestBuilder builder() {
        return new TranscriptionRequestBuilder();
    }

    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public AudioResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Set<TimestampGranularity> getTimestampGranularities() {
        return this.timestampGranularities;
    }

    @Generated
    public TranscriptionRequest withResponseFormat(AudioResponseFormat responseFormat) {
        return this.responseFormat == responseFormat ? this : new TranscriptionRequest(this.file, this.model, this.language, this.prompt, responseFormat, this.temperature, this.timestampGranularities);
    }

    @Generated
    public static class TranscriptionRequestBuilder {
        @Generated
        private Path file;
        @Generated
        private String model;
        @Generated
        private String language;
        @Generated
        private String prompt;
        @Generated
        private AudioResponseFormat responseFormat;
        @Generated
        private Double temperature;
        @Generated
        private ArrayList<TimestampGranularity> timestampGranularities;

        @Generated
        TranscriptionRequestBuilder() {
        }

        @Generated
        public TranscriptionRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder responseFormat(AudioResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder timestampGranularity(TimestampGranularity timestampGranularity) {
            if (this.timestampGranularities == null) {
                this.timestampGranularities = new ArrayList();
            }
            this.timestampGranularities.add(timestampGranularity);
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder timestampGranularities(Collection<? extends TimestampGranularity> timestampGranularities) {
            if (timestampGranularities == null) {
                throw new NullPointerException("timestampGranularities cannot be null");
            }
            if (this.timestampGranularities == null) {
                this.timestampGranularities = new ArrayList();
            }
            this.timestampGranularities.addAll(timestampGranularities);
            return this;
        }

        @Generated
        public TranscriptionRequestBuilder clearTimestampGranularities() {
            if (this.timestampGranularities != null) {
                this.timestampGranularities.clear();
            }
            return this;
        }

        @Generated
        public TranscriptionRequest build() {
            Set<Object> timestampGranularities;
            switch (this.timestampGranularities == null ? 0 : this.timestampGranularities.size()) {
                case 0: {
                    timestampGranularities = Collections.emptySet();
                    break;
                }
                case 1: {
                    timestampGranularities = Collections.singleton(this.timestampGranularities.get(0));
                    break;
                }
                default: {
                    timestampGranularities = new LinkedHashSet(this.timestampGranularities.size() < 0x40000000 ? 1 + this.timestampGranularities.size() + (this.timestampGranularities.size() - 3) / 3 : Integer.MAX_VALUE);
                    timestampGranularities.addAll(this.timestampGranularities);
                    timestampGranularities = Collections.unmodifiableSet(timestampGranularities);
                }
            }
            return new TranscriptionRequest(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, timestampGranularities);
        }

        @Generated
        public String toString() {
            return "TranscriptionRequest.TranscriptionRequestBuilder(file=" + String.valueOf(this.file) + ", model=" + this.model + ", language=" + this.language + ", prompt=" + this.prompt + ", responseFormat=" + String.valueOf((Object)this.responseFormat) + ", temperature=" + this.temperature + ", timestampGranularities=" + String.valueOf(this.timestampGranularities) + ")";
        }
    }

    public static enum TimestampGranularity {
        WORD,
        SEGMENT;

    }
}

