/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.upload;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class UploadCompleteRequest {
    @Required
    private List<String> partIds;
    private String md5;

    @Generated
    UploadCompleteRequest(List<String> partIds, String md5) {
        this.partIds = partIds;
        this.md5 = md5;
    }

    @Generated
    public static UploadCompleteRequestBuilder builder() {
        return new UploadCompleteRequestBuilder();
    }

    @Generated
    public List<String> getPartIds() {
        return this.partIds;
    }

    @Generated
    public String getMd5() {
        return this.md5;
    }

    @Generated
    public static class UploadCompleteRequestBuilder {
        @Generated
        private ArrayList<String> partIds;
        @Generated
        private String md5;

        @Generated
        UploadCompleteRequestBuilder() {
        }

        @Generated
        public UploadCompleteRequestBuilder partId(String partId) {
            if (this.partIds == null) {
                this.partIds = new ArrayList();
            }
            this.partIds.add(partId);
            return this;
        }

        @Generated
        public UploadCompleteRequestBuilder partIds(Collection<? extends String> partIds) {
            if (partIds == null) {
                throw new NullPointerException("partIds cannot be null");
            }
            if (this.partIds == null) {
                this.partIds = new ArrayList();
            }
            this.partIds.addAll(partIds);
            return this;
        }

        @Generated
        public UploadCompleteRequestBuilder clearPartIds() {
            if (this.partIds != null) {
                this.partIds.clear();
            }
            return this;
        }

        @Generated
        public UploadCompleteRequestBuilder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        @Generated
        public UploadCompleteRequest build() {
            List<String> partIds;
            switch (this.partIds == null ? 0 : this.partIds.size()) {
                case 0: {
                    partIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    partIds = Collections.singletonList(this.partIds.get(0));
                    break;
                }
                default: {
                    partIds = Collections.unmodifiableList(new ArrayList<String>(this.partIds));
                }
            }
            return new UploadCompleteRequest(partIds, this.md5);
        }

        @Generated
        public String toString() {
            return "UploadCompleteRequest.UploadCompleteRequestBuilder(partIds=" + String.valueOf(this.partIds) + ", md5=" + this.md5 + ")";
        }
    }
}

