/*
 * Decompiled with CFR 0.152.
 */
package scalapb_json;

import com.google.protobuf.ByteString;
import com.google.protobuf.field_mask.FieldMask;
import com.google.protobuf.field_mask.FieldMask$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PString;
import scalapb.descriptors.PValue;
import scalapb.descriptors.ScalaType;
import scalapb_json.JsonFormatException;
import scalapb_json.NameUtils$;

public final class ScalapbJsonCommon$ {
    public static final ScalapbJsonCommon$ MODULE$ = new ScalapbJsonCommon$();
    private static final int PIntDefault = 0;
    private static final long PLongDefault = 0L;
    private static final float PFloatDefault = 0.0f;
    private static final double PDoubleDefault = 0.0;
    private static final boolean PBooleanDefault = false;
    private static final String PStringDefault = "";
    private static final ByteString PByteStringDefault = ByteString.EMPTY;
    private static final BigInt MAX_UINT64 = package$.MODULE$.BigInt().apply("FFFFFFFFFFFFFFFF", 16);
    private static final double PDoubleNaN = Double.NaN;
    private static final double PDoublePosInf = Double.POSITIVE_INFINITY;
    private static final double PDoubleNegInf = Double.NEGATIVE_INFINITY;
    private static final float PFloatNaN = Float.NaN;
    private static final float PFloatPosInf = Float.POSITIVE_INFINITY;
    private static final float PFloatNegInf = Float.NEGATIVE_INFINITY;
    private static final double EPSILON = 1.0E-6;
    private static final java.math.BigDecimal MORE_THAN_ONE = new java.math.BigDecimal(String.valueOf(1.0 + MODULE$.EPSILON()));
    private static final java.math.BigDecimal MAX_DOUBLE = new java.math.BigDecimal(String.valueOf(Double.MAX_VALUE)).multiply(MODULE$.MORE_THAN_ONE());
    private static final java.math.BigDecimal MIN_DOUBLE = new java.math.BigDecimal(String.valueOf(-1.7976931348623157E308)).multiply(MODULE$.MORE_THAN_ONE());

    public long unsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public PValue defaultValue(FieldDescriptor fd) {
        Predef$.MODULE$.require(fd.isOptional());
        ScalaType scalaType = fd.scalaType();
        if (ScalaType.Int$.MODULE$.equals(scalaType)) {
            return new PInt(PIntDefault);
        }
        if (ScalaType.Long$.MODULE$.equals(scalaType)) {
            return new PLong(PLongDefault);
        }
        if (ScalaType.Float$.MODULE$.equals(scalaType)) {
            return new PFloat(PFloatDefault);
        }
        if (ScalaType.Double$.MODULE$.equals(scalaType)) {
            return new PDouble(PDoubleDefault);
        }
        if (ScalaType.Boolean$.MODULE$.equals(scalaType)) {
            return new PBoolean(PBooleanDefault);
        }
        if (ScalaType.String$.MODULE$.equals(scalaType)) {
            return new PString(PStringDefault);
        }
        if (ScalaType.ByteString$.MODULE$.equals(scalaType)) {
            return new PByteString(PByteStringDefault);
        }
        if (scalaType instanceof ScalaType.Enum) {
            ScalaType.Enum enum_ = (ScalaType.Enum)scalaType;
            EnumDescriptor ed = enum_.descriptor();
            return new PEnum((EnumValueDescriptor)ed.values().apply(0));
        }
        if (scalaType instanceof ScalaType.Message) {
            throw new RuntimeException("No default value for message");
        }
        throw new MatchError((Object)scalaType);
    }

    public BigDecimal parseBigDecimal(String value) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(value);
        }
        catch (Exception e) {
            throw new JsonFormatException(new StringBuilder(21).append("Not a numeric value: ").append(value).toString(), e);
        }
        return bigDecimal;
    }

    public PValue parseInt32(String value) {
        PInt pInt;
        try {
            pInt = new PInt(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value)));
        }
        catch (Exception exception) {
            try {
                pInt = new PInt(this.parseBigDecimal(value).toIntExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int32 value: ").append(value).toString(), e);
            }
        }
        return pInt;
    }

    public PValue parseInt64(String value) {
        PLong pLong;
        try {
            pLong = new PLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
        }
        catch (Exception exception) {
            BigDecimal bd = this.parseBigDecimal(value);
            try {
                pLong = new PLong(bd.toLongExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int64 value: ").append(value).toString(), e);
            }
        }
        return pLong;
    }

    public PValue parseUint32(String value) {
        try {
            long result = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value));
            if (result < 0L || result > 0xFFFFFFFFL) {
                throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value).toString());
            }
            return new PInt((int)result);
        }
        catch (JsonFormatException e) {
            throw e;
        }
        catch (Exception exception) {
            return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & Serializable)intVal -> new PLong(ScalapbJsonCommon$.$anonfun$parseUint32$1(value, intVal))).getOrElse((Function0 & Serializable)() -> {
                throw new JsonFormatException(new StringBuilder(21).append("Not an uint32 value: ").append(value).toString());
            });
        }
    }

    public BigInt MAX_UINT64() {
        return MAX_UINT64;
    }

    public PValue parseUint64(String value) {
        return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & Serializable)intVal -> new PLong(ScalapbJsonCommon$.$anonfun$parseUint64$1(value, intVal))).getOrElse((Function0 & Serializable)() -> {
            throw new JsonFormatException(new StringBuilder(21).append("Not an uint64 value: ").append(value).toString());
        });
    }

    public double parseDouble(String value) {
        double d;
        String string = value;
        switch (string == null ? 0 : string.hashCode()) {
            case 78043: {
                if (!"NaN".equals(string)) break;
                return PDoubleNaN;
            }
            case 237817416: {
                if (!"Infinity".equals(string)) break;
                return PDoublePosInf;
            }
            case 506745205: {
                if (!"-Infinity".equals(string)) break;
                return PDoubleNegInf;
            }
        }
        try {
            java.math.BigDecimal bd = new java.math.BigDecimal(string);
            if (bd.compareTo(this.MAX_DOUBLE()) > 0 || bd.compareTo(this.MIN_DOUBLE()) < 0) {
                throw new JsonFormatException(new StringBuilder(27).append("Out of range double value: ").append(string).toString());
            }
            d = bd.doubleValue();
        }
        catch (JsonFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonFormatException(new StringBuilder(20).append("Not a double value: ").append(string).toString(), e);
        }
        return d;
    }

    public float parseFloat(String value) {
        float f;
        String string = value;
        switch (string == null ? 0 : string.hashCode()) {
            case 78043: {
                if (!"NaN".equals(string)) break;
                return PFloatNaN;
            }
            case 237817416: {
                if (!"Infinity".equals(string)) break;
                return PFloatPosInf;
            }
            case 506745205: {
                if (!"-Infinity".equals(string)) break;
                return PFloatNegInf;
            }
        }
        try {
            double value2 = Double.parseDouble(string);
            if (value2 > 3.4028234663852886E38 * (1.0 + this.EPSILON()) || value2 < -3.4028234663852886E38 * (1.0 + this.EPSILON())) {
                throw new JsonFormatException(new StringBuilder(26).append("Out of range float value: ").append(value2).toString());
            }
            f = (float)value2;
        }
        catch (JsonFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonFormatException(new StringBuilder(19).append("Not a float value: ").append(string).toString(), e);
        }
        return f;
    }

    public String jsonName(FieldDescriptor fd) {
        return (String)fd.asProto().jsonName().getOrElse((Function0 & Serializable)() -> NameUtils$.MODULE$.snakeCaseToCamelCase(fd.asProto().getName(), NameUtils$.MODULE$.snakeCaseToCamelCase$default$2()));
    }

    public String fieldMaskToJsonString(FieldMask fieldMask) {
        StringBuilder buf = new StringBuilder();
        BooleanRef first = BooleanRef.create((boolean)true);
        fieldMask.paths().foreach((Function1 & Serializable)path -> {
            ScalapbJsonCommon$.$anonfun$fieldMaskToJsonString$1(first, buf, path);
            return BoxedUnit.UNIT;
        });
        return buf.toString();
    }

    public FieldMask fieldMaskFromJsonString(String value) {
        List result = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])value.split(","))).withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).map((Function1 & Serializable)path -> NameUtils$.MODULE$.camelCaseToSnakeCase((String)path)).toList();
        return new FieldMask((Seq)result, FieldMask$.MODULE$.apply$default$2());
    }

    public double EPSILON() {
        return EPSILON;
    }

    public java.math.BigDecimal MORE_THAN_ONE() {
        return MORE_THAN_ONE;
    }

    public java.math.BigDecimal MAX_DOUBLE() {
        return MAX_DOUBLE;
    }

    public java.math.BigDecimal MIN_DOUBLE() {
        return MIN_DOUBLE;
    }

    public static final /* synthetic */ long $anonfun$parseUint32$1(String value$1, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL))) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value$1).toString());
        }
        return intVal.intValue();
    }

    public static final /* synthetic */ long $anonfun$parseUint64$1(String value$2, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)MODULE$.MAX_UINT64())) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint64 value: ").append(value$2).toString());
        }
        return intVal.longValue();
    }

    public static final /* synthetic */ void $anonfun$fieldMaskToJsonString$1(BooleanRef first$1, StringBuilder buf$1, String path) {
        if (!path.isEmpty()) {
            Object object = !first$1.elem ? buf$1.append(',') : BoxedUnit.UNIT;
            NameUtils$.MODULE$.lowerSnakeCaseToCamelCaseWithBuffer(path, buf$1);
            first$1.elem = false;
            return;
        }
    }

    private ScalapbJsonCommon$() {
    }
}

