/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.IGeometryFilter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.IUserDataConverter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.RoundingFilter;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerParams;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerProps;
import io.github.sebasbaumh.mapbox.vectortile.util.GeomCmd;
import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import io.github.sebasbaumh.mapbox.vectortile.util.Vec2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class JtsAdapter {
    @Deprecated
    private JtsAdapter() {
    }

    public static void addFeatures(VectorTile.Tile.Layer.Builder layerBuilder, Geometry geometry, MvtLayerProps layerProps, @Nullable IUserDataConverter userDataConverter) {
        if (!(geometry instanceof GeometryCollection)) {
            VectorTile.Tile.Feature nextFeature = JtsAdapter.toFeature(geometry, layerProps, userDataConverter);
            if (nextFeature != null) {
                layerBuilder.addFeatures(nextFeature);
            }
        } else {
            Collection<Geometry> geometries = JtsAdapter.collectFlatGeometries(geometry);
            JtsAdapter.addFeatures(layerBuilder, geometries, layerProps, userDataConverter);
        }
    }

    public static void addFeatures(VectorTile.Tile.Layer.Builder layerBuilder, Iterable<Geometry> geometries, MvtLayerProps layerProps, @Nullable IUserDataConverter userDataConverter) {
        for (Geometry geom : geometries) {
            VectorTile.Tile.Feature nextFeature = JtsAdapter.toFeature(geom, layerProps, userDataConverter);
            if (nextFeature == null) continue;
            layerBuilder.addFeatures(nextFeature);
        }
    }

    private static Collection<Geometry> collectFlatGeometries(Geometry geom) {
        if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon) {
            return Collections.singleton(geom);
        }
        ArrayList<Geometry> singleGeoms = new ArrayList<Geometry>();
        JtsAdapter.collectFlatGeometries(geom, singleGeoms);
        return singleGeoms;
    }

    private static void collectFlatGeometries(Geometry geom, Collection<Geometry> singleGeoms) {
        if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof LineString || geom instanceof MultiLineString || geom instanceof Polygon || geom instanceof MultiPolygon) {
            singleGeoms.add(geom);
        } else if (geom instanceof GeometryCollection) {
            int nextGeomCount = geom.getNumGeometries();
            for (int i = 0; i < nextGeomCount; ++i) {
                JtsAdapter.collectFlatGeometries(geom.getGeometryN(i), singleGeoms);
            }
        }
    }

    private static int countCoordRepeatReverse(Coordinate[] coords) {
        Coordinate nextCoord;
        int repeatCoords = 0;
        Coordinate firstCoord = coords[0];
        for (int i = coords.length - 1; i > 0 && JtsAdapter.equalAsInts2d(firstCoord, nextCoord = coords[i]); --i) {
            ++repeatCoords;
        }
        return repeatCoords;
    }

    public static Geometry createTileGeom(Geometry geom, Envelope tileEnvelope, Envelope clipEnvelope, GeometryFactory geomFactory, MvtLayerParams mvtLayerParams, @Nullable IGeometryFilter filter) {
        double xDiff = tileEnvelope.getWidth();
        double yDiff = tileEnvelope.getHeight();
        double xOffset = -tileEnvelope.getMinX();
        double yOffset = -tileEnvelope.getMinY();
        AffineTransformation t = new AffineTransformation();
        t.translate(xOffset, yOffset);
        t.scale(1.0 / (xDiff / (double)mvtLayerParams.getExtent()), -1.0 / (yDiff / (double)mvtLayerParams.getExtent()));
        t.translate(0.0, (double)mvtLayerParams.getExtent());
        Geometry clipEnvelopeGeometry = geomFactory.toGeometry(clipEnvelope);
        Collection<Geometry> flatGeometries = JtsAdapter.collectFlatGeometries(geom);
        ArrayList<Geometry> intersectedGeoms = new ArrayList<Geometry>(flatGeometries.size());
        for (Geometry flatGeom : flatGeometries) {
            Geometry nextIntersected;
            if (!clipEnvelope.intersects(flatGeom.getEnvelopeInternal()) || (nextIntersected = clipEnvelopeGeometry.intersection(flatGeom)).isEmpty()) continue;
            nextIntersected.setUserData(flatGeom.getUserData());
            intersectedGeoms.add(nextIntersected);
        }
        ArrayList<Geometry> transformedGeoms = new ArrayList<Geometry>(intersectedGeoms.size());
        for (Geometry nextInterGeom : intersectedGeoms) {
            Object nextUserData = nextInterGeom.getUserData();
            Geometry nextTransformGeom = t.transform(nextInterGeom);
            nextTransformGeom.apply((CoordinateSequenceFilter)RoundingFilter.INSTANCE);
            nextTransformGeom = TopologyPreservingSimplifier.simplify((Geometry)nextTransformGeom, (double)0.1);
            if (filter != null && !filter.accept(nextTransformGeom)) continue;
            nextTransformGeom.setUserData(nextUserData);
            transformedGeoms.add(nextTransformGeom);
        }
        if (transformedGeoms.size() == 1) {
            return (Geometry)transformedGeoms.get(0);
        }
        return new GeometryCollection(transformedGeoms.toArray(new Geometry[transformedGeoms.size()]), geomFactory);
    }

    public static Geometry createTileGeom(Geometry geom, Envelope tileEnvelope, GeometryFactory geomFactory, MvtLayerParams mvtLayerParams, @Nullable IGeometryFilter filter) {
        return JtsAdapter.createTileGeom(geom, tileEnvelope, tileEnvelope, geomFactory, mvtLayerParams, filter);
    }

    private static boolean equalAsInts2d(Coordinate a, Coordinate b) {
        return (int)a.getOrdinate(0) == (int)b.getOrdinate(0) && (int)a.getOrdinate(1) == (int)b.getOrdinate(1);
    }

    private static int geomCmdBuffLenLines(int coordCount, boolean closeEnabled) {
        return 2 + (closeEnabled ? 1 : 0) + coordCount * 2;
    }

    private static int geomCmdBuffLenPts(int coordCount) {
        return 1 + coordCount * 2;
    }

    private static Collection<Integer> linesToGeomCmds(Geometry geom, boolean closeEnabled, Vec2d cursor, int minLineToLen) {
        int geomProcCoordCount;
        Coordinate[] geomCoords = geom.getCoordinates();
        if (closeEnabled) {
            int repeatEndCoordCount = JtsAdapter.countCoordRepeatReverse(geomCoords);
            geomProcCoordCount = geomCoords.length - repeatEndCoordCount;
        } else {
            geomProcCoordCount = geomCoords.length;
        }
        if (geomProcCoordCount < 2) {
            return Collections.emptyList();
        }
        Vec2d origCursorPos = new Vec2d(cursor);
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(JtsAdapter.geomCmdBuffLenLines(geomProcCoordCount, closeEnabled));
        Coordinate nextCoord = geomCoords[0];
        Vec2d mvtPos = new Vec2d((int)nextCoord.x, (int)nextCoord.y);
        geomCmds.add(MvtUtil.geomCmdHdr(GeomCmd.MOVE_TO, 1));
        JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        int lineToCmdHdrIndex = geomCmds.size();
        geomCmds.add(0);
        int lineToLength = 0;
        for (int i = 1; i < geomProcCoordCount; ++i) {
            nextCoord = geomCoords[i];
            mvtPos.setX((int)nextCoord.x);
            mvtPos.setY((int)nextCoord.y);
            if (cursor.equals(mvtPos)) continue;
            ++lineToLength;
            JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (lineToLength >= minLineToLen && lineToLength <= MvtUtil.GEOM_CMD_HDR_LEN_MAX) {
            geomCmds.set(lineToCmdHdrIndex, MvtUtil.geomCmdHdr(GeomCmd.LINE_TO, lineToLength));
            if (closeEnabled) {
                geomCmds.add(MvtUtil.CLOSE_PATH_HDR);
            }
            return geomCmds;
        }
        cursor.set(origCursorPos);
        return Collections.emptyList();
    }

    private static void moveCursor(Vec2d cursor, List<Integer> geomCmds, Vec2d mvtPos) {
        geomCmds.add(MvtUtil.encodeZigZag(mvtPos.getX() - cursor.getX()));
        geomCmds.add(MvtUtil.encodeZigZag(mvtPos.getY() - cursor.getY()));
        cursor.set(mvtPos);
    }

    private static List<Integer> ptsToGeomCmds(Geometry geom, Vec2d cursor) {
        Coordinate[] geomCoords = geom.getCoordinates();
        if (geomCoords.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(JtsAdapter.geomCmdBuffLenPts(geomCoords.length));
        int moveCmdLen = 0;
        geomCmds.add(0);
        for (int i = 0; i < geomCoords.length; ++i) {
            Coordinate nextCoord = geomCoords[i];
            Vec2d mvtPos = new Vec2d((int)nextCoord.x, (int)nextCoord.y);
            if (i != 0 && cursor.equals(mvtPos)) continue;
            ++moveCmdLen;
            JtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (moveCmdLen <= MvtUtil.GEOM_CMD_HDR_LEN_MAX) {
            geomCmds.set(0, MvtUtil.geomCmdHdr(GeomCmd.MOVE_TO, moveCmdLen));
            return geomCmds;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static VectorTile.Tile.Feature toFeature(Geometry geom, MvtLayerProps layerProps, @Nullable IUserDataConverter userDataConverter) {
        Object userData;
        int i;
        VectorTile.Tile.GeomType mvtGeomType = JtsAdapter.toGeomType(geom);
        if (mvtGeomType == VectorTile.Tile.GeomType.UNKNOWN) {
            return null;
        }
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        boolean mvtClosePath = mvtGeomType == VectorTile.Tile.GeomType.POLYGON;
        ArrayList<Integer> mvtGeom = new ArrayList<Integer>();
        Vec2d cursor = new Vec2d();
        featureBuilder.setType(mvtGeomType);
        if (geom instanceof Point || geom instanceof MultiPoint) {
            mvtGeom.addAll(JtsAdapter.ptsToGeomCmds(geom, cursor));
        } else if (geom instanceof LineString || geom instanceof MultiLineString) {
            for (i = 0; i < geom.getNumGeometries(); ++i) {
                mvtGeom.addAll(JtsAdapter.linesToGeomCmds(geom.getGeometryN(i), mvtClosePath, cursor, 1));
            }
        } else if (geom instanceof MultiPolygon || geom instanceof Polygon) {
            for (i = 0; i < geom.getNumGeometries(); ++i) {
                Polygon nextPoly = (Polygon)geom.getGeometryN(i);
                LinearRing exteriorRing = nextPoly.getExteriorRing();
                double exteriorArea = Area.ofRingSigned((Coordinate[])exteriorRing.getCoordinates());
                if ((int)Math.round(exteriorArea) == 0) continue;
                if (exteriorArea > 0.0) {
                    CoordinateArrays.reverse((Coordinate[])exteriorRing.getCoordinates());
                }
                ArrayList<Integer> nextPolyGeom = new ArrayList<Integer>();
                nextPolyGeom.addAll(JtsAdapter.linesToGeomCmds((Geometry)exteriorRing, mvtClosePath, cursor, 2));
                boolean valid = true;
                for (int ringIndex = 0; ringIndex < nextPoly.getNumInteriorRing(); ++ringIndex) {
                    LinearRing nextInteriorRing = nextPoly.getInteriorRingN(ringIndex);
                    double interiorArea = Area.ofRingSigned((Coordinate[])nextInteriorRing.getCoordinates());
                    if (Math.round(interiorArea) == 0L) continue;
                    if (interiorArea < 0.0) {
                        CoordinateArrays.reverse((Coordinate[])nextInteriorRing.getCoordinates());
                    }
                    if (Math.abs(exteriorArea) <= Math.abs(interiorArea)) {
                        valid = false;
                        break;
                    }
                    nextPolyGeom.addAll(JtsAdapter.linesToGeomCmds((Geometry)nextInteriorRing, mvtClosePath, cursor, 2));
                }
                if (!valid) continue;
                mvtGeom.addAll(nextPolyGeom);
            }
        }
        if (mvtGeom.isEmpty()) {
            return null;
        }
        featureBuilder.addAllGeometry(mvtGeom);
        if (userDataConverter != null && (userData = geom.getUserData()) != null) {
            userDataConverter.addTags(userData, layerProps, featureBuilder);
        }
        return featureBuilder.build();
    }

    public static VectorTile.Tile.GeomType toGeomType(Geometry geometry) {
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        return VectorTile.Tile.GeomType.UNKNOWN;
    }
}

