/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts;

import com.google.protobuf.ProtocolStringList;
import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.ITagConverter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model.JtsLayer;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model.JtsMvt;
import io.github.sebasbaumh.mapbox.vectortile.util.GeomCmd;
import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import io.github.sebasbaumh.mapbox.vectortile.util.Vec2d;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.LoggerFactory;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class MvtReader {
    private static final int MIN_LINE_STRING_LEN = 6;
    private static final int MIN_POLYGON_LEN = 9;
    public static final RingClassifier RING_CLASSIFIER_V1 = new PolyRingClassifierV1();
    public static final RingClassifier RING_CLASSIFIER_V2_1 = new PolyRingClassifierV2_1();
    private static final RingClassifier RING_CLASSIFIER_DEFAULT = RING_CLASSIFIER_V1;

    @Deprecated
    private MvtReader() {
    }

    public static JtsMvt loadMvt(File file, GeometryFactory geomFactory, @Nullable ITagConverter tagConverter) throws IOException {
        return MvtReader.loadMvt(file, geomFactory, tagConverter, RING_CLASSIFIER_DEFAULT);
    }

    public static JtsMvt loadMvt(File file, GeometryFactory geomFactory, @Nullable ITagConverter tagConverter, RingClassifier ringClassifier) throws IOException {
        JtsMvt jtsMvt;
        try (FileInputStream is = new FileInputStream(file);){
            jtsMvt = MvtReader.loadMvt(is, geomFactory, tagConverter, ringClassifier);
        }
        return jtsMvt;
    }

    public static JtsMvt loadMvt(InputStream is, GeometryFactory geomFactory, @Nullable ITagConverter tagConverter) throws IOException {
        return MvtReader.loadMvt(is, geomFactory, tagConverter, RING_CLASSIFIER_DEFAULT);
    }

    public static JtsMvt loadMvt(InputStream is, GeometryFactory geomFactory, @Nullable ITagConverter tagConverter, RingClassifier ringClassifier) throws IOException {
        VectorTile.Tile mvt = VectorTile.Tile.parseFrom(is);
        Vec2d cursor = new Vec2d();
        ArrayList<JtsLayer> jtsLayers = new ArrayList<JtsLayer>(mvt.getLayersList().size());
        for (VectorTile.Tile.Layer nextLayer : mvt.getLayersList()) {
            ProtocolStringList keysList = nextLayer.getKeysList();
            List<VectorTile.Tile.Value> valuesList = nextLayer.getValuesList();
            ArrayList<Geometry> layerGeoms = new ArrayList<Geometry>(nextLayer.getFeaturesList().size());
            for (VectorTile.Tile.Feature nextFeature : nextLayer.getFeaturesList()) {
                Long id = nextFeature.hasId() ? Long.valueOf(nextFeature.getId()) : null;
                VectorTile.Tile.GeomType geomType = nextFeature.getType();
                if (geomType == VectorTile.Tile.GeomType.UNKNOWN) continue;
                List<Integer> geomCmds = nextFeature.getGeometryList();
                cursor.set(0, 0);
                Geometry nextGeom = MvtReader.readGeometry(geomCmds, geomType, geomFactory, cursor, ringClassifier);
                if (nextGeom == null) continue;
                if (tagConverter != null) {
                    nextGeom.setUserData(tagConverter.toUserData(id, nextFeature.getTagsList(), (List<String>)keysList, valuesList));
                }
                layerGeoms.add(nextGeom);
            }
            jtsLayers.add(new JtsLayer(nextLayer.getName(), layerGeoms, nextLayer.getExtent()));
        }
        return new JtsMvt(jtsLayers);
    }

    @Nullable
    private static Geometry readGeometry(List<Integer> geomCmds, VectorTile.Tile.GeomType geomType, GeometryFactory geomFactory, Vec2d cursor, RingClassifier ringClassifier) {
        Geometry result = null;
        switch (geomType) {
            case POINT: {
                result = MvtReader.readPoints(geomFactory, geomCmds, cursor);
                break;
            }
            case LINESTRING: {
                result = MvtReader.readLines(geomFactory, geomCmds, cursor);
                break;
            }
            case POLYGON: {
                result = MvtReader.readPolys(geomFactory, geomCmds, cursor, ringClassifier);
                break;
            }
            default: {
                LoggerFactory.getLogger(MvtReader.class).error("readGeometry(): Unhandled geometry type [{}]", (Object)geomType);
            }
        }
        return result;
    }

    @Nullable
    private static Geometry readLines(GeometryFactory geomFactory, List<Integer> geomCmds, Vec2d cursor) {
        if (geomCmds.isEmpty()) {
            return null;
        }
        int i = 0;
        ArrayList<LineString> geoms = new ArrayList<LineString>(1);
        while (i <= geomCmds.size() - 6) {
            int cmdHdr = geomCmds.get(i++);
            int cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
            GeomCmd cmd = MvtUtil.getGeomCmd(cmdHdr);
            if (cmd != GeomCmd.MOVE_TO || cmdLength != 1) break;
            cursor.add(MvtUtil.decodeZigZag(geomCmds.get(i++)), MvtUtil.decodeZigZag(geomCmds.get(i++)));
            cmdHdr = geomCmds.get(i++);
            cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
            cmd = MvtUtil.getGeomCmd(cmdHdr);
            if (cmd != GeomCmd.LINE_TO || cmdLength < 1 || cmdLength * GeomCmd.LINE_TO.getParamCount() + i > geomCmds.size()) break;
            CoordinateSequence nextCoordSeq = geomFactory.getCoordinateSequenceFactory().create(1 + cmdLength, 2);
            nextCoordSeq.setOrdinate(0, 0, (double)cursor.getX());
            nextCoordSeq.setOrdinate(0, 1, (double)cursor.getY());
            for (int lineToIndex = 0; lineToIndex < cmdLength; ++lineToIndex) {
                cursor.add(MvtUtil.decodeZigZag(geomCmds.get(i++)), MvtUtil.decodeZigZag(geomCmds.get(i++)));
                nextCoordSeq.setOrdinate(lineToIndex + 1, 0, (double)cursor.getX());
                nextCoordSeq.setOrdinate(lineToIndex + 1, 1, (double)cursor.getY());
            }
            geoms.add(geomFactory.createLineString(nextCoordSeq));
        }
        return geoms.size() == 1 ? (Geometry)geoms.get(0) : geomFactory.createMultiLineString(geoms.toArray(new LineString[geoms.size()]));
    }

    @Nullable
    private static Geometry readPoints(GeometryFactory geomFactory, List<Integer> geomCmds, Vec2d cursor) {
        if (geomCmds.isEmpty()) {
            return null;
        }
        int i = 0;
        int cmdHdr = geomCmds.get(i++);
        int cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
        GeomCmd cmd = MvtUtil.getGeomCmd(cmdHdr);
        if (cmd != GeomCmd.MOVE_TO || cmdLength < 1) {
            return null;
        }
        int requiredgeomCmdsLength = cmdLength * GeomCmd.MOVE_TO.getParamCount() + 1;
        if (requiredgeomCmdsLength > geomCmds.size()) {
            return null;
        }
        if (requiredgeomCmdsLength < geomCmds.size()) {
            geomCmds = geomCmds.subList(0, requiredgeomCmdsLength);
        }
        CoordinateSequence coordSeq = geomFactory.getCoordinateSequenceFactory().create(cmdLength, 2);
        int coordIndex = 0;
        while (i < geomCmds.size() - 1) {
            cursor.add(MvtUtil.decodeZigZag(geomCmds.get(i++)), MvtUtil.decodeZigZag(geomCmds.get(i++)));
            coordSeq.setOrdinate(coordIndex, 0, (double)cursor.getX());
            coordSeq.setOrdinate(coordIndex, 1, (double)cursor.getY());
            ++coordIndex;
        }
        return coordSeq.size() == 1 ? geomFactory.createPoint(coordSeq) : geomFactory.createMultiPoint(coordSeq);
    }

    @Nullable
    private static Geometry readPolys(GeometryFactory geomFactory, List<Integer> geomCmds, Vec2d cursor, RingClassifier ringClassifier) {
        List<Polygon> polygons;
        if (geomCmds.isEmpty()) {
            return null;
        }
        int i = 0;
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>(1);
        while (i <= geomCmds.size() - 9) {
            int cmdHdr = geomCmds.get(i++);
            int cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
            GeomCmd cmd = MvtUtil.getGeomCmd(cmdHdr);
            if (cmd != GeomCmd.MOVE_TO || cmdLength != 1) break;
            cursor.add(MvtUtil.decodeZigZag(geomCmds.get(i++)), MvtUtil.decodeZigZag(geomCmds.get(i++)));
            cmdHdr = geomCmds.get(i++);
            cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
            cmd = MvtUtil.getGeomCmd(cmdHdr);
            if (cmd != GeomCmd.LINE_TO || cmdLength < 2 || cmdLength * GeomCmd.LINE_TO.getParamCount() + i + 1 > geomCmds.size()) break;
            CoordinateSequence nextCoordSeq = geomFactory.getCoordinateSequenceFactory().create(2 + cmdLength, 2);
            nextCoordSeq.setOrdinate(0, 0, (double)cursor.getX());
            nextCoordSeq.setOrdinate(0, 1, (double)cursor.getY());
            for (int lineToIndex = 0; lineToIndex < cmdLength; ++lineToIndex) {
                cursor.add(MvtUtil.decodeZigZag(geomCmds.get(i++)), MvtUtil.decodeZigZag(geomCmds.get(i++)));
                nextCoordSeq.setOrdinate(lineToIndex + 1, 0, (double)cursor.getX());
                nextCoordSeq.setOrdinate(lineToIndex + 1, 1, (double)cursor.getY());
            }
            cmdHdr = geomCmds.get(i++);
            cmdLength = MvtUtil.getGeomCmdLength(cmdHdr);
            cmd = MvtUtil.getGeomCmd(cmdHdr);
            if (cmd != GeomCmd.CLOSE_PATH || cmdLength != 1) break;
            nextCoordSeq.setOrdinate(nextCoordSeq.size() - 1, 0, nextCoordSeq.getOrdinate(0, 0));
            nextCoordSeq.setOrdinate(nextCoordSeq.size() - 1, 1, nextCoordSeq.getOrdinate(0, 1));
            rings.add(geomFactory.createLinearRing(nextCoordSeq));
        }
        if ((polygons = ringClassifier.classifyRings(rings, geomFactory)).isEmpty()) {
            return null;
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return geomFactory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    public static interface RingClassifier {
        public List<Polygon> classifyRings(List<LinearRing> var1, GeometryFactory var2);
    }

    private static final class PolyRingClassifierV1
    implements RingClassifier {
        private PolyRingClassifierV1() {
        }

        @Override
        public List<Polygon> classifyRings(List<LinearRing> rings, GeometryFactory geomFactory) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            double outerArea = 0.0;
            LinearRing outerPoly = null;
            for (LinearRing r : rings) {
                double area = Area.ofRingSigned((Coordinate[])r.getCoordinates());
                if (!r.isRing() || area == 0.0) continue;
                if (outerPoly == null || outerArea < 0.0 == area < 0.0) {
                    if (outerPoly != null) {
                        polygons.add(geomFactory.createPolygon(outerPoly, holes.toArray(new LinearRing[holes.size()])));
                        holes.clear();
                    }
                    outerPoly = r;
                    outerArea = area;
                    continue;
                }
                if (Math.abs(outerArea) < Math.abs(area)) continue;
                holes.add(r);
            }
            if (outerPoly != null) {
                polygons.add(geomFactory.createPolygon(outerPoly, holes.toArray(new LinearRing[holes.size()])));
            }
            return polygons;
        }
    }

    private static final class PolyRingClassifierV2_1
    implements RingClassifier {
        private PolyRingClassifierV2_1() {
        }

        @Override
        public List<Polygon> classifyRings(List<LinearRing> rings, GeometryFactory geomFactory) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            double outerArea = 0.0;
            LinearRing outerPoly = null;
            for (LinearRing r : rings) {
                double area = Area.ofRingSigned((Coordinate[])r.getCoordinates());
                if (!r.isRing() || area == 0.0) continue;
                if (area < 0.0) {
                    if (outerPoly != null) {
                        polygons.add(geomFactory.createPolygon(outerPoly, holes.toArray(new LinearRing[holes.size()])));
                        holes.clear();
                    }
                    outerPoly = r;
                    outerArea = area;
                    continue;
                }
                if (Math.abs(outerArea) < Math.abs(area)) continue;
                holes.add(r);
            }
            if (outerPoly != null) {
                polygons.add(geomFactory.createPolygon(outerPoly, holes.toArray(new LinearRing[holes.size()])));
            }
            return polygons;
        }
    }
}

