/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.ITagConverter;
import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class TagKeyValueMapConverter
implements ITagConverter {
    private final boolean addId;
    @Nullable
    private final String idKey;
    private final boolean nullIfEmpty;

    public TagKeyValueMapConverter() {
        this(false);
    }

    public TagKeyValueMapConverter(boolean nullIfEmpty) {
        this.nullIfEmpty = nullIfEmpty;
        this.addId = false;
        this.idKey = null;
    }

    public TagKeyValueMapConverter(boolean nullIfEmpty, String idKey) {
        Objects.requireNonNull(idKey);
        this.nullIfEmpty = nullIfEmpty;
        this.addId = true;
        this.idKey = idKey;
    }

    @Override
    @Nullable
    public Object toUserData(@Nullable Long id, List<Integer> tags, List<String> keysList, List<VectorTile.Tile.Value> valuesList) {
        if (this.nullIfEmpty && tags.isEmpty() && (!this.addId || id == null)) {
            return null;
        }
        LinkedHashMap<String, Object> userData = new LinkedHashMap<String, Object>((tags.size() + 1) / 2);
        for (int i = 0; i < tags.size() - 1; i += 2) {
            boolean valid;
            int keyIndex = tags.get(i);
            int valIndex = tags.get(i + 1);
            boolean bl = valid = keyIndex >= 0 && keyIndex < keysList.size() && valIndex >= 0 && valIndex < valuesList.size();
            if (!valid) continue;
            userData.put(keysList.get(keyIndex), MvtUtil.toObject(valuesList.get(valIndex)));
        }
        if (this.addId) {
            userData.put(this.idKey, id);
        }
        return userData;
    }
}

