/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model;

import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.locationtech.jts.geom.Geometry;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class JtsLayer {
    private final int extent;
    private final Collection<Geometry> geometries;
    private final String name;

    public JtsLayer(String name) {
        this(name, new ArrayList<Geometry>(0), 4096);
    }

    public JtsLayer(String name, Collection<Geometry> geometries) {
        this(name, geometries, 4096);
    }

    public JtsLayer(String name, Collection<Geometry> geometries, int extent) {
        if (extent <= 0) {
            throw new IllegalArgumentException("extent is less than or equal to 0");
        }
        this.name = name;
        this.geometries = geometries;
        this.extent = extent;
    }

    public JtsLayer(String name, Geometry geom) {
        this(name, Collections.singleton(geom), 4096);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsLayer layer = (JtsLayer)o;
        return this.extent == layer.getExtent() && this.name.equals(layer.name) && MvtUtil.equalsIterable(this.geometries, layer.geometries);
    }

    public int getExtent() {
        return this.extent;
    }

    public Collection<Geometry> getGeometries() {
        return this.geometries;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.extent;
        result = 31 * result + (this.geometries != null ? this.geometries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Layer{name='" + this.name + "', geometries=" + this.geometries + ", extent=" + this.extent + "}";
    }
}

