/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model;

import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model.JtsLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class JtsMvt {
    private final Map<String, JtsLayer> layersByName;

    public JtsMvt() {
        this(Collections.emptyList());
    }

    public JtsMvt(Collection<JtsLayer> layers) {
        this.layersByName = new LinkedHashMap<String, JtsLayer>(layers.size());
        for (JtsLayer nextLayer : layers) {
            this.layersByName.put(nextLayer.getName(), nextLayer);
        }
    }

    public JtsMvt(JtsLayer layer) {
        this(Collections.singletonList(layer));
    }

    public JtsMvt(JtsLayer ... layers) {
        this(new ArrayList<JtsLayer>(Arrays.asList(layers)));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsMvt jtsMvt = (JtsMvt)o;
        return this.layersByName.equals(jtsMvt.layersByName);
    }

    public JtsLayer getLayer(String name) {
        return this.layersByName.get(name);
    }

    public Collection<JtsLayer> getLayers() {
        return this.layersByName.values();
    }

    public Map<String, JtsLayer> getLayersByName() {
        return this.layersByName;
    }

    public int hashCode() {
        return this.layersByName.hashCode();
    }

    public String toString() {
        return "JtsMvt{layersByName=" + this.layersByName + "}";
    }
}

