/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.util;

import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public enum GeomCmd {
    CLOSE_PATH(7, 0),
    LINE_TO(2, 2),
    MOVE_TO(1, 2);

    private final int cmdId;
    private final int paramCount;

    private GeomCmd(int cmdId, int paramCount) {
        this.cmdId = cmdId;
        this.paramCount = paramCount;
    }

    @Nullable
    public static GeomCmd fromId(int cmdId) {
        switch (cmdId) {
            case 1: {
                return MOVE_TO;
            }
            case 2: {
                return LINE_TO;
            }
            case 7: {
                return CLOSE_PATH;
            }
        }
        return null;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public int getParamCount() {
        return this.paramCount;
    }
}

