/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.util;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerParams;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerProps;
import io.github.sebasbaumh.mapbox.vectortile.util.GeomCmd;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class MvtUtil {
    public static final int CLOSE_PATH_HDR = MvtUtil.geomCmdHdr(GeomCmd.CLOSE_PATH, 1);
    public static final int GEOM_CMD_HDR_LEN_MAX = (int)(Math.pow(2.0, 29.0) - 1.0);

    @Deprecated
    private MvtUtil() {
    }

    public static int decodeZigZag(int n) {
        return n >> 1 ^ -(n & 1);
    }

    public static int encodeZigZag(int n) {
        return n << 1 ^ n >> 31;
    }

    public static <T, U> boolean equalsIterable(@Nullable Iterable<T> la, @Nullable Iterable<U> lb) {
        if (la == lb) {
            return true;
        }
        if (la == null || lb == null) {
            return false;
        }
        Iterator<T> it = la.iterator();
        Iterator<U> it2 = lb.iterator();
        while (it.hasNext() && it2.hasNext()) {
            if (Objects.equals(it.next(), it2.next())) continue;
            return false;
        }
        return !it.hasNext() && !it2.hasNext();
    }

    public static int geomCmdHdr(GeomCmd cmd, int length) {
        return cmd.getCmdId() & 7 | length << 3;
    }

    @Nullable
    public static GeomCmd getGeomCmd(int cmdHdr) {
        int cmdId = MvtUtil.getGeomCmdId(cmdHdr);
        return GeomCmd.fromId(cmdId);
    }

    public static int getGeomCmdId(int cmdHdr) {
        return cmdHdr & 7;
    }

    public static int getGeomCmdLength(int cmdHdr) {
        return cmdHdr >> 3;
    }

    public static boolean isValidPropValue(Object value) {
        return value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String;
    }

    public static VectorTile.Tile.Layer.Builder newLayerBuilder(String layerName, MvtLayerParams mvtLayerParams) {
        VectorTile.Tile.Layer.Builder layerBuilder = VectorTile.Tile.Layer.newBuilder();
        layerBuilder.setVersion(2);
        layerBuilder.setName(layerName);
        layerBuilder.setExtent(mvtLayerParams.getExtent());
        return layerBuilder;
    }

    public static VectorTile.Tile.Value toMvtValue(Object value) {
        VectorTile.Tile.Value.Builder tileValue = VectorTile.Tile.Value.newBuilder();
        if (value instanceof Boolean) {
            tileValue.setBoolValue((Boolean)value);
        } else if (value instanceof Integer) {
            tileValue.setSintValue(((Integer)value).intValue());
        } else if (value instanceof Long) {
            tileValue.setSintValue((Long)value);
        } else if (value instanceof Float) {
            tileValue.setFloatValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            tileValue.setDoubleValue((Double)value);
        } else if (value instanceof String) {
            tileValue.setStringValue((String)value);
        }
        return tileValue.build();
    }

    @Nullable
    public static Object toObject(VectorTile.Tile.Value value) {
        if (value.hasDoubleValue()) {
            return value.getDoubleValue();
        }
        if (value.hasFloatValue()) {
            return Float.valueOf(value.getFloatValue());
        }
        if (value.hasIntValue()) {
            return value.getIntValue();
        }
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasSintValue()) {
            return value.getSintValue();
        }
        if (value.hasUintValue()) {
            return value.getUintValue();
        }
        return null;
    }

    public static void writeProps(VectorTile.Tile.Layer.Builder layerBuilder, MvtLayerProps layerProps) {
        layerBuilder.addAllKeys(layerProps.getKeys());
        for (Object val : layerProps.getValues()) {
            layerBuilder.addValues(MvtUtil.toMvtValue(val));
        }
    }
}

