/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.C;
import com.sun.glass.ui.monocle.EPDSettings;
import com.sun.glass.ui.monocle.EPDSystem;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;

class EPDFrameBuffer {
    private static final int BITS_TO_BYTES = 3;
    private static final int POWERDOWN_DELAY = 1000;
    private static final int ENOTTY = 25;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final EPDSettings settings = EPDSettings.newInstance();
    private final LinuxSystem system = LinuxSystem.getLinuxSystem();
    private final EPDSystem driver = EPDSystem.getEPDSystem();
    private final long fd;
    private final int xres;
    private final int yres;
    private final int xresVirtual;
    private final int yresVirtual;
    private final int xoffset;
    private final int yoffset;
    private final int bitsPerPixel;
    private final int bytesPerPixel;
    private final int byteOffset;
    private final EPDSystem.MxcfbUpdateData updateData;
    private final EPDSystem.MxcfbUpdateData syncUpdate;
    private int updateMarker;
    private int lastMarker;

    EPDFrameBuffer(String fbPath) throws IOException {
        this.fd = this.system.open(fbPath, 2);
        if (this.fd == -1L) {
            throw new IOException(this.system.getErrorMessage());
        }
        EPDSystem.FbVarScreenInfo screen = new EPDSystem.FbVarScreenInfo();
        this.getScreenInfo(screen);
        screen.setBitsPerPixel(screen.p, this.settings.bitsPerPixel);
        screen.setGrayscale(screen.p, this.settings.grayscale);
        switch (this.settings.bitsPerPixel) {
            case 8: {
                screen.setRed(screen.p, 0, 0);
                screen.setGreen(screen.p, 0, 0);
                screen.setBlue(screen.p, 0, 0);
                screen.setTransp(screen.p, 0, 0);
                break;
            }
            case 16: {
                screen.setRed(screen.p, 5, 11);
                screen.setGreen(screen.p, 6, 5);
                screen.setBlue(screen.p, 5, 0);
                screen.setTransp(screen.p, 0, 0);
                break;
            }
            case 32: {
                screen.setRed(screen.p, 8, 16);
                screen.setGreen(screen.p, 8, 8);
                screen.setBlue(screen.p, 8, 0);
                screen.setTransp(screen.p, 8, 24);
                break;
            }
            default: {
                String msg = MessageFormat.format("Unsupported color depth: {0} bpp", this.settings.bitsPerPixel);
                this.logger.severe(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        screen.setActivate(screen.p, 128);
        screen.setRotate(screen.p, this.settings.rotate);
        this.setScreenInfo(screen);
        this.getScreenInfo(screen);
        this.logScreenInfo(screen);
        this.xres = screen.getXRes(screen.p);
        this.yres = screen.getYRes(screen.p);
        this.xresVirtual = screen.getXResVirtual(screen.p);
        this.yresVirtual = screen.getYResVirtual(screen.p);
        this.xoffset = screen.getOffsetX(screen.p);
        this.yoffset = screen.getOffsetY(screen.p);
        this.bitsPerPixel = screen.getBitsPerPixel(screen.p);
        this.bytesPerPixel = this.bitsPerPixel >>> 3;
        this.byteOffset = (this.xoffset + this.yoffset * this.xresVirtual) * this.bytesPerPixel;
        this.updateData = new EPDSystem.MxcfbUpdateData();
        this.syncUpdate = this.createDefaultUpdate(this.xres, this.yres);
    }

    private void getScreenInfo(EPDSystem.FbVarScreenInfo screen) throws IOException {
        int rc = this.system.ioctl(this.fd, 17920, screen.p);
        if (rc != 0) {
            this.system.close(this.fd);
            throw new IOException(this.system.getErrorMessage());
        }
    }

    private void setScreenInfo(EPDSystem.FbVarScreenInfo screen) throws IOException {
        int rc = this.system.ioctl(this.fd, 17921, screen.p);
        if (rc != 0) {
            this.system.close(this.fd);
            throw new IOException(this.system.getErrorMessage());
        }
    }

    private void logScreenInfo(EPDSystem.FbVarScreenInfo screen) {
        if (this.logger.isLoggable(PlatformLogger.Level.FINE)) {
            this.logger.fine("Frame buffer geometry: {0} {1} {2} {3} {4}", new Object[]{screen.getXRes(screen.p), screen.getYRes(screen.p), screen.getXResVirtual(screen.p), screen.getYResVirtual(screen.p), screen.getBitsPerPixel(screen.p)});
            this.logger.fine("Frame buffer rgba: {0}/{1},{2}/{3},{4}/{5},{6}/{7}", new Object[]{screen.getRedLength(screen.p), screen.getRedOffset(screen.p), screen.getGreenLength(screen.p), screen.getGreenOffset(screen.p), screen.getBlueLength(screen.p), screen.getBlueOffset(screen.p), screen.getTranspLength(screen.p), screen.getTranspOffset(screen.p)});
            this.logger.fine("Frame buffer grayscale: {0}", new Object[]{screen.getGrayscale(screen.p)});
        }
    }

    private EPDSystem.MxcfbUpdateData createDefaultUpdate(int width, int height) {
        EPDSystem.MxcfbUpdateData update = new EPDSystem.MxcfbUpdateData();
        update.setUpdateRegion(update.p, 0, 0, width, height);
        update.setWaveformMode(update.p, this.settings.waveformMode);
        update.setUpdateMode(update.p, 0);
        update.setTemp(update.p, 4096);
        update.setFlags(update.p, this.settings.flags);
        return update;
    }

    private void setWaveformModes(int init, int du, int gc4, int gc8, int gc16, int gc32) {
        EPDSystem.MxcfbWaveformModes modes = new EPDSystem.MxcfbWaveformModes();
        modes.setModes(modes.p, init, du, gc4, gc8, gc16, gc32);
        int rc = this.system.ioctl(this.fd, this.driver.MXCFB_SET_WAVEFORM_MODES, modes.p);
        if (rc != 0 && this.system.errno() != 25) {
            this.logger.severe("Failed setting waveform modes: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno()});
        }
    }

    private void setTemperature(int temp) {
        int rc = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_TEMPERATURE, temp);
        if (rc != 0) {
            this.logger.severe("Failed setting temperature to {2} degrees Celsius: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), temp});
        }
    }

    private void setAutoUpdateMode(int mode) {
        int rc = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_AUTO_UPDATE_MODE, mode);
        if (rc != 0) {
            this.logger.severe("Failed setting auto-update mode to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), mode});
        }
    }

    private int sendUpdate(int updateMode, int waveformMode, int flags) {
        this.updateData.setUpdateRegion(this.updateData.p, 0, 0, this.xres, this.yres);
        this.updateData.setUpdateMode(this.updateData.p, updateMode);
        this.updateData.setTemp(this.updateData.p, 4096);
        this.updateData.setFlags(this.updateData.p, flags);
        return this.sendUpdate(this.updateData, waveformMode);
    }

    private int sendUpdate(EPDSystem.MxcfbUpdateData update, int waveformMode) {
        ++this.updateMarker;
        if (this.updateMarker == 0) {
            ++this.updateMarker;
        }
        update.setWaveformMode(update.p, waveformMode);
        update.setUpdateMarker(update.p, this.updateMarker);
        int rc = this.system.ioctl(this.fd, this.driver.MXCFB_SEND_UPDATE, update.p);
        if (rc != 0) {
            this.logger.severe("Failed sending update {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), Integer.toUnsignedLong(this.updateMarker)});
        } else if (this.logger.isLoggable(PlatformLogger.Level.FINER)) {
            this.logger.finer("Sent update: {0} x {1}, waveform {2}, selected {3}, flags 0x{4}, marker {5}", new Object[]{update.getUpdateRegionWidth(update.p), update.getUpdateRegionHeight(update.p), waveformMode, update.getWaveformMode(update.p), Integer.toHexString(update.getFlags(update.p)).toUpperCase(), Integer.toUnsignedLong(this.updateMarker)});
        }
        return this.updateMarker;
    }

    private void waitForUpdateComplete(int marker) {
        int rc = this.driver.ioctl(this.fd, this.driver.MXCFB_WAIT_FOR_UPDATE_COMPLETE, marker);
        if (rc < 0) {
            this.logger.severe("Failed waiting for update {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), Integer.toUnsignedLong(marker)});
        } else if (rc == 0 && this.logger.isLoggable(PlatformLogger.Level.FINER)) {
            this.logger.finer("Update completed before wait: marker {0}", new Object[]{Integer.toUnsignedLong(marker)});
        }
    }

    private void setPowerdownDelay(int delay) {
        int rc = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_PWRDOWN_DELAY, delay);
        if (rc != 0) {
            this.logger.severe("Failed setting power-down delay to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), delay});
        }
    }

    private int getPowerdownDelay() {
        EPDSystem.IntStructure integer = new EPDSystem.IntStructure();
        int rc = this.system.ioctl(this.fd, this.driver.MXCFB_GET_PWRDOWN_DELAY, integer.p);
        if (rc != 0) {
            this.logger.severe("Failed getting power-down delay: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno()});
        }
        return integer.get(integer.p);
    }

    private void setUpdateScheme(int scheme) {
        int rc = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_UPDATE_SCHEME, scheme);
        if (rc != 0) {
            this.logger.severe("Failed setting update scheme to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), scheme});
        }
    }

    void init() {
        this.setWaveformModes(0, 1, 3, 2, 2, 2);
        this.setTemperature(4096);
        this.setAutoUpdateMode(0);
        this.setPowerdownDelay(1000);
        this.setUpdateScheme(0);
    }

    void clear() {
        this.lastMarker = this.sendUpdate(1, 1, 0);
        this.lastMarker = this.sendUpdate(1, 1, 1);
        this.waitForUpdateComplete(this.lastMarker);
    }

    void sync() {
        if (!this.settings.noWait) {
            this.waitForUpdateComplete(this.lastMarker);
        }
        this.lastMarker = this.sendUpdate(this.syncUpdate, this.settings.waveformMode);
    }

    int getByteOffset() {
        return this.byteOffset;
    }

    ByteBuffer getOffscreenBuffer() {
        int size = this.xresVirtual * this.yres * 4;
        return ByteBuffer.allocateDirect(size);
    }

    ByteBuffer getMappedBuffer() {
        ByteBuffer buffer = null;
        int size = this.xresVirtual * this.yres * this.bytesPerPixel;
        this.logger.fine("Mapping frame buffer: {0} bytes", new Object[]{size});
        long addr = this.system.mmap(0L, size, 2L, 1L, this.fd, 0L);
        if (addr == 0xFFFFFFFFL) {
            this.logger.severe("Failed mapping {2} bytes of frame buffer: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), size});
        } else {
            buffer = C.getC().NewDirectByteBuffer(addr, size);
        }
        return buffer;
    }

    void releaseMappedBuffer(ByteBuffer buffer) {
        int size = buffer.capacity();
        this.logger.fine("Unmapping frame buffer: {0} bytes", new Object[]{size});
        int rc = this.system.munmap(C.getC().GetDirectBufferAddress(buffer), size);
        if (rc != 0) {
            this.logger.severe("Failed unmapping {2} bytes of frame buffer: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), size});
        }
    }

    void close() {
        this.system.close(this.fd);
    }

    long getNativeHandle() {
        return this.fd;
    }

    int getWidth() {
        return this.settings.getWidthVisible ? this.xres : this.xresVirtual;
    }

    int getHeight() {
        return this.yres;
    }

    int getBitDepth() {
        return this.bitsPerPixel;
    }

    public String toString() {
        return MessageFormat.format("{0}[width={1} height={2} bitDepth={3}]", this.getClass().getName(), this.getWidth(), this.getHeight(), this.getBitDepth());
    }
}

