/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;

class KeyState {
    private IntSet keysPressed = new IntSet();
    private MonocleWindow window;
    private int modifiers;

    KeyState() {
    }

    void clear() {
        this.keysPressed.clear();
        this.modifiers = 0;
    }

    void pressKey(int virtualKeyCode) {
        this.keysPressed.addInt(virtualKeyCode);
        this.modifiers |= KeyState.getModifier(virtualKeyCode);
    }

    void releaseKey(int virtualKeyCode) {
        this.keysPressed.removeInt(virtualKeyCode);
        this.modifiers &= ~KeyState.getModifier(virtualKeyCode);
    }

    void copyTo(KeyState target) {
        this.keysPressed.copyTo(target.keysPressed);
        target.window = this.window;
        target.modifiers = this.modifiers;
    }

    IntSet getKeysPressed() {
        return this.keysPressed;
    }

    MonocleWindow getWindow(boolean recalculateCache) {
        if (this.window == null || recalculateCache) {
            this.window = MonocleWindowManager.getInstance().getFocusedWindow();
        }
        return this.window;
    }

    private static int getModifier(int virtualKeyCode) {
        switch (virtualKeyCode) {
            case 16: {
                return 1;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 768: {
                return 16;
            }
            case 524: {
                return 16;
            }
        }
        return 0;
    }

    int getModifiers() {
        return this.modifiers;
    }

    boolean isShiftPressed() {
        return (this.modifiers & 1) != 0;
    }

    boolean isControlPressed() {
        return (this.modifiers & 4) != 0;
    }

    public String toString() {
        return "KeyState[modifiers=" + this.modifiers + ",keys=" + String.valueOf(this.keysPressed) + "]";
    }
}

