/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;

public abstract class NativePlatform {
    private static InputDeviceRegistry inputDeviceRegistry;
    private final RunnableProcessor runnableProcessor;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private NativeCursor cursor;
    protected List<NativeScreen> screens;
    protected AcceleratedScreen accScreen;
    protected static final boolean useCursor;

    protected NativePlatform() {
        this.runnableProcessor = new RunnableProcessor();
    }

    void shutdown() {
        this.runnableProcessor.shutdown();
        if (this.cursor != null) {
            this.cursor.shutdown();
        }
        if (this.screens != null) {
            for (NativeScreen screen : this.screens) {
                screen.shutdown();
            }
        }
    }

    RunnableProcessor getRunnableProcessor() {
        return this.runnableProcessor;
    }

    synchronized InputDeviceRegistry getInputDeviceRegistry() {
        if (inputDeviceRegistry == null) {
            inputDeviceRegistry = this.createInputDeviceRegistry();
        }
        return inputDeviceRegistry;
    }

    protected abstract InputDeviceRegistry createInputDeviceRegistry();

    protected abstract NativeCursor createCursor();

    synchronized NativeCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.createCursor();
        }
        return this.cursor;
    }

    protected abstract NativeScreen createScreen();

    protected synchronized List<NativeScreen> createScreens() {
        if (this.screens == null) {
            this.screens = new ArrayList<NativeScreen>(1);
            this.screens.add(this.createScreen());
        }
        return this.screens;
    }

    synchronized NativeScreen getScreen() {
        if (this.screens == null) {
            this.screens = this.createScreens();
        }
        return this.screens.size() == 0 ? null : this.screens.get(0);
    }

    synchronized List<NativeScreen> getScreens() {
        if (this.screens == null) {
            this.screens = this.createScreens();
        }
        return this.screens;
    }

    public synchronized AcceleratedScreen getAcceleratedScreen(int[] attributes) throws GLException, UnsatisfiedLinkError {
        if (this.accScreen == null) {
            this.accScreen = new AcceleratedScreen(attributes);
        }
        return this.accScreen;
    }

    protected NativeCursor logSelectedCursor(NativeCursor cursor) {
        if (this.logger.isLoggable(PlatformLogger.Level.FINE)) {
            String name = cursor == null ? null : cursor.getClass().getSimpleName();
            this.logger.fine("Using native cursor: {0}", new Object[]{name});
        }
        return cursor;
    }

    static {
        useCursor = AccessController.doPrivileged(() -> {
            String str = System.getProperty("monocle.cursor.enabled", "true");
            return "true".equalsIgnoreCase(str);
        });
    }
}

