/*
 * Decompiled with CFR 0.152.
 */
package io.github.secretx33.resourceresolver;

import io.github.secretx33.resourceresolver.AbstractResource;
import io.github.secretx33.resourceresolver.Resource;
import io.github.secretx33.resourceresolver.ResourceUtils;
import io.github.secretx33.resourceresolver.VfsResource;
import io.github.secretx33.resourceresolver.VfsUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.jar.JarEntry;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    @Override
    public boolean exists() {
        try {
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            this.customizeConnection(con);
            HttpURLConnection httpCon = null;
            if (con instanceof HttpURLConnection) {
                httpCon = (HttpURLConnection)con;
            }
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (con.getContentLengthLong() > 0L) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            return this.checkReadable(this.getURL());
        }
        catch (IOException ex) {
            return false;
        }
    }

    boolean checkReadable(URL url) {
        try {
            long contentLength;
            if (ResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            URLConnection con = url.openConnection();
            this.customizeConnection(con);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)con;
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code != 200) {
                    httpCon.disconnect();
                    return false;
                }
            } else if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                JarEntry jarEntry = jarCon.getJarEntry();
                if (jarEntry == null) {
                    return false;
                }
                return !jarEntry.isDirectory();
            }
            if ((contentLength = con.getContentLengthLong()) > 0L) {
                return true;
            }
            if (contentLength == 0L) {
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            URL url = this.getURL();
            if (url.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(url).isFile();
            }
            return "file".equals(url.getProtocol());
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url.getProtocol().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(url).getFile();
        }
        return ResourceUtils.getFile(url, this.getDescription());
    }

    @Override
    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractArchiveURL(url);
            if (actualUrl.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(actualUrl).getFile();
            }
            return ResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected boolean isFile(URI uri) {
        try {
            if (uri.getScheme().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(uri).isFile();
            }
            return "file".equals(uri.getScheme());
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected File getFile(URI uri) throws IOException {
        if (uri.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uri).getFile();
        }
        return ResourceUtils.getFile(uri, this.getDescription());
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        try {
            return FileChannel.open(this.getFile().toPath(), StandardOpenOption.READ);
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            return super.readableChannel();
        }
    }

    @Override
    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url)) {
            File file = this.getFile();
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its content length");
            }
            return length;
        }
        URLConnection con = url.openConnection();
        this.customizeConnection(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLengthLong();
    }

    @Override
    public long lastModified() throws IOException {
        long lastModified;
        URL url = this.getURL();
        boolean fileCheck = false;
        if (ResourceUtils.isFileURL(url) || ResourceUtils.isJarURL(url)) {
            fileCheck = true;
            try {
                File fileToCheck = this.getFileForLastModifiedCheck();
                lastModified = fileToCheck.lastModified();
                if (lastModified > 0L || fileToCheck.exists()) {
                    return lastModified;
                }
            }
            catch (FileNotFoundException fileToCheck) {
                // empty catch block
            }
        }
        URLConnection con = url.openConnection();
        this.customizeConnection(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        lastModified = con.getLastModified();
        if (fileCheck && lastModified == 0L && con.getContentLengthLong() <= 0L) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return lastModified;
    }

    protected void customizeConnection(URLConnection con) throws IOException {
        ResourceUtils.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            this.customizeConnection((HttpURLConnection)con);
        }
    }

    protected void customizeConnection(HttpURLConnection con) throws IOException {
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VfsUtils.getRoot(url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uri));
        }
    }
}

