/*
 * Decompiled with CFR 0.152.
 */
package io.github.secretx33.resourceresolver;

import io.github.secretx33.resourceresolver.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.jetbrains.annotations.Nullable;

abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 8192;

    FileCopyUtils() {
    }

    public static byte[] copyToByteArray(@Nullable InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        try (InputStream inputStream = in;){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        Assert.notNull(in, "No Reader specified");
        Assert.notNull(out, "No Writer specified");
        try {
            int charsRead;
            int charCount = 0;
            char[] buffer = new char[8192];
            while ((charsRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, charsRead);
                charCount += charsRead;
            }
            out.flush();
            int n = charCount;
            return n;
        }
        finally {
            FileCopyUtils.close(in);
            FileCopyUtils.close(out);
        }
    }

    public static String copyToString(@Nullable Reader in) throws IOException {
        if (in == null) {
            return "";
        }
        StringWriter out = new StringWriter(8192);
        FileCopyUtils.copy(in, out);
        return out.toString();
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

