/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.configuration.InteractiveReporterConfig;
import com.aventstack.extentreports.reporter.configuration.util.ResourceHelper;
import java.io.File;
import java.util.stream.Stream;

public class ExtentHtmlReporterConfig
extends InteractiveReporterConfig {
    private static final String REPORTER_NAME = "html";
    private static final String SEP = "/";
    private static final String CSS = "css/";
    private static final String JS = "js/";
    private static final String ICONS = "icons/";
    private static final String IMG = "img/";
    private Boolean offlineMode;
    private String resourceCDN;
    private String testViewChartLocation;
    private Boolean chartVisibleOnOpen;
    private Boolean enableTimeline;
    private Boolean disableToggleActionForPassedNode;
    private Boolean enableCategoryView;
    private Boolean enableAuthorView;
    private Boolean enableExceptionView;
    private Boolean enableTestRunnerLogsView;

    public void enableOfflineMode(Boolean offlineMode) {
        this.offlineMode = offlineMode;
        if (offlineMode.booleanValue() && this.reporter != null) {
            File f = Offline.getTargetDirectory(((ExtentHtmlReporter)this.reporter).getFile());
            Object resPackage = ExtentReports.class.getPackage().getName().replace(".", SEP);
            resPackage = (String)resPackage + "/offline/";
            String[] resx = Offline.combineAll();
            ResourceHelper.saveOfflineResources((String)resPackage, (String[])resx, (String)f.getAbsolutePath());
        }
    }

    private static Boolean $default$offlineMode() {
        return false;
    }

    private static String $default$resourceCDN() {
        return "github";
    }

    private static String $default$testViewChartLocation() {
        return "top";
    }

    private static Boolean $default$chartVisibleOnOpen() {
        return true;
    }

    private static Boolean $default$enableTimeline() {
        return true;
    }

    private static Boolean $default$disableToggleActionForPassedNode() {
        return false;
    }

    private static Boolean $default$enableCategoryView() {
        return true;
    }

    private static Boolean $default$enableAuthorView() {
        return true;
    }

    private static Boolean $default$enableExceptionView() {
        return true;
    }

    private static Boolean $default$enableTestRunnerLogsView() {
        return true;
    }

    protected ExtentHtmlReporterConfig(ExtentHtmlReporterConfigBuilder<?, ?> b) {
        super(b);
        this.offlineMode = b.offlineMode$set ? b.offlineMode$value : ExtentHtmlReporterConfig.$default$offlineMode();
        this.resourceCDN = b.resourceCDN$set ? b.resourceCDN$value : ExtentHtmlReporterConfig.$default$resourceCDN();
        this.testViewChartLocation = b.testViewChartLocation$set ? b.testViewChartLocation$value : ExtentHtmlReporterConfig.$default$testViewChartLocation();
        this.chartVisibleOnOpen = b.chartVisibleOnOpen$set ? b.chartVisibleOnOpen$value : ExtentHtmlReporterConfig.$default$chartVisibleOnOpen();
        this.enableTimeline = b.enableTimeline$set ? b.enableTimeline$value : ExtentHtmlReporterConfig.$default$enableTimeline();
        this.disableToggleActionForPassedNode = b.disableToggleActionForPassedNode$set ? b.disableToggleActionForPassedNode$value : ExtentHtmlReporterConfig.$default$disableToggleActionForPassedNode();
        this.enableCategoryView = b.enableCategoryView$set ? b.enableCategoryView$value : ExtentHtmlReporterConfig.$default$enableCategoryView();
        this.enableAuthorView = b.enableAuthorView$set ? b.enableAuthorView$value : ExtentHtmlReporterConfig.$default$enableAuthorView();
        this.enableExceptionView = b.enableExceptionView$set ? b.enableExceptionView$value : ExtentHtmlReporterConfig.$default$enableExceptionView();
        this.enableTestRunnerLogsView = b.enableTestRunnerLogsView$set ? b.enableTestRunnerLogsView$value : ExtentHtmlReporterConfig.$default$enableTestRunnerLogsView();
    }

    public static ExtentHtmlReporterConfigBuilder<?, ?> builder() {
        return new ExtentHtmlReporterConfigBuilderImpl();
    }

    public Boolean getOfflineMode() {
        return this.offlineMode;
    }

    public String getResourceCDN() {
        return this.resourceCDN;
    }

    public String getTestViewChartLocation() {
        return this.testViewChartLocation;
    }

    public Boolean getChartVisibleOnOpen() {
        return this.chartVisibleOnOpen;
    }

    public Boolean getEnableTimeline() {
        return this.enableTimeline;
    }

    public Boolean getDisableToggleActionForPassedNode() {
        return this.disableToggleActionForPassedNode;
    }

    public Boolean getEnableCategoryView() {
        return this.enableCategoryView;
    }

    public Boolean getEnableAuthorView() {
        return this.enableAuthorView;
    }

    public Boolean getEnableExceptionView() {
        return this.enableExceptionView;
    }

    public Boolean getEnableTestRunnerLogsView() {
        return this.enableTestRunnerLogsView;
    }

    public void setOfflineMode(Boolean offlineMode) {
        this.offlineMode = offlineMode;
    }

    public void setResourceCDN(String resourceCDN) {
        this.resourceCDN = resourceCDN;
    }

    public void setTestViewChartLocation(String testViewChartLocation) {
        this.testViewChartLocation = testViewChartLocation;
    }

    public void setChartVisibleOnOpen(Boolean chartVisibleOnOpen) {
        this.chartVisibleOnOpen = chartVisibleOnOpen;
    }

    public void setEnableTimeline(Boolean enableTimeline) {
        this.enableTimeline = enableTimeline;
    }

    public void setDisableToggleActionForPassedNode(Boolean disableToggleActionForPassedNode) {
        this.disableToggleActionForPassedNode = disableToggleActionForPassedNode;
    }

    public void setEnableCategoryView(Boolean enableCategoryView) {
        this.enableCategoryView = enableCategoryView;
    }

    public void setEnableAuthorView(Boolean enableAuthorView) {
        this.enableAuthorView = enableAuthorView;
    }

    public void setEnableExceptionView(Boolean enableExceptionView) {
        this.enableExceptionView = enableExceptionView;
    }

    public void setEnableTestRunnerLogsView(Boolean enableTestRunnerLogsView) {
        this.enableTestRunnerLogsView = enableTestRunnerLogsView;
    }

    private static class Offline {
        private Offline() {
        }

        private static File getTargetDirectory(File f) {
            Object dir = f.getAbsolutePath().replace("\\", ExtentHtmlReporterConfig.SEP);
            if (!f.isDirectory()) {
                dir = new File((String)dir).getParent();
            }
            dir = (String)dir + "/html";
            return new File((String)dir);
        }

        private static String[] combineAll() {
            return Offline.combine(Offline.getJSFiles(), Offline.getCSSFiles(), Offline.getIconFiles(), Offline.getImgFiles());
        }

        private static String[] combine(String[] ... array) {
            String[] result = new String[]{};
            for (String[] arr : array) {
                result = (String[])Stream.of(result, arr).flatMap(Stream::of).toArray(String[]::new);
            }
            return result;
        }

        private static String[] getJSFiles() {
            String reporterPath = "html/js/";
            String[] files = new String[]{"html/js/v3html-script.js", "html/js/jsontree.js", "html/js/attr.js", "html/js/dashboard.js"};
            return files;
        }

        private static String[] getCSSFiles() {
            String reporterPath = "html/css/";
            String[] files = new String[]{"html/css/v3html-style.css"};
            return files;
        }

        private static String[] getIconFiles() {
            String path = "html/css/icons/";
            String iconDirPath = "material/";
            String[] files = new String[]{"html/css/icons/material-icons.css", "html/css/icons/material/MaterialIcons-Regular.eot", "html/css/icons/material/MaterialIcons-Regular.svg", "html/css/icons/material/MaterialIcons-Regular.ttf", "html/css/icons/material/MaterialIcons-Regular.woff", "html/css/icons/material/MaterialIcons-Regular.woff2", "html/css/icons/material/MaterialIcons-Regular.ijmap"};
            return files;
        }

        private static String[] getImgFiles() {
            String path = "html/img/";
            String[] files = new String[]{"html/img/logo.png"};
            return files;
        }
    }

    public static abstract class ExtentHtmlReporterConfigBuilder<C extends ExtentHtmlReporterConfig, B extends ExtentHtmlReporterConfigBuilder<C, B>>
    extends InteractiveReporterConfig.InteractiveReporterConfigBuilder<C, B> {
        private boolean offlineMode$set;
        private Boolean offlineMode$value;
        private boolean resourceCDN$set;
        private String resourceCDN$value;
        private boolean testViewChartLocation$set;
        private String testViewChartLocation$value;
        private boolean chartVisibleOnOpen$set;
        private Boolean chartVisibleOnOpen$value;
        private boolean enableTimeline$set;
        private Boolean enableTimeline$value;
        private boolean disableToggleActionForPassedNode$set;
        private Boolean disableToggleActionForPassedNode$value;
        private boolean enableCategoryView$set;
        private Boolean enableCategoryView$value;
        private boolean enableAuthorView$set;
        private Boolean enableAuthorView$value;
        private boolean enableExceptionView$set;
        private Boolean enableExceptionView$value;
        private boolean enableTestRunnerLogsView$set;
        private Boolean enableTestRunnerLogsView$value;

        protected abstract B self();

        public abstract C build();

        public B offlineMode(Boolean offlineMode) {
            this.offlineMode$value = offlineMode;
            this.offlineMode$set = true;
            return (B)this.self();
        }

        public B resourceCDN(String resourceCDN) {
            this.resourceCDN$value = resourceCDN;
            this.resourceCDN$set = true;
            return (B)this.self();
        }

        public B testViewChartLocation(String testViewChartLocation) {
            this.testViewChartLocation$value = testViewChartLocation;
            this.testViewChartLocation$set = true;
            return (B)this.self();
        }

        public B chartVisibleOnOpen(Boolean chartVisibleOnOpen) {
            this.chartVisibleOnOpen$value = chartVisibleOnOpen;
            this.chartVisibleOnOpen$set = true;
            return (B)this.self();
        }

        public B enableTimeline(Boolean enableTimeline) {
            this.enableTimeline$value = enableTimeline;
            this.enableTimeline$set = true;
            return (B)this.self();
        }

        public B disableToggleActionForPassedNode(Boolean disableToggleActionForPassedNode) {
            this.disableToggleActionForPassedNode$value = disableToggleActionForPassedNode;
            this.disableToggleActionForPassedNode$set = true;
            return (B)this.self();
        }

        public B enableCategoryView(Boolean enableCategoryView) {
            this.enableCategoryView$value = enableCategoryView;
            this.enableCategoryView$set = true;
            return (B)this.self();
        }

        public B enableAuthorView(Boolean enableAuthorView) {
            this.enableAuthorView$value = enableAuthorView;
            this.enableAuthorView$set = true;
            return (B)this.self();
        }

        public B enableExceptionView(Boolean enableExceptionView) {
            this.enableExceptionView$value = enableExceptionView;
            this.enableExceptionView$set = true;
            return (B)this.self();
        }

        public B enableTestRunnerLogsView(Boolean enableTestRunnerLogsView) {
            this.enableTestRunnerLogsView$value = enableTestRunnerLogsView;
            this.enableTestRunnerLogsView$set = true;
            return (B)this.self();
        }

        public String toString() {
            return "ExtentHtmlReporterConfig.ExtentHtmlReporterConfigBuilder(super=" + super.toString() + ", offlineMode$value=" + this.offlineMode$value + ", resourceCDN$value=" + this.resourceCDN$value + ", testViewChartLocation$value=" + this.testViewChartLocation$value + ", chartVisibleOnOpen$value=" + this.chartVisibleOnOpen$value + ", enableTimeline$value=" + this.enableTimeline$value + ", disableToggleActionForPassedNode$value=" + this.disableToggleActionForPassedNode$value + ", enableCategoryView$value=" + this.enableCategoryView$value + ", enableAuthorView$value=" + this.enableAuthorView$value + ", enableExceptionView$value=" + this.enableExceptionView$value + ", enableTestRunnerLogsView$value=" + this.enableTestRunnerLogsView$value + ")";
        }
    }

    private static final class ExtentHtmlReporterConfigBuilderImpl
    extends ExtentHtmlReporterConfigBuilder<ExtentHtmlReporterConfig, ExtentHtmlReporterConfigBuilderImpl> {
        private ExtentHtmlReporterConfigBuilderImpl() {
        }

        @Override
        protected ExtentHtmlReporterConfigBuilderImpl self() {
            return this;
        }

        @Override
        public ExtentHtmlReporterConfig build() {
            return new ExtentHtmlReporterConfig(this);
        }
    }
}

