/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.object.java.lang;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public interface Either<A, E extends Exception> {
    public Either<A, E> ifSuccess(Consumer<A> var1);

    public Either<A, E> ifFailure(Consumer<E> var1);

    default public <R, Y extends Exception> Either<R, Y> andThen(Function<R, A, Y> fn, java.util.function.Function<E, Y> eFn) {
        AtomicReference result = new AtomicReference();
        this.ifSuccess(t -> {
            try {
                Object value = fn.code(t);
                result.set(new Success(value));
            }
            catch (Exception e) {
                result.set(new Failure(e));
            }
        }).ifFailure(oe -> result.set(new Failure((Exception)eFn.apply(oe))));
        return (Either)result.get();
    }

    public static <T, X extends Exception> Either<T, X> wrap(Supplier<T, X> th) {
        try {
            T value = th.code();
            return new Success(value);
        }
        catch (Exception excep) {
            return new Failure(excep);
        }
    }

    public static <T, X extends Exception> Either<T, X> fail(X exception) {
        return new Failure(exception);
    }

    public static <T, X extends Exception> Either<T, X> succ(T value) {
        return new Success(value);
    }

    public static final class Success<A, E extends Exception>
    implements Either<A, E> {
        private final A value;

        Success(A value) {
            this.value = value;
        }

        @Override
        public Either<A, E> ifSuccess(Consumer<A> action) {
            action.accept(this.value);
            return this;
        }

        @Override
        public Either<A, E> ifFailure(Consumer<E> action) {
            return this;
        }
    }

    public static final class Failure<A, E extends Exception>
    implements Either<A, E> {
        private final E excep;

        Failure(E excep) {
            this.excep = excep;
        }

        @Override
        public Either<A, E> ifSuccess(Consumer<A> action) {
            return this;
        }

        @Override
        public Either<A, E> ifFailure(Consumer<E> action) {
            action.accept(this.excep);
            return this;
        }
    }

    public static interface Function<A, R, E extends Exception> {
        public A code(R var1) throws E;
    }

    public static interface Supplier<A, E extends Exception> {
        public A code() throws E;
    }
}

