/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.parser.json;

import io.github.senthilganeshs.parser.json.Parser;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public interface Generator {
    public String generate(Parser.Value var1);

    public static Generator create() {
        return Simple.INSTANCE;
    }

    public static enum Simple implements Generator
    {
        INSTANCE;


        @Override
        public String generate(Parser.Value value) {
            StringBuilder bld = new StringBuilder();
            value.isNull(() -> bld.append("null"));
            value.isString(str -> bld.append("\"" + str + "\""));
            value.isInteger(bld::append);
            value.isDouble(bld::append);
            value.isBool(bld::append);
            if (!bld.toString().isEmpty()) {
                return bld.toString();
            }
            ArrayList array = new ArrayList();
            boolean isArray = value instanceof Parser.Value.ArrayValue;
            value.isArray(v -> array.add(this.generate((Parser.Value)v)));
            if (isArray) {
                bld.append("[");
                array.stream().reduce((lhs, rhs) -> lhs + "," + rhs).ifPresent(bld::append);
                bld.append("]");
                return bld.toString();
            }
            LinkedHashMap map = new LinkedHashMap();
            boolean isMap = value instanceof Parser.Value.JSONValue;
            value.isJSON((k, v) -> map.put(this.generate((Parser.Value)k), this.generate((Parser.Value)v)));
            if (isMap) {
                bld.append("{");
                map.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).reduce((lhs, rhs) -> lhs + "," + rhs).ifPresent(bld::append);
                bld.append("}");
            }
            return bld.toString();
        }
    }
}

