/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.parser.json;

import io.github.senthilganeshs.object.java.lang.Either;
import io.github.senthilganeshs.parser.json.StreamParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface Parser {
    public static final Parser ALL = Parser.empty(Parser.trimmed(Parser.nil(Parser.bool(Parser.string(Parser.integer(Parser.number(Parser.array(Parser.json(Parser.fail("unknown Parser"))))))))));

    public Either<Value, JSONParserException> parse(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Either<Value, JSONParserException> parse(InputStream stream) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
            String line = null;
            StringBuilder document = new StringBuilder();
            do {
                try {
                    line = in.readLine();
                    if (line == null) continue;
                    document.append(line);
                }
                catch (IOException e) {
                    break;
                }
            } while (line != null);
            Either<Value, JSONParserException> either = this.parse(document.toString());
            return either;
        }
        catch (IOException e1) {
            return Either.fail(new JSONParserException(e1));
        }
    }

    public static Parser streamParser() {
        return StreamParser.streamParser();
    }

    public static Parser simple() {
        return new Simple();
    }

    public static Parser create() {
        return Parser.streamParser();
    }

    public static Parser json(Parser other) {
        return new JSONParser(other);
    }

    public static Parser array(Parser other) {
        return new ArrayParser(other);
    }

    public static Parser integer(Parser other) {
        return new IntParser(other);
    }

    public static Parser number(Parser other) {
        return new NumberParser(other);
    }

    public static Parser string(Parser other) {
        return new StringParser(other);
    }

    public static Parser nil(Parser other) {
        return new NilParser(other);
    }

    public static Parser bool(Parser other) {
        return new BoolParser(other);
    }

    public static Parser fail(JSONParserException e) {
        return token -> Either.fail(e);
    }

    public static Parser fail(String msg) {
        return Parser.fail(new JSONParserException(msg));
    }

    public static Parser empty(Parser other) {
        return token -> {
            if (token == null || token.isEmpty()) {
                return Either.fail(new JSONParserException("empty document"));
            }
            return other.parse(token);
        };
    }

    public static Parser trimmed(Parser other) {
        return token -> other.parse(token.trim());
    }

    public static final class JSONParserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        JSONParserException(Throwable e) {
            super(e);
        }

        JSONParserException(String msg) {
            super(msg);
        }
    }

    public static interface Value {
        default public Value isString(Consumer<String> action) {
            return this;
        }

        default public Value isBool(Consumer<Boolean> action) {
            return this;
        }

        default public Value isError(Consumer<String> action) {
            return this;
        }

        default public Value isInteger(Consumer<Long> action) {
            return this;
        }

        default public Value isDouble(Consumer<Double> action) {
            return this;
        }

        default public Value isArray(Consumer<Value> action) {
            return this;
        }

        default public Value isArrayAt(int index, Consumer<Value> action) {
            return this;
        }

        default public Value isNull(Thunk action) {
            return this;
        }

        default public Value isJSON(BiConsumer<Value, Value> action) {
            return this;
        }

        default public Value isJSONKey(Value key, Consumer<Value> action) {
            return this;
        }

        public static Value nil() {
            return new NilValue();
        }

        public static Value string(String value) {
            return new StringValue(value);
        }

        public static Value bool(boolean value) {
            return new BoolValue(value);
        }

        public static Value integer(long value) {
            return new IntValue(value);
        }

        public static Value number(double value) {
            return new DoubleValue(value);
        }

        public static Value err(String value) {
            return new ErrorValue(value);
        }

        public static Value arr(List<Value> values) {
            return new ArrayValue(values);
        }

        public static Value json(Map<Value, Value> values) {
            return new JSONValue(values);
        }

        public static final class ErrorValue
        implements Value {
            private final String msg;

            ErrorValue(String msg) {
                this.msg = msg;
            }

            @Override
            public Value isError(Consumer<String> action) {
                action.accept(this.msg);
                return this;
            }
        }

        public static final class StringValue
        implements Value {
            private final String value;

            StringValue(String value) {
                this.value = this.withoutQuotes(value);
            }

            private String withoutQuotes(String value) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    return value.substring(1, value.length() - 1);
                }
                return value;
            }

            @Override
            public Value isString(Consumer<String> action) {
                action.accept(this.value);
                return this;
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public boolean equals(Object other) {
                if (other == null) {
                    return false;
                }
                if (other == this) {
                    return true;
                }
                if (other instanceof StringValue) {
                    return ((StringValue)other).value.equals(this.value);
                }
                return false;
            }
        }

        public static final class BoolValue
        implements Value {
            private final boolean value;

            BoolValue(boolean value) {
                this.value = value;
            }

            @Override
            public Value isBool(Consumer<Boolean> action) {
                action.accept(this.value);
                return this;
            }
        }

        public static final class NilValue
        implements Value {
            @Override
            public Value isNull(Thunk action) {
                action.code();
                return this;
            }
        }

        public static final class ArrayValue
        implements Value {
            private final List<Value> values;

            ArrayValue(List<Value> values) {
                this.values = values;
            }

            @Override
            public Value isArray(Consumer<Value> action) {
                this.values.forEach(action);
                return this;
            }

            @Override
            public Value isArrayAt(int index, Consumer<Value> action) {
                if (index < 0 || index >= this.values.size()) {
                    throw new IndexOutOfBoundsException("index out of range");
                }
                action.accept(this.values.get(index));
                return this;
            }
        }

        public static final class JSONValue
        implements Value {
            private final Map<Value, Value> map;

            JSONValue(Map<Value, Value> map) {
                this.map = map;
            }

            @Override
            public Value isJSON(BiConsumer<Value, Value> action) {
                this.map.entrySet().forEach(e -> action.accept((Value)e.getKey(), (Value)e.getValue()));
                return this;
            }

            @Override
            public Value isJSONKey(Value key, Consumer<Value> action) {
                if (key != null && this.map.containsKey(key)) {
                    action.accept(this.map.get(key));
                }
                return this;
            }
        }

        public static final class DoubleValue
        implements Value {
            private final double value;

            DoubleValue(double value) {
                this.value = value;
            }

            @Override
            public Value isDouble(Consumer<Double> action) {
                action.accept(this.value);
                return this;
            }
        }

        public static final class IntValue
        implements Value {
            private final long value;

            IntValue(long value) {
                this.value = value;
            }

            @Override
            public Value isInteger(Consumer<Long> action) {
                action.accept(this.value);
                return this;
            }
        }
    }

    public static interface Thunk {
        public void code();
    }

    public static final class JSONParser
    implements Parser {
        private final Parser other;

        JSONParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String token) {
            if (token.startsWith("{") && token.endsWith("}")) {
                HashMap<Value, Value> map = new HashMap<Value, Value>();
                String inner = token.substring(1, token.length() - 1);
                int nbr = 0;
                int nb = 0;
                int vs = 0;
                int ks = 0;
                String key = "";
                AtomicBoolean isOpen = new AtomicBoolean(false);
                int quotes = 0;
                for (int i = 0; i < inner.length(); ++i) {
                    String _key;
                    if (!Character.isWhitespace(inner.charAt(i))) {
                        if (inner.charAt(i) == '{') {
                            ++nbr;
                        } else if (inner.charAt(i) == '}') {
                            --nbr;
                        } else if (inner.charAt(i) == '[') {
                            ++nb;
                        } else if (inner.charAt(i) == ']') {
                            --nb;
                        } else if (inner.charAt(i) == '\"') {
                            if (isOpen.compareAndSet(false, true)) {
                                ++quotes;
                            } else if (isOpen.compareAndSet(true, false)) {
                                --quotes;
                            }
                        } else if (inner.charAt(i) == ',') {
                            if (nbr == 0 && nb == 0 && quotes == 0) {
                                ks = i + 1;
                                _key = key;
                                ALL.parse(inner.substring(vs, i).trim()).ifSuccess(value -> {
                                    if (!_key.isEmpty()) {
                                        map.put(Value.string(_key), (Value)value);
                                    }
                                });
                                key = "";
                            }
                        } else if (inner.charAt(i) == ':' && nbr == 0 && nb == 0 && quotes == 0) {
                            key = inner.substring(ks, i).trim();
                            vs = i + 1;
                        }
                    }
                    if (i != inner.length() - 1 || nbr != 0 || nb != 0 || quotes != 0) continue;
                    _key = key;
                    ALL.parse(inner.substring(vs, i + 1).trim()).ifSuccess(value -> map.put(Value.string(_key), (Value)value));
                }
                return Either.succ(Value.json(map));
            }
            return this.other.parse(token);
        }
    }

    public static final class ArrayParser
    implements Parser {
        private final Parser other;

        ArrayParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String token) {
            if (token.charAt(0) == '[' && token.charAt(token.length() - 1) == ']') {
                ArrayList<Value> values = new ArrayList<Value>();
                String inner = token.substring(1, token.length() - 1);
                int nb = 0;
                int nbr = 0;
                int s = 0;
                AtomicBoolean isOpen = new AtomicBoolean(false);
                int quotes = 0;
                for (int i = 0; i < inner.length(); ++i) {
                    if (Character.isWhitespace(inner.charAt(i))) continue;
                    if (inner.charAt(i) == '[') {
                        ++nb;
                    } else if (inner.charAt(i) == ']') {
                        --nb;
                    } else if (inner.charAt(i) == '{') {
                        ++nbr;
                    } else if (inner.charAt(i) == '}') {
                        --nbr;
                    } else if (inner.charAt(i) == ',') {
                        if (nb == 0 && nbr == 0 && quotes == 0) {
                            values.add(this.asValue(inner.substring(s, i)));
                            s = i + 1;
                        }
                    } else if (inner.charAt(i) == '\"') {
                        if (isOpen.compareAndSet(false, true)) {
                            ++quotes;
                        } else if (isOpen.compareAndSet(true, false)) {
                            --quotes;
                        }
                    }
                    if (i != inner.length() - 1 || nbr != 0 || nb != 0 || quotes != 0) continue;
                    ALL.parse(inner.substring(s, i + 1).trim()).ifSuccess(values::add);
                }
                return Either.succ(Value.arr(values));
            }
            return this.other.parse(token);
        }

        private Value asValue(String value) {
            AtomicReference result = new AtomicReference();
            AtomicReference excep = new AtomicReference();
            ALL.parse(value).ifSuccess(result::set).ifFailure(excep::set);
            if (excep.get() != null) {
                return Value.err(((JSONParserException)excep.get()).getLocalizedMessage());
            }
            return (Value)result.get();
        }
    }

    public static final class StringParser
    implements Parser {
        private final Parser other;

        StringParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String token) {
            if (token.startsWith("\"")) {
                int start = token.indexOf(34);
                int end = token.lastIndexOf(34);
                if (start == 0 && end == token.length() - 1) {
                    return Either.succ(Value.string(token.substring(start, end + 1)));
                }
                return Either.succ(Value.err(String.format("Parser error at %d\n%s\n%s\n%s", end + 1, token, this.dashes(end + 1), "Expecting 'EOF', '}', ':', ']', got " + token.substring(end + 1))));
            }
            return this.other.parse(token);
        }

        private final String dashes(int pos) {
            int dash = 45;
            StringBuilder bld = new StringBuilder();
            for (int i = 0; i < pos; ++i) {
                bld.append('-');
            }
            bld.append("^");
            return bld.toString();
        }
    }

    public static final class NumberParser
    implements Parser {
        private final Parser other;

        NumberParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String document) {
            try {
                return Either.succ(Value.number(Double.parseDouble(document)));
            }
            catch (NumberFormatException e) {
                return this.other.parse(document);
            }
        }
    }

    public static final class IntParser
    implements Parser {
        private final Parser other;

        IntParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String document) {
            try {
                return Either.succ(Value.integer(Long.parseLong(document)));
            }
            catch (NumberFormatException e) {
                return this.other.parse(document);
            }
        }
    }

    public static final class BoolParser
    implements Parser {
        private final Parser other;

        BoolParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String token) {
            if (token.equals("true") || token.equals("false")) {
                return Either.succ(Value.bool(Boolean.parseBoolean(token)));
            }
            return this.other.parse(token);
        }
    }

    public static final class NilParser
    implements Parser {
        private final Parser other;

        NilParser(Parser other) {
            this.other = other;
        }

        @Override
        public Either<Value, JSONParserException> parse(String token) {
            if (token.equals("null")) {
                return Either.succ(Value.nil());
            }
            return this.other.parse(token);
        }
    }

    public static final class Simple
    implements Parser {
        @Override
        public Either<Value, JSONParserException> parse(String document) {
            return ALL.parse(document);
        }
    }
}

