/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.parser.json;

import io.github.senthilganeshs.object.java.lang.Either;
import io.github.senthilganeshs.parser.json.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface StreamParser {
    public static final StreamParser NIL_PARSER = new NilParser();
    public static final StreamParser INTEGER_PARSER = new IntegerParser();
    public static final StreamParser NUMBER_PARSER = new NumberParser();
    public static final StreamParser STRING_PARSER = new StringParser();
    public static final StreamParser BOOLEAN_PARSER = new BooleanParser();
    public static final StreamParser ARRAY_PARSER = new ArrayParser();
    public static final StreamParser JSON_PARSER = new JSONParser();

    public Parser.Value consume(ByteReader var1);

    public static Parser streamParser() {
        return new Parser2();
    }

    public static StreamParser all(char ch) {
        if (ch == '{') {
            return JSON_PARSER;
        }
        if (ch == '[') {
            return ARRAY_PARSER;
        }
        return StreamParser.primitive(ch);
    }

    public static StreamParser primitive(char ch) {
        if (ch == '\"') {
            return STRING_PARSER;
        }
        if (ch == 't' || ch == 'f') {
            return BOOLEAN_PARSER;
        }
        if (ch == 'n') {
            return NIL_PARSER;
        }
        return new IntOrNumberParser(ch);
    }

    public static Parser.Value primitive(char ch, ByteReader reader) {
        return StreamParser.primitive(ch).consume(reader);
    }

    public static final class NilParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder bld = new StringBuilder();
            char[] allowed = new char[]{'u', 'l', 'l'};
            AtomicInteger index = new AtomicInteger();
            reader.read(ch -> index.get() < 3 && allowed[index.getAndIncrement()] == ch.charValue(), bld::append);
            if (index.get() != 2) {
                return Parser.Value.err("null is expected");
            }
            return Parser.Value.nil();
        }
    }

    public static final class NumberParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder numberValue = new StringBuilder();
            reader.read(ch -> Character.isDigit(ch.charValue()) || ch.charValue() == '.' || ch.charValue() == 'e' || ch.charValue() == '+', numberValue::append);
            return Parser.Value.number(Double.parseDouble(numberValue.toString()));
        }
    }

    public static final class BooleanParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder boolValue = new StringBuilder();
            AtomicInteger index = new AtomicInteger(-1);
            StringBuilder expected = new StringBuilder();
            reader.read(ch -> {
                if (expected.length() == 0) {
                    if (ch.charValue() == 'r') {
                        boolValue.append('t');
                        expected.append("rue");
                    } else if (ch.charValue() == 'a') {
                        boolValue.append('f');
                        expected.append("alse");
                    }
                }
                index.incrementAndGet();
                return index.get() < expected.length() && ch.charValue() == expected.charAt(index.get());
            }, boolValue::append);
            return Parser.Value.bool(Boolean.parseBoolean(boolValue.toString()));
        }
    }

    public static final class IntegerParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder longValue = new StringBuilder();
            reader.read(Character::isDigit, longValue::append);
            return Parser.Value.integer(Long.parseLong(longValue.toString()));
        }
    }

    public static final class StringParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder value = new StringBuilder();
            reader.read(ch -> ch.charValue() != '\"', value::append);
            reader.skipOne(ch -> ch.charValue() == '\"');
            return Parser.Value.string(value.toString());
        }
    }

    public static final class JSONParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            LinkedHashMap<Parser.Value, Parser.Value> map = new LinkedHashMap<Parser.Value, Parser.Value>();
            AtomicBoolean isKey = new AtomicBoolean(true);
            AtomicReference key = new AtomicReference();
            AtomicReference value = new AtomicReference();
            reader.skipAll(Character::isWhitespace);
            reader.read(ch -> ch.charValue() != '}', ch -> {
                if (!Character.isWhitespace(ch.charValue())) {
                    if (ch.charValue() == ':') {
                        isKey.set(false);
                    } else if (ch.charValue() == ',') {
                        isKey.set(true);
                        map.put((Parser.Value)key.get(), (Parser.Value)value.get());
                    } else if (ch.charValue() == '\"') {
                        if (isKey.get()) {
                            key.set(StreamParser.primitive(ch.charValue(), reader));
                        } else {
                            value.set(StreamParser.primitive(ch.charValue(), reader));
                        }
                    } else if (ch.charValue() == '[') {
                        if (!isKey.get()) {
                            value.set(ARRAY_PARSER.consume(reader));
                        } else {
                            value.set(Parser.Value.err("array detected in place of key. Allowed types are [string]"));
                        }
                    } else if (ch.charValue() == '{') {
                        if (!isKey.get()) {
                            value.set(JSON_PARSER.consume(reader));
                        } else {
                            key.set(Parser.Value.err("json detected in place of key. Allowed types are [string]"));
                        }
                    } else if (isKey.get()) {
                        key.set(Parser.Value.err("key cannot be non string type."));
                    } else {
                        value.set(StreamParser.primitive(ch.charValue(), reader));
                    }
                }
            });
            map.put((Parser.Value)key.get(), (Parser.Value)value.get());
            reader.skipOne(ch -> ch.charValue() == '}');
            return Parser.Value.json(map);
        }
    }

    public static final class ArrayParser
    implements StreamParser {
        @Override
        public Parser.Value consume(ByteReader reader) {
            ArrayList<Parser.Value> values = new ArrayList<Parser.Value>();
            reader.skipAll(Character::isWhitespace);
            reader.read(ch -> ch.charValue() != ']', ch -> {
                if (!Character.isWhitespace(ch.charValue()) && ch.charValue() != ',') {
                    if (ch.charValue() == '{') {
                        values.add(JSON_PARSER.consume(reader));
                    } else if (ch.charValue() == '[') {
                        values.add(ARRAY_PARSER.consume(reader));
                    } else {
                        values.add(StreamParser.primitive(ch.charValue(), reader));
                    }
                }
            });
            reader.skipOne(ch -> ch.charValue() == ']');
            return Parser.Value.arr(values);
        }
    }

    public static final class IntOrNumberParser
    implements StreamParser {
        private final char first;

        IntOrNumberParser(char first) {
            this.first = first;
        }

        @Override
        public Parser.Value consume(ByteReader reader) {
            StringBuilder bld = new StringBuilder();
            bld.append(this.first);
            AtomicBoolean isNumber = new AtomicBoolean(false);
            reader.read(ch -> Character.isDigit(ch.charValue()) || ch.charValue() == '.' || ch.charValue() == 'e' || ch.charValue() == '+', ch -> {
                if (Character.isDigit(ch.charValue())) {
                    bld.append(ch);
                } else if (ch.charValue() == '.' || ch.charValue() == 'e' || ch.charValue() == '+') {
                    isNumber.set(true);
                    bld.append(ch);
                }
            });
            if (isNumber.get()) {
                return Parser.Value.number(Double.parseDouble(bld.toString()));
            }
            return Parser.Value.integer(Long.parseLong(bld.toString()));
        }
    }

    public static interface ByteReader {
        public ByteReader read(Predicate<Character> var1, Consumer<Character> var2);

        public ByteReader skipOne(Predicate<Character> var1);

        public ByteReader skipAll(Predicate<Character> var1);

        public static final class StringByteReader
        implements ByteReader {
            private final String document;
            private int cursor;

            StringByteReader(String document) {
                this.document = document;
                this.cursor = 0;
            }

            @Override
            public ByteReader skipOne(Predicate<Character> cond) {
                if (cond.test(Character.valueOf(this.document.charAt(this.cursor)))) {
                    ++this.cursor;
                }
                return this;
            }

            @Override
            public ByteReader skipAll(Predicate<Character> cond) {
                while (this.cursor < this.document.length() - 1 && cond.test(Character.valueOf(this.document.charAt(this.cursor)))) {
                    ++this.cursor;
                }
                return this;
            }

            @Override
            public ByteReader read(Predicate<Character> cond, Consumer<Character> action) {
                while (this.cursor < this.document.length() && cond.test(Character.valueOf(this.document.charAt(this.cursor)))) {
                    ((Consumer<Character>)ch -> {
                        ++this.cursor;
                        action.accept((Character)ch);
                    }).accept(Character.valueOf(this.document.charAt(this.cursor)));
                }
                return this;
            }
        }

        public static final class StreamByteReader
        implements ByteReader {
            private final InputStream reader;
            private final byte[] buf;
            private final int BUF_SIZE = 8192;
            private int last;
            private int cursor;

            public StreamByteReader(InputStream is) {
                this.reader = is;
                this.buf = new byte[8192];
                this.cursor = 0;
                try {
                    this.last = is.read(this.buf, 0, 8192);
                }
                catch (IOException e) {
                    this.last = -1;
                }
            }

            @Override
            public ByteReader read(Predicate<Character> cond, Consumer<Character> action) {
                while (this.last != -1 && cond.test(Character.valueOf((char)this.buf[this.cursor]))) {
                    ((Consumer<Character>)ch -> {
                        try {
                            if (this.cursor == this.last - 1) {
                                this.last = this.last == 8192 ? this.reader.read(this.buf, 0, 8192) : this.reader.read(this.buf, this.last, 8192 - this.last);
                                this.cursor = 0;
                            } else {
                                ++this.cursor;
                            }
                        }
                        catch (IOException e) {
                            this.last = -1;
                        }
                        action.accept((Character)ch);
                    }).accept(Character.valueOf((char)this.buf[this.cursor]));
                }
                return this;
            }

            @Override
            public ByteReader skipOne(Predicate<Character> cond) {
                if (this.last != -1 && cond.test(Character.valueOf((char)this.buf[this.cursor]))) {
                    try {
                        if (this.cursor == this.last - 1) {
                            this.last = this.last == 8192 ? this.reader.read(this.buf, 0, 8192) : this.reader.read(this.buf, this.last, 8192 - this.last);
                            this.cursor = 0;
                        } else {
                            ++this.cursor;
                        }
                    }
                    catch (IOException e) {
                        this.last = -1;
                    }
                }
                return this;
            }

            @Override
            public ByteReader skipAll(Predicate<Character> cond) {
                try {
                    while (this.last != -1 && cond.test(Character.valueOf((char)this.buf[this.cursor]))) {
                        if (this.cursor == this.last - 1) {
                            this.last = this.last == 8192 ? this.reader.read(this.buf, 0, 8192) : this.reader.read(this.buf, this.last, 8192 - this.last);
                            this.cursor = 0;
                            continue;
                        }
                        ++this.cursor;
                    }
                }
                catch (IOException e) {
                    this.last = -1;
                }
                return this;
            }
        }
    }

    public static final class Parser2
    implements Parser {
        Parser2() {
        }

        @Override
        public Either<Parser.Value, Parser.JSONParserException> parse(String document) {
            if (document == null || document.isEmpty()) {
                return Either.fail(new Parser.JSONParserException("empty json"));
            }
            ByteReader.StringByteReader reader = new ByteReader.StringByteReader(document);
            return Either.succ(new StreamParser(){

                @Override
                public Parser.Value consume(ByteReader reader) {
                    AtomicReference val = new AtomicReference();
                    reader.skipAll(Character::isWhitespace);
                    reader.read(i -> true, ch -> val.set(StreamParser.all(ch.charValue()).consume(reader)));
                    return (Parser.Value)val.get();
                }
            }.consume(reader));
        }

        @Override
        public Either<Parser.Value, Parser.JSONParserException> parse(InputStream stream) {
            ByteReader.StreamByteReader reader = new ByteReader.StreamByteReader(stream);
            return Either.succ(new StreamParser(){

                @Override
                public Parser.Value consume(ByteReader reader) {
                    AtomicReference val = new AtomicReference();
                    reader.skipAll(Character::isWhitespace);
                    reader.read(i -> true, ch -> val.set(StreamParser.all(ch.charValue()).consume(reader)));
                    return (Parser.Value)val.get();
                }
            }.consume(reader));
        }
    }
}

