/*
 * Decompiled with CFR 0.152.
 */
package faker.com.fasterxml.jackson.module.kotlin;

import faker.com.fasterxml.jackson.databind.BeanDescription;
import faker.com.fasterxml.jackson.databind.DeserializationConfig;
import faker.com.fasterxml.jackson.databind.JavaType;
import faker.com.fasterxml.jackson.databind.KeyDeserializer;
import faker.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import faker.com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import faker.com.fasterxml.jackson.module.kotlin.ReflectionCache;
import faker.com.fasterxml.jackson.module.kotlin.UByteKeyDeserializer;
import faker.com.fasterxml.jackson.module.kotlin.UIntKeyDeserializer;
import faker.com.fasterxml.jackson.module.kotlin.ULongKeyDeserializer;
import faker.com.fasterxml.jackson.module.kotlin.UShortKeyDeserializer;
import faker.com.fasterxml.jackson.module.kotlin.ValueClassKeyDeserializer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfaker/com/fasterxml/jackson/module/kotlin/KotlinKeyDeserializers;", "Lfaker/com/fasterxml/jackson/databind/deser/std/StdKeyDeserializers;", "cache", "Lfaker/com/fasterxml/jackson/module/kotlin/ReflectionCache;", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;)V", "findKeyDeserializer", "Lfaker/com/fasterxml/jackson/databind/KeyDeserializer;", "type", "Lfaker/com/fasterxml/jackson/databind/JavaType;", "config", "Lfaker/com/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lfaker/com/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinKeyDeserializers
extends StdKeyDeserializers {
    @NotNull
    private final ReflectionCache cache;

    public KotlinKeyDeserializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Override
    @Nullable
    public KeyDeserializer findKeyDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        KeyDeserializer keyDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class<?> rawClass = type.getRawClass();
        if (Intrinsics.areEqual(rawClass, UByte.class)) {
            keyDeserializer = UByteKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, UShort.class)) {
            keyDeserializer = UShortKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, UInt.class)) {
            keyDeserializer = UIntKeyDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual(rawClass, ULong.class)) {
            keyDeserializer = ULongKeyDeserializer.INSTANCE;
        } else {
            Intrinsics.checkNotNull(rawClass);
            keyDeserializer = InternalCommonsKt.isUnboxableValueClass(rawClass) ? (KeyDeserializer)ValueClassKeyDeserializer.Companion.createOrNull(JvmClassMappingKt.getKotlinClass(rawClass), this.cache) : null;
        }
        return keyDeserializer;
    }
}

