/*
 * Decompiled with CFR 0.152.
 */
package faker.com.fasterxml.jackson.module.kotlin;

import faker.com.fasterxml.jackson.databind.BeanDescription;
import faker.com.fasterxml.jackson.databind.JavaType;
import faker.com.fasterxml.jackson.databind.JsonSerializer;
import faker.com.fasterxml.jackson.databind.SerializationConfig;
import faker.com.fasterxml.jackson.databind.ser.Serializers;
import faker.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import faker.com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import faker.com.fasterxml.jackson.module.kotlin.ValueClassStaticJsonKeySerializer;
import faker.com.fasterxml.jackson.module.kotlin.ValueClassUnboxKeySerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lfaker/com/fasterxml/jackson/module/kotlin/KotlinKeySerializers;", "Lfaker/com/fasterxml/jackson/databind/ser/Serializers$Base;", "()V", "findSerializer", "Lfaker/com/fasterxml/jackson/databind/JsonSerializer;", "config", "Lfaker/com/fasterxml/jackson/databind/SerializationConfig;", "type", "Lfaker/com/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lfaker/com/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinKeySerializers
extends Serializers.Base {
    @Override
    @Nullable
    public JsonSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Class<?> clazz = type.getRawClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getRawClass(...)");
        if (InternalCommonsKt.isUnboxableValueClass(clazz)) {
            Class<?> clazz2 = type.getRawClass();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"getRawClass(...)");
            StdSerializer stdSerializer = ValueClassStaticJsonKeySerializer.Companion.createOrNull(clazz2);
            if (stdSerializer == null) {
                stdSerializer = ValueClassUnboxKeySerializer.INSTANCE;
            }
            jsonSerializer = stdSerializer;
        } else {
            jsonSerializer = null;
        }
        return jsonSerializer;
    }
}

