/*
 * Decompiled with CFR 0.152.
 */
package io.github.setchy.dgs.formatters.strings;

import com.netflix.graphql.dgs.DgsDirective;
import graphql.GraphQLException;
import graphql.language.IntValue;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.InputValueWithState;
import io.github.setchy.dgs.formatters.exception.ExceptionUtils;
import io.github.setchy.dgs.formatters.strings.AbstractStringDirective;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@DgsDirective(name="abbreviate")
public class AbbreviateDirective
extends AbstractStringDirective {
    @Override
    public String applyFormatting(GraphQLFieldDefinition field, String value) {
        IntValue width = Optional.ofNullable(field.getAppliedDirective("abbreviate")).map(directive -> directive.getArgument("width")).map(GraphQLAppliedDirectiveArgument::getArgumentValue).map(InputValueWithState::getValue).filter(IntValue.class::isInstance).orElse(null);
        if (Objects.isNull(width)) {
            throw new GraphQLException(ExceptionUtils.formatExceptionMessage("abbreviate", "width"));
        }
        return StringUtils.abbreviate((String)value, (int)width.getValue().intValue());
    }
}

