/*
 * Decompiled with CFR 0.152.
 */
package io.github.setchy.dgs.formatters.strings;

import com.netflix.graphql.dgs.DgsDirective;
import graphql.GraphQLException;
import graphql.language.StringValue;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.InputValueWithState;
import io.github.setchy.dgs.formatters.exception.ExceptionUtils;
import io.github.setchy.dgs.formatters.protobuf.OpaqueResourceIDProto;
import io.github.setchy.dgs.formatters.strings.AbstractStringDirective;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;

@DgsDirective(name="resourceId")
public class ResourceIdDirective
extends AbstractStringDirective {
    @Override
    public String applyFormatting(GraphQLFieldDefinition field, String value) {
        GraphQLAppliedDirective appliedDirective = field.getAppliedDirective("resourceId");
        StringValue domain = Optional.ofNullable(appliedDirective.getArgument("domain")).map(GraphQLAppliedDirectiveArgument::getArgumentValue).map(InputValueWithState::getValue).filter(StringValue.class::isInstance).orElse(null);
        StringValue subdomain = Optional.ofNullable(appliedDirective.getArgument("subdomain")).map(GraphQLAppliedDirectiveArgument::getArgumentValue).map(InputValueWithState::getValue).filter(StringValue.class::isInstance).orElse(null);
        StringValue systemName = Optional.ofNullable(appliedDirective.getArgument("systemName")).map(GraphQLAppliedDirectiveArgument::getArgumentValue).map(InputValueWithState::getValue).filter(StringValue.class::isInstance).orElse(null);
        if (Objects.isNull(domain)) {
            throw new GraphQLException(ExceptionUtils.formatExceptionMessage("resourceId", "domain"));
        }
        if (Objects.isNull(subdomain)) {
            throw new GraphQLException(ExceptionUtils.formatExceptionMessage("resourceId", "subdomain"));
        }
        if (Objects.isNull(systemName)) {
            throw new GraphQLException(ExceptionUtils.formatExceptionMessage("resourceId", "systemName"));
        }
        return this.createOpaqueResourceID(domain.getValue(), subdomain.getValue(), systemName.getValue(), value);
    }

    private String createOpaqueResourceID(String domain, String subdomain, String systemName, String systemID) {
        OpaqueResourceIDProto.OpaqueResourceID opaqueResourceIDProto = OpaqueResourceIDProto.OpaqueResourceID.newBuilder().setDomain(domain).setSubdomain(subdomain).setSystemName(systemName).setSystemID(systemID).build();
        byte[] bytesProto = opaqueResourceIDProto.toByteArray();
        return Base64.getEncoder().encodeToString(bytesProto);
    }
}

